      SUBROUTINE BAS9IN(PRTP,IBOUND,IPRINT)
      USE efvs
      USE potential
      USE basis_data
      USE physical_constants
C
C     BASE9 ROUTINE BY JA and PZ 2010 TO
C     TO STUDY RB (ATOM A)-SR (ATOM B) INTERACTIONS
C     VERSION USING JTOT INSTEAD OF IBLOCK FOR MTOT LOOP

C [VARIOUS INTERMEDIATE MODIFICATIONS]

C     MODIFIED JAN 2018 BY M FRYE TO COVER A WIDER VARIETY OF COUPLING
C     TERMS. TERMS NOW DESCRIBED ARE:
C     LAMBDA=1: ELECTRONIC POTENTIAL
C     LAMBDA=2: R-DEPENDENT COMPONENT OF SCALAR (ISOTROPIC) HYPERFINE COUPLING ON A
C     LAMBDA=3: R-DEPENDENT COMPONENT OF SCALAR (ISOTROPIC) HYPERFINE COUPLING ON B
C     LAMBDA=4: TENSORAL (ANISOTROPIC) HYPERFINE COUPLING ON A
C     LAMBDA=5: TENSORAL (ANISOTROPIC) HYPERFINE COUPLING ON B
C     LAMBDA=6: NUCLEAR QUADRUPOLE COUPLING ON A
C     LAMBDA=7: NUCLEAR QUADRUPOLE COUPLING ON B
C     LAMBDA=8: SPIN-ROTATION COUPLING
C     LAMBDA=9: LINEAR STARK TERM
C
C     ADDED POTIN9 TO PASS LAMBDA TO VSTAR, SO ARBITRARY COMBINATIONS OF
C     COUPLINGS CAN BE SPECIFIED.
C     ALSO ADDED THRSH9 AND VARIOUS TIDYING UP.

CCC NB SOME EARLIER VERSIONS OF THIS ROUTINE DEFINED HFSPLA AND HFSPLB
CCC AS THE RELEVANT HYPERFINE COUPLING *CONSTANTS* RATHER THAN THE
CCC HYPERFINE SPLITTING IMPLIED BY THE NAME. THIS WAS CORRECTED AT SOME
CCC STAGE BETWEEN THE ORIGINAL CREATION OF THE ROUTINE AND THE 2018
CCC MAJOR EDIT, BUT SOME OLD INPUT FILES EXIST USING THE OLD (AND HIGHLY
CCC CONFUSING) CONVENTION, SO BEWARE. SIMILARLY, SOME VERSIONS INPUT
CCC NUCLEAR MAGNETIC MOMENTS IN UNITS OF THE NUCLEAR MAGNETON RATHER
CCC THAN THE BOHR MAGNETON. THE CURRENT DEFINITIONS ARE CONSISTENT WITH
CCC THOSE USED IN THE ALKALI-ALKALI BASE9s.

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      logical :: inolls=.false.
      CHARACTER(8) PRTP(4),QNAME(10)
      LOGICAL LEVIN,EIN,LCOUNT,EFFLG
      DIMENSION LREQ(10),MFREQ(10)
      DIMENSION JSTATE(1),VL(1),IV(1),JSINDX(1),L(1),CENT(1),LAM(1)
      DIMENSION DGVL(*)
      DIMENSION MONQN(NQN1)
C  ALTERED TO USE ARRAY SIZES FROM MODULE sizes ON 23-06-17 BY CRLS
C
C  include common block for data received via pvm
C
cINOLLS include 'all/pvmdat1.f'
cINOLLS include 'all/pvmdat.f'
C
      NAMELIST / BASIS9 / ISA,ISB,GSA,GSB,INUCA,INUCB,
     1                    HFSPLA,HFSPLB,GA,GB,LMAX,LREQ,MFREQ,EFFLG
C     BOHR MAGNETON IN 1/(cm G)
C     DATA BM/0.466864515D-4/
C value amended on 30-6-11 to current NIST data
C     PARAMETER (BOHRMG=1.51982984600456D-16*13.99624555D5)
C     CONVERSION FACTOR FROM HARTREE TO CM-1
C     DATA AUCM/219474.631371D0/
C     NUCLEAR MAGNETON (1/(cm G))
C     DATA XNM/2.542623616D-8/
C     ELECTRON G-FACTOR: NOTE +VE SIGN SO H_Z CONTAINS +GS B M_S
C     DATA GS/2.0023193043622D0/
C     CONVERSION FACTOR FROM CM-1 TO GHZ
C     DATA CMGHZ/29.9792458D0/
C
C  20-09-2016: UPDATED TO USE MODULE (physical_constants) THAT CONTAINS
C              CONSISTENT AND UP-TO-DATE VALUES
      GS=-g_e
      BM=bohr_magneton
      CMGHZ=speed_of_light_in_cm/Giga_in_SI
      AUCM=hartree_in_inv_cm
C
C     BAS9IN IS CALLED ONCE FOR EACH SCATTERING SYSTEM (USUALLY ONCE
C     PER RUN) AND CAN READ IN ANY BASIS SET INFORMATION NOT CONTAINED
C     IN NAMELIST BLOCK &BASIS. IT MUST ALSO HANDLE THE FOLLOWING
C     VARIABLES AND ARRAYS:
C
C     PRTP   SHOULD BE RETURNED AS A CHARACTER STRING DESCRIBING THE
C            INTERACTION TYPE
C     IDENTN CAN BE SET>0 IF AN INTERACTION OF IDENTICAL PARTICLES IS
C            BEING CONSIDERED AND SYMMETRISATION IS REQUIRED.
C            HOWEVER, THIS WOULD REQUIRE EXTRA CODING IN IDPART.
C     IBOUND CAN BE SET>0 IF THE CENTRIFUGAL POTENTIAL IS NOT OF THE
C            FORM L(L+1)/R**2; IF IBOUND>0, THE CENT ARRAY MUST BE
C            RETURNED FROM ENTRY CPL9
C
      PRTP(1)='Alk- 1S'
      NEFV=1
      MAPEFV=2
      EFVNAM(1)='MAGNETIC Z FIELD'
      EFVUNT(1)='GAUSS'

      NCONST=2
      VCONST(1)=1.D0/CMGHZ
      IBOUND=0
      LMAX=-1
      ISA=1
      GSA=-1.D0
      INUCA=1
      GA=0.D0
      HFSPLA=0.D0
      ISB=0
      GSB=0.0D0
      INUCB=0
      GB=0.D0
      HFSPLB=0.D0
      JHALF=0
      EFFLG=.TRUE.

      if (.not.inolls) READ(5,BASIS9)
C
cINOLLS include 'all/rbasis9.alk-2010.f'
C
      IFMAX=INUCA+ISA
      IFMIN=ABS(INUCA-ISA)
      NSFAC=(IFMAX*(IFMAX+2)-IFMIN*(IFMIN+2))/4
      ANSA=0.D0
      IF (NSFAC.NE.0) ANSA=2.D0*HFSPLA/DBLE(NSFAC)
      IF (GSA.EQ.-1.0D0) THEN
        GSA=GS
        WRITE(6,*) 'USING FREE ELECTRON G-FACTOR FOR ATOM A'
      ENDIF
      IF (GSB.EQ.-1.0D0) THEN
        GSB=GS
        WRITE(6,*) 'USING FREE ELECTRON G-FACTOR FOR ATOM B'
      ENDIF
      WRITE(6,601) ' A',ISA,GSA,INUCA,GA,HFSPLA,ANSA
      WRITE(6,601) ' B',ISB,GSB,INUCB,GB,HFSPLB,ANSB
  601 FORMAT(/'  ATOM',A2,' WITH S =',I2,'/2,  MU_S =',F12.6,
     1    ' MU_B',/,9X,'I =',I2,'/2,  MU_NUC =',F12.6,
     2    ' MU_B',/,9X,'HYPERFINE SPLITTING =',F12.6,
     3    ', COUPLING CONST =',F12.6,' GHZ',/)
C
C      HFSPLA=HFSPLA/CMGHZ
C
      WRITE(6,*) ' L UP TO',LMAX
C

      RETURN
C
      ENTRY SET9(LEVIN,EIN,NSTATE,JSTATE,NQN,QNAME,MXPAR,NLABV,IPRINT)
C
C     SET9 IS CALLED ONCE FOR EACH SCATTERING SYSTEM. IT SETS UP:
C     MXPAR, THE NUMBER OF DIFFERENT SYMMETRY TYPES ('PARITY CASES')
C     NLABV, THE NUMBER OF INDICES NEEDED TO DESCRIBE EACH TERM
C       IN THE POTENTIAL EXPANSION
C     NLEVEL AND JLEVEL, UNLESS LEVIN IS .TRUE.;
C     JSTATE AND NSTATE;
C     ELEVEL, UNLESS EIN IS .TRUE.
C     IF THE LOGICAL VARIABLES ARE .TRUE. ON ENTRY, THE CORRESPONDING
C     QUANTITIES WERE INPUT EXPLICITLY IN NAMELIST BLOCK &BASIS.
C     IF EIN IS .FALSE., THE MOLECULAR CONSTANTS MUST HAVE BEEN SUPPLIED
C     IN THE &BASIS ARRAY ROTI: THE PROGRAMMER MAY USE THESE IN ANY WAY
C     HE LIKES, BUT SHOULD OUTPUT THEM HERE FOR CHECKING.
C     NOTE THAT JLEVEL CONTAINS JUST THE QUANTUM NUMBERS NECESSARY TO
C     SPECIFY THE THRESHOLD ENERGY (AND ELEVEL CONTAINS THE CORRESPONDING
C     ENERGIES) WHEREAS JSTATE CONTAINS ALL THE CHANNEL QUANTUM NUMBERS EXCEPT
C     THE ORBITAL L, WHICH MAY BE A SUPERSET. THE LAST COLUMN OF THE JSTATE
C     ARRAY CONTAINS A POINTER TO THE ENERGY IN THE ELEVEL ARRAY.
C
      EIN=.FALSE.
      MXPAR=2
      NLABV=1
C
      NQN=5
C
      NLEVEL=0
      DO 210 MSA=-ISA,ISA,2
      DO 210 MIA=-INUCA,INUCA,2
      DO 210 MSB=-ISB,ISB,2
      DO 210 MIB=-INUCB,INUCB,2
      JLEVEL(4*NLEVEL+1)=MSA
      JLEVEL(4*NLEVEL+2)=MIA
      JLEVEL(4*NLEVEL+3)=MSB
      JLEVEL(4*NLEVEL+4)=MIB
      NLEVEL=NLEVEL+1
      ELEVEL(NLEVEL)=0.0D0
  210 CONTINUE
C
C     QNAME(1) TO (NQN-1) ARE NAMES OF QUANTUM NUMBERS
      QNAME(1)='  2*MSA '
      QNAME(2)='  2*MIA '
      QNAME(3)='  2*MSB '
      QNAME(4)='  2*MIB '
C     LOOP OVER LEVELS AGAIN, THIS TIME SETTING UP JSTATE
      NSTATE=NLEVEL
      DO 250 I=1,NLEVEL
      JSTATE(I)=JLEVEL(4*I-3)
      JSTATE(NSTATE+I)=JLEVEL(4*I-2)
      JSTATE(2*NSTATE+I)=JLEVEL(4*I-1)
      JSTATE(3*NSTATE+I)=JLEVEL(4*I)
      JSTATE(NSTATE*(NQN-1)+I)=I
  250 CONTINUE

      RETURN
C
      ENTRY BASE9(LCOUNT,N,JTOT,IBLOCK,JSTATE,NSTATE,NQN,JSINDX,L,
     1            IPRINT)
C
C     BASE9 IS CALLED EITHER TO COUNT THE ACTUAL NUMBER OF CHANNEL BASIS
C     FUNCTIONS OR ACTUALLY TO SET THEM UP (IN THE JSINDX AND L ARRAYS).
C     IT IS CALLED FOR EACH TOTAL J (JTOT) AND PARITY CASE (IBLOCK).
C     IF LCOUNT IS .TRUE. ON ENTRY, JUST COUNT THE BASIS FUNCTIONS.
C     OTHERWISE, SET UP JSINDX (POINTER TO JSTATE) AND
C     L (ORBITAL ANGULAR MOMENTUM) FOR EACH CHANNEL.
C     THIS MUST TAKE INTO ACCOUNT JTOT AND IBLOCK.
C
C     NOTE THAT BOTH MTOT AND ML ARE DOUBLED, LIKE MF ETC
C
      MTOT=JTOT
C
      IF (LCOUNT) THEN
        WRITE(6,605) IBLOCK,(-1)**IBLOCK,MTOT
  605   FORMAT('  IBLOCK = ',I2,' SELECTS PARITY',I3,/'  MTOT =',I2,
     1         '/2')
      ENDIF
C
      N=0
      DO 320 I=1,NSTATE
      MSA=JSTATE(I)
      MIA=JSTATE(NSTATE+I)
      MSB=JSTATE(2*NSTATE+I)
      MIB=JSTATE(3*NSTATE+I)
      MF=MSA+MSB+MIA+MIB
      ML=MTOT-MF

      IF (.NOT.EFFLG) THEN
       LLSTEP=4
       LSTART=4-2*IBLOCK
      ELSE
       LLSTEP=2
       LSTART=0
      ENDIF

      DO 310 LL=LSTART,2*LMAX,LLSTEP
      IF (ABS(ML).GT.LL) GOTO 310

      N=N+1
      IF (LCOUNT) GOTO 310
      JSINDX(N)=I
      L(N)=LL/2
  310 CONTINUE
  320 CONTINUE
      RETURN
C
      ENTRY CPL9(N,IBLOCK,NPOTL,LAM,MXLAM,NSTATE,JSTATE,JSINDX,L,JTOT,
     1           VL,IV,CENT,DGVL,IBOUND,IEXCH,IPRINT)
C
C  CPL9 IS CALLED AFTER BASE9 FOR EACH JTOT AND IBLOCK, TO SET UP THE
C  POTENTIAL COUPLING COEFFICIENTS VL.
C  IF IBOUND>0, IT ALSO SETS UP THE CENTRIFUGAL COEFFICIENTS CENT.
C  INDICES SPECIFYING THE MXLAM DIFFERENT POTENTIAL SYMMETRIES ARE IN
C  THE FIRST XX*MXLAM ELEMENTS OF LAM; THE STRUCTURE OF THE LAM ARRAY
C  (AND THE VALUE OF XX) IS CHOSEN BY THE PROGRAMMER, AND MUST
C  CORRESPOND WITH THAT USED IN SUBROUTINE POTENL.
C  NPOTL IS THE NUMBER OF DIFFERENT POTENTIAL TERMS WHICH CONTRIBUTE TO
C  EACH MATRIX ELEMENT (SEE SUBROUTINE WAVVEC). IT SOMETIMES SAVES
C  A SIGNIFICANT AMOUNT OF SPACE IF IT CAN BE LESS THAN MXLAM.
C
C  IN GENERAL THERE ARE 1+MIN(ISA,ISB) DIFFERENT TOTAL SPINS
C
C
      MTOT=JTOT
      DO 550 LL=1,NPOTL
        NNZ=0
        I=LL
        DO 540 ICOL=1,N
C  PICK OUT COLUMN QUANTUM NUMBERS
          MSAC=JSTATE(JSINDX(ICOL))
          MIAC=JSTATE(JSINDX(ICOL)+NSTATE)
          MSBC=JSTATE(JSINDX(ICOL)+2*NSTATE)
          MIBC=JSTATE(JSINDX(ICOL)+3*NSTATE)
          LC=L(ICOL)
          MLC = MTOT-MSAC-MIAC-MIBC
        DO 540 IROW=1,ICOL
C  PICK OUT ROW QUANTUM NUMBERS
          MSAR=JSTATE(JSINDX(IROW))
          MIAR=JSTATE(JSINDX(IROW)+NSTATE)
          MSBR=JSTATE(JSINDX(IROW)+2*NSTATE)
          MIBR=JSTATE(JSINDX(IROW)+3*NSTATE)
          LR=L(IROW)
          MLR = MTOT-MSAR-MIAR-MIBR
          VL(I)=0.D0
          IF (LL.LE.MXLAM) THEN
            IF (LAM(LL).EQ.1) THEN
C  LAMBDA=1, POTENTIAL
              IF (MIBR.EQ.MIBC .AND. LC.EQ.LR .AND. MLC.EQ.MLR .AND.
     &            MIAC.EQ.MIAR ) VL(I) =1D0

            ELSEIF (LAM(LL).EQ.2) THEN
C  LAMBDA=2, DELTA A I.S on A
              IF (MIBR.EQ.MIBC .AND. LC.EQ.LR .AND. MLC.EQ.MLR) THEN
                VL(I)=SDOTI2(ISA,MSAC,MSAR,INUCA,MIAC,MIAR)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.3) THEN
C  LAMBDA=3, DELTA A I.S on B
              IF (MIAR.EQ.MIAC .AND. LC.EQ.LR .AND. MLC.EQ.MLR) THEN
                VL(I)=SDOTI2(ISA,MSAC,MSAR,INUCB,MIBC,MIBR)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.4) THEN
C  LAMBDA=4, S TEN I on A
              IF (MIBR.EQ.MIBC) THEN
                VL(I)=T2J1J2oT2C_D(ISA,MSAC,MSAR,INUCA,MIAC,
     &                                         MIAR,LC,MLC/2,LR,MLR/2)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.5) THEN
C  LAMBDA=5, S TEN I on B
              IF (MIAR.EQ.MIAC) THEN
                VL(I)=T2J1J2oT2C_D(ISA,MSAC,MSAR,INUCB,MIBC,
     &                                        MIBR,LC,MLC/2,LR,MLR/2)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.6) THEN
C  LAMBDA=6, EQQ on A
              IF (MSAR.EQ.MSAC .AND. MIBC.EQ.MIBR) THEN
                VL(I)=EQINT(0.25D0,LC,MLC/2,LR,MLR/2,INUCA,MIAC,MIAR)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.7) THEN
C  LAMBDA=7, EQQ on B
              IF (MSAR.EQ.MSAC .AND. MIAC.EQ.MIAR) THEN
                VL(I)=EQINT(0.25D0,LC,MLC/2,LR,MLR/2,INUCB,MIBC,MIBR)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.8) THEN
C  LAMBDA=8, S.N
              IF (MIAR.EQ.MIAC .AND. MIBR.EQ.MIBC .AND. LC.EQ.LR) THEN
                VL(I)=SDOTI2(ISA,MSAC,MSAR,2*LC,MLC,MLR)
              ENDIF
C
            ELSEIF (LAM(LL).EQ.9) THEN
C  LAMBDA=9, SHORT-RANGE STARK TERM
              IF (MLC.EQ.MLR .AND. MIAC.EQ.MIAR .AND. MIBR.EQ.MIBC .AND.
     1            MSAC.EQ.MSAR) THEN
                VL(I)=-PARSGN(MLC/2)*DSQRT(DBLE((2*LC+1)*(2*LR+1)))
     &                * THRJ(DBLE(LC),1.D0,DBLE(LR),
     &                       -MLC/2.0D0,0.D0,MLC/2.0D0)
     &                * THREEJ(LC,1,LR)
              ENDIF
            ENDIF
C  NCONST TERMS
          ELSEIF (LL.EQ.MXLAM+1) THEN
C  ASYMPTOTIC S.I
            IF (MIBR.EQ.MIBC .AND. LC.EQ.LR .AND. MLC.EQ.MLR) THEN
              VL(I)=ANSA*SDOTI2(ISA,MSAC,MSAR,INUCA,MIAC,MIAR)
            ENDIF
          ELSEIF (LL.EQ.MXLAM+2) THEN
C  ZEEMAN
            IF (MLC.EQ.MLR .AND. LC.EQ.LR .AND. MIAC.EQ.MIAR .AND.
     &          MIBR.EQ.MIBC .AND. MSAR.EQ.MSAC) THEN
              VL(I)=GSA*DBLE(MSAC)+GA*DBLE(MIAC)+GB*DBLE(MIBC)
              VL(I)=VL(I)*BM*0.5D0
            ENDIF
          ENDIF

          IF (VL(I).NE.0.D0) NNZ=NNZ+1
  540     I=I+NPOTL
        IF (NNZ.EQ.0) WRITE(6,612) JTOT,LL
  612   FORMAT('  * * * NOTE.  FOR JTOT =',I4,',  ALL COUPLING',
     1         ' COEFFICIENTS ARE 0.0 FOR POTENTIAL SYMMETRY',I4)
  550 CONTINUE
C
      RETURN
C ---------------------------------------------------------------------
      ENTRY THRSH9(JREF,MONQN,NQN1,EREF,IPRINT)
C
C  THIS CALCULATES THRESHOLDS FOR TWO ATOMS, BOTH WITH ELECTRONIC SPIN
C  1/2
C  USING BREIT-RABI RELATIONSHIP FOR EACH ATOM SEPARATELY AND THEN
C  ADDING
C  THE RESULTS.  THE MONOMER QUANUM NUMBERS ARE SPECIFIED IN THE ARRAY
C  MONQN, AND ARE:
C     MONQN(1): 2*F(A) THAT DESIRED STATE CORRELATES WITH AT LOW FIELD
C     MONQN(2): 2*MF(A)
C
      BFIELD=EFV(1)
      IF (JREF.GT.0) THEN
        WRITE(6,*) ' *** ERROR - THRSH9 CALLED WITH POSITIVE IREF'
        STOP
      ENDIF
C
      IF (MONQN(1).EQ.-99999) THEN
        WRITE(6,*) ' *** ERROR - THRSH9 CALLED WITH MONQN UNSET'
        STOP
      ENDIF
C
      BOHRM=BM*CMGHZ
C
C  BREIT-RABI FOR ATOM A
C
      M=MONQN(2)
      IF (ABS(MONQN(1)-INUCA).NE.1) THEN
        WRITE(6,*) ' *** THRSH9: INVALID MONQN(1) =',MONQN(1)
        STOP
      ELSEIF (ABS(M).GT.MONQN(1)) THEN
        WRITE(6,*) ' *** THRSH9: MA =',M,' > FA. STOPPING'
        STOP
      ELSEIF (MOD(M+MONQN(1),2).NE.0) THEN
        WRITE(6,*) ' *** THRSH9: INVALID MONQN(1),MONQN(2) PAIR =',
     1             MONQN(1),M
        STOP
      ENDIF
      E1=-HFSPLA/(2.D0*DBLE(INUCA+1)) + 0.5D0*GA*BOHRM*DBLE(M)*BFIELD
      XX=BOHRM*BFIELD*(GSA-GA)/HFSPLA
      E2=0.5D0*HFSPLA*SQRT(1.D0+DBLE(M+M)*XX/DBLE(INUCA+1)+XX*XX)
C
      IF (ABS(M).EQ.INUCA+1) THEN
        EA=DBLE(INUCA)*HFSPLA/(2D0*DBLE(INUCA+1))+SIGN(1.0D0,DBLE(M))
     1     *BOHRM*BFIELD*(GSA*ISA*0.5D0+GA*INUCA*0.5D0)
      ELSEIF (MONQN(1).EQ.INUCA+1) THEN
        EA=E1+E2
      ELSEIF (MONQN(1).EQ.INUCA-1) THEN
        EA=E1-E2
      ELSE
        WRITE(6,*) ' THRSH9: INVALID MONQN(1) =',MONQN(1)
        STOP
      ENDIF
C
C  ONLY NUCLEAR MAGNETIC MOMENT FOR ATOM B
C
      M=MONQN(3)
      IF (ABS(M).GT.INUCB) THEN
        WRITE(6,*) ' *** THRSH9: MB =',M,' > IB. STOPPING'
        STOP
      ENDIF
      EB=0.5D0*GB*BOHRM*DBLE(M)*BFIELD
C
      IF (IPRINT.GE.8) THEN
        WRITE(6,*)
        WRITE(6,667) 'A',MONQN(1),MONQN(2),EA
        WRITE(6,666) 'B',MONQN(3),EB
  667   FORMAT('  ATOM ',A1,' WITH DOUBLED QUANTUM NOS',2I3,
     1         ' IS AT ENERGY',F12.7,' GHZ')
  666   FORMAT('  ATOM ',A1,' WITH DOUBLED QUANTUM NO',I3,
     1         ' IS AT ENERGY',F12.7,' GHZ')
      ENDIF

      EAB=EA+EB
      EREF=EAB/CMGHZ
c     IF (IPRINT.GE.6) WRITE(6,668) EAB,EREF
  668 FORMAT('  THRESHOLD USED IS AT ',F12.7,' GHZ =',F19.12,' CM-1')

      RETURN
C
      END
C------------------------------- EQINT --------------------------------
      FUNCTION EQINT(FQ,N1,MN1,N2,MN2,II,MI1,MI2)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C  FUNCTION FOR AN INDIVIDUAL ATOM NUCLEAR ELECTRIC QUADRUPOLE INTERACTION
C  WITH ELECTRONIC E FIELD GRADIENT
C  DECOUPLED BASIS SET (E.G. BROWN & CARRINGTON'S EQ. 8.299)
C  *** NOTE THAT ALL SPIN QUANTUM NUMBERS (II,MI1 and MI2) ARE DOUBLED ***
C  *** NOTE THAT FQ CONTAINS 0.25*eqQk ***
C
      LOGICAL ODD
C  STATEMENT FUNCTION TO CHECK WHETHER A NUMBER IS ODD
      ODD(NMBR)=2*(NMBR/2).NE.NMBR
C
      EQINT=0.D0
C  NEXT IF EXPLOITS A 3-J SYMBOLS PROPERTY
      IF (FQ.EQ.0.D0 .OR. ODD(N1+N2)) RETURN
      IP=MN1-MN2
C  NEXT IF EXPLOITS A 3-J SYMBOLS PROPERTY
      IF ((MI2-MI1).NE.2*IP) RETURN
      XII=0.5D0*DBLE(II)
      XMI1=0.5D0*DBLE(MI1)
      XMI2=0.5D0*DBLE(MI2)
      EQINT=FQ*PARSGN(IP+MN1+NINT(XII-XMI1))*
     &      SQRT(DBLE((2*N1+1)*(2*N2+1)))*
     &      THRJ(DBLE(N1),2.D0,DBLE(N2), DBLE(-MN1),DBLE(IP),DBLE(MN2))*
     &      THRJ(XII,2.D0,XII, -XMI1,DBLE(-IP),XMI2)*
     &      THREEJ(N1,2,N2)/THRJ(XII,2.0D0,XII,-XII,0.0D0,XII)
C
      RETURN
      END
C***********************************************************************
C------------------------------ SDOTI2 --------------------------------
      FUNCTION SDOTI2(IS,MS1,MS2,II,MI1,MI2)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C  FUNCTION FOR A MATRIX ELEMENT OF A DOT PRODUCT OF TWO ANGULAR
C  MOMENTA IN A DECOUPLED BASIS SET.
C  ALL INPUT INTEGERS ARE TWICE THE CORRESPONDING QUANTUM NUMBERS
C  MLEO: TAKEN FROM JMH'S SDOTI2 FUNCTION IN BASE9.ALK.F
C
      SDOTI2=0.D0
      IF (MS1+MI1.EQ.MS2+MI2) THEN
         IF (MS1.EQ.MS2) THEN
            SDOTI2=0.25D0*DBLE(MI1*MS1)
         ELSEIF (IABS(MS1-MS2).EQ.2) THEN
            SDOTI2=0.125D0*SQRT(DBLE(II*(II+2)-MI1*MI2))
     1                    *SQRT(DBLE(IS*(IS+2)-MS1*MS2))
         ENDIF
      ENDIF
C
      RETURN
C
      END
c ***********************************************************************
      FUNCTION T2J1J2oT2C_D(ISA,MSAC,MSAR,ISB,MSBC,MSBR,LC,MLC,LR,MLR)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C-----------------------------------------------------------------------
C  DATE (LAST UPDATE): 10/08/10        STATUS: FINISHED                |
C  AUTHOR: MAYKEL LEONARDO GONZALEZ MARTINEZ                           |
C         (ADAPTED FROM JMH'S SPINSP FUNCTION IN base9.alk2.f)         |
C-----------------------------------------------------------------------
C     FUNCTION FOR A MATRIX ELEMENT OF A PRODUCT OF TWO SPHERICAL      |
C     TENSORS OF RANK 2 (OF THE KIND APPEARING IN SPIN-SPIN TERMS,     |
C    E.G. BROWN & CARRINGTON'S EQ. 8.464), USING A DECOUPLED BASIS     |
C    <L ML|<j1 m1|<j2 m2|T^2(j1,j2).T^2(C)|j2 m'2>|j1 m'1>|L' M'L>     |
C   (ALL INPUT INTEGERS EXCEPT Lx & MLx ARE TWICE THE CORRESPONDING    |
C                            QUANTUM NUMBERS)                          |
C-----------------------------------------------------------------------
C MDF 26/07/18: NB FUNCTION SEEMS TO ACTUALLY CALCULATE SQRT(6) TIMES
C THE MATRIX ELEMENT.
      T2J1J2oT2C_D=0.D0
      IF (MSAC+MSBC+2*MLC.NE.MSAR+MSBR+2*MLR) RETURN
      IF (ABS(LC-LR).GT.2 .OR. ABS(MLC-MLR).GT.2) RETURN
C
      XSA=0.5D0*ISA
      XMSAC=0.5D0*MSAC
      XMSAR=0.5D0*MSAR
      XSB=0.5D0*ISB
      XMSBC=0.5D0*MSBC
      XMSBR=0.5D0*MSBR
      XMLC=DBLE(MLC)
      XMLR=DBLE(MLR)
      IQ=MLR-MLC
      FAC1=PARSGN((ISA-MSAC+ISB-MSBC)/2-MLC)
     & *SQRT(XSA*(XSA+1.D0)*(XSA+XSA+1.D0)*XSB*(XSB+1.D0)*(XSB+XSB+1.D0)
     & *(2*LC+1)*(2*LR+1))*THREEJ(LC,2,LR)
      FAC2=THRJ(DBLE(LC),2.D0,DBLE(LR), -XMLC,-DBLE(IQ),XMLR)
      LIQA: DO IQA=-1,1
        IQB=IQ-IQA
        IF (ABS(IQB).GT.1) CYCLE LIQA
        FAC3=THRJ(1.D0,1.D0,2.D0, DBLE(IQA),DBLE(IQB),-DBLE(IQ))
        FAC4=THRJ(XSA,1.D0,XSA, -XMSAC,DBLE(IQA),XMSAR)
        FAC5=THRJ(XSB,1.D0,XSB, -XMSBC,DBLE(IQB),XMSBR)
        T2J1J2oT2C_D=T2J1J2oT2C_D+FAC1*FAC2*FAC3*FAC4*FAC5
      END DO LIQA
      T2J1J2oT2C_D=SQRT(30.D0)*T2J1J2oT2C_D
C
      RETURN
      END FUNCTION T2J1J2oT2C_D
C
      SUBROUTINE POTIN9(ITYPP,LAM,MXLAM,NPTS,NDIM,XPT,XWT,
     1                  MXPT,IVMIN,IVMAX,L1MAX,L2MAX,
     2                  MXLMB,X,MX,IXFAC)
      USE angles
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      logical :: inolls=.false.
      DIMENSION LAM(1,MXLAM),NPTS(NDIM),XPT(MXPT,NDIM),XWT(MXPT,NDIM),
     1          X(MX)
      NAMELIST /POTL9/ ITYPE
C
C  ROUTINE TO INITIALIZE POTENTIAL FOR ITYPE=9.
C  NOTE THAT THE ITYPE VARIABLE PASSED TO POTIN9 IS LOCAL TO
C  POTENL, AND MAY BE CHANGED TO CONTROL POTENL
C  WITHOUT AFFECTING HOW THE REST OF MOLSCAT/BOUND BEHAVES.
C
C  THE MINIMUM THAT POTIN9 MUST DO IS TO SET ITYPE SO THAT
C  POTENL USES ITS NORMAL LOGIC FOR SOME OTHER VALUE OF ITYPE.
C  HOWEVER, IN SOME CASES IT WILL BE NECESSARY TO DO MUCH MORE,
C  FOR EXAMPLE TO SET UP SPECIAL SETS OF QUADRATURE POINTS AND
C  WEIGHTS.
C
      ITYPE=1
      if (inolls) then
        RM=1.D0
        EPSIL=1.D0
      else
        READ(5,POTL9)
      endif
      ITYPP=ITYPE
C VSLAM IS ENTRY POINT IN VSTAR USED TO PASS LAMBDA.
      CALL VSLAM(MXLAM)
      RETURN
      END
