####Name: Thomas Graves
####Date: 10 January 2024
####Title: A genre-specific measure of subjective feeling in music listening: Constructing the Durham Emotion in Qawwālī Scale (DEQS)
####Study 2: How different do these 2 emotion words feel? - completed for all possible comparisons of 2 words using 20 words arising from study 1 
####Likert scale 1-5, 1 as the same, 5 as completely different
####Question: How similar are various reported subjective feelings with qawwali to each other? Which factors could adequately explain subjective feeling in qawwali listening?
####Aim1: To create "conceptual maps" of subjective feelings felt with qawwali, showing which feelings are closer to each other.
####Aim 2: To develop a scale for measuring subjective feeling with qawwali by revealing a number of factors that describe most subjective feeling with qawwali listening.
setwd('~/DEQS_Questionnaire_2/')
rm(list=ls(all=TRUE)) ####cleans R memory
library(smacof)
library(readxl)
library(ggplot2)
df <- read.csv('Qualtrics_DEQS_study_2_numeric_18_April_2022_no_header_1.csv',header = TRUE)
dim(df)
View(df)
##remove respondents who failed the attention checks
df2 <- df[!(df$Q187!="2" | df$Q188!="5" | df$Q184!="4"),]
dim(df2)
View(df2)
df2 <- as.data.frame(df2)
head(df2)
###label rows with numbers 1-29

N <- 30 ###number of participants
rownames(df2) <- c(1:N)

####create a separate data frame for each participant, as a comparison matrix, 20 rows, 20 columns, wach representing an emotion word. Each cell represents a comparison o two emotion words
####participant 1
p1 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p1) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p1) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p1$faateh <- c(NA, df2[c(1), c(29:47)])
p1$mazboot <- c(rep(NA, 2), df2[c(1), c(48:65)])
p1$ruhani <- c(rep(NA, 3), df2[c(1), c(66:82)])
p1$pyara <- c(rep(NA, 4), df2[c(1), c(83:91, 93:99)])
p1$bahadur <- c(rep(NA, 5), df2[c(1), c(100:114)])
p1$sabr <- c(rep(NA, 6), df2[c(1), c(115:128)])
p1$khush <- c(rep(NA, 7), df2[c(1), c(129:141)])
p1$piyar <- c(rep(NA, 8), df2[c(1), c(142:153)])
p1$mohabbat <- c(rep(NA, 9), df2[c(1), c(154:156, 158:165)])
p1$aramdah <- c(rep(NA, 10), df2[c(1), c(166:175)])
p1$fakhr <- c(rep(NA, 11), df2[c(1), c(176:184)])
p1$wajd <- c(rep(NA, 12), df2[c(1), c(185:192)])
p1$haal <- c(rep(NA, 13), df2[c(1), c(193:199)])
p1$kaifiyat <- c(rep(NA, 14), df2[c(1), c(200:205)])
p1$pursukon <- c(rep(NA, 15), df2[c(1), c(206:210)])
p1$ishq <- c(rep(NA, 16), df2[c(1), c(211:214)])
p1$mast <- c(rep(NA, 17), df2[c(1), c(215:217)])
p1$udas <- c(rep(NA, 18), df2[c(1), c(218,219)])
p1$kanpna <- c(rep(NA, 19), df2[c(1), c(220)])
p1$kaif <- c(rep(NA,20))

####Participant 2
p2 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p2) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p2) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p2$faateh <- c(NA, df2[c(2), c(29:47)])
p2$mazboot <- c(rep(NA, 2), df2[c(2), c(48:65)])
p2$ruhani <- c(rep(NA, 3), df2[c(2), c(66:82)])
p2$pyara <- c(rep(NA, 4), df2[c(2), c(83:91, 93:99)])
p2$bahadur <- c(rep(NA, 5), df2[c(2), c(100:114)])
p2$sabr <- c(rep(NA, 6), df2[c(2), c(115:128)])
p2$khush <- c(rep(NA, 7), df2[c(2), c(129:141)])
p2$piyar <- c(rep(NA, 8), df2[c(2), c(142:153)])
p2$mohabbat <- c(rep(NA, 9), df2[c(2), c(154:156, 158:165)])
p2$aramdah <- c(rep(NA, 10), df2[c(2), c(166:175)])
p2$fakhr <- c(rep(NA, 11), df2[c(2), c(176:184)])
p2$wajd <- c(rep(NA, 12), df2[c(2), c(185:192)])
p2$haal <- c(rep(NA, 13), df2[c(2), c(193:199)])
p2$kaifiyat <- c(rep(NA, 14), df2[c(2), c(200:205)])
p2$pursukon <- c(rep(NA, 15), df2[c(2), c(206:210)])
p2$ishq <- c(rep(NA, 16), df2[c(2), c(211:214)])
p2$mast <- c(rep(NA, 17), df2[c(2), c(215:217)])
p2$udas <- c(rep(NA, 18), df2[c(2), c(218,219)])
p2$kanpna <- c(rep(NA, 19), df2[c(2), c(220)])
p2$kaif <- c(rep(NA,20))

####Participant 3
p3 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p3) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p3) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p3$faateh <- c(NA, df2[c(3), c(29:47)])
p3$mazboot <- c(rep(NA, 2), df2[c(3), c(48:65)])
p3$ruhani <- c(rep(NA, 3), df2[c(3), c(66:82)])
p3$pyara <- c(rep(NA, 4), df2[c(3), c(83:91, 93:99)])
p3$bahadur <- c(rep(NA, 5), df2[c(3), c(100:114)])
p3$sabr <- c(rep(NA, 6), df2[c(3), c(115:128)])
p3$khush <- c(rep(NA, 7), df2[c(3), c(129:141)])
p3$piyar <- c(rep(NA, 8), df2[c(3), c(142:153)])
p3$mohabbat <- c(rep(NA, 9), df2[c(3), c(154:156, 158:165)])
p3$aramdah <- c(rep(NA, 10), df2[c(3), c(166:175)])
p3$fakhr <- c(rep(NA, 11), df2[c(3), c(176:184)])
p3$wajd <- c(rep(NA, 12), df2[c(3), c(185:192)])
p3$haal <- c(rep(NA, 13), df2[c(3), c(193:199)])
p3$kaifiyat <- c(rep(NA, 14), df2[c(3), c(200:205)])
p3$pursukon <- c(rep(NA, 15), df2[c(3), c(206:210)])
p3$ishq <- c(rep(NA, 16), df2[c(3), c(211:214)])
p3$mast <- c(rep(NA, 17), df2[c(3), c(215:217)])
p3$udas <- c(rep(NA, 18), df2[c(3), c(218,219)])
p3$kanpna <- c(rep(NA, 19), df2[c(3), c(220)])
p3$kaif <- c(rep(NA,20))

####Participant 4
p4 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p4) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p4) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p4$faateh <- c(NA, df2[c(4), c(29:47)])
p4$mazboot <- c(rep(NA, 2), df2[c(4), c(48:65)])
p4$ruhani <- c(rep(NA, 3), df2[c(4), c(66:82)])
p4$pyara <- c(rep(NA, 4), df2[c(4), c(83:91, 93:99)])
p4$bahadur <- c(rep(NA, 5), df2[c(4), c(100:114)])
p4$sabr <- c(rep(NA, 6), df2[c(4), c(115:128)])
p4$khush <- c(rep(NA, 7), df2[c(4), c(129:141)])
p4$piyar <- c(rep(NA, 8), df2[c(4), c(142:153)])
p4$mohabbat <- c(rep(NA, 9), df2[c(4), c(154:156, 158:165)])
p4$aramdah <- c(rep(NA, 10), df2[c(4), c(166:175)])
p4$fakhr <- c(rep(NA, 11), df2[c(4), c(176:184)])
p4$wajd <- c(rep(NA, 12), df2[c(4), c(185:192)])
p4$haal <- c(rep(NA, 13), df2[c(4), c(193:199)])
p4$kaifiyat <- c(rep(NA, 14), df2[c(4), c(200:205)])
p4$pursukon <- c(rep(NA, 15), df2[c(4), c(206:210)])
p4$ishq <- c(rep(NA, 16), df2[c(4), c(211:214)])
p4$mast <- c(rep(NA, 17), df2[c(4), c(215:217)])
p4$udas <- c(rep(NA, 18), df2[c(4), c(218,219)])
p4$kanpna <- c(rep(NA, 19), df2[c(4), c(220)])
p4$kaif <- c(rep(NA,20))

####Participant 5
p5 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p5) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p5) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p5$faateh <- c(NA, df2[c(5), c(29:47)])
p5$mazboot <- c(rep(NA, 2), df2[c(5), c(48:65)])
p5$ruhani <- c(rep(NA, 3), df2[c(5), c(66:82)])
p5$pyara <- c(rep(NA, 4), df2[c(5), c(83:91, 93:99)])
p5$bahadur <- c(rep(NA, 5), df2[c(5), c(100:114)])
p5$sabr <- c(rep(NA, 6), df2[c(5), c(115:128)])
p5$khush <- c(rep(NA, 7), df2[c(5), c(129:141)])
p5$piyar <- c(rep(NA, 8), df2[c(5), c(142:153)])
p5$mohabbat <- c(rep(NA, 9), df2[c(5), c(154:156, 158:165)])
p5$aramdah <- c(rep(NA, 10), df2[c(5), c(166:175)])
p5$fakhr <- c(rep(NA, 11), df2[c(5), c(176:184)])
p5$wajd <- c(rep(NA, 12), df2[c(5), c(185:192)])
p5$haal <- c(rep(NA, 13), df2[c(5), c(193:199)])
p5$kaifiyat <- c(rep(NA, 14), df2[c(5), c(200:205)])
p5$pursukon <- c(rep(NA, 15), df2[c(5), c(206:210)])
p5$ishq <- c(rep(NA, 16), df2[c(5), c(211:214)])
p5$mast <- c(rep(NA, 17), df2[c(5), c(215:217)])
p5$udas <- c(rep(NA, 18), df2[c(5), c(218,219)])
p5$kanpna <- c(rep(NA, 19), df2[c(5), c(220)])
p5$kaif <- c(rep(NA,20))

####Participant 6
p6 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p6) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p6) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p6$faateh <- c(NA, df2[c(6), c(29:47)])
p6$mazboot <- c(rep(NA, 2), df2[c(6), c(48:65)])
p6$ruhani <- c(rep(NA, 3), df2[c(6), c(66:82)])
p6$pyara <- c(rep(NA, 4), df2[c(6), c(83:91, 93:99)])
p6$bahadur <- c(rep(NA, 5), df2[c(6), c(100:114)])
p6$sabr <- c(rep(NA, 6), df2[c(6), c(115:128)])
p6$khush <- c(rep(NA, 7), df2[c(6), c(129:141)])
p6$piyar <- c(rep(NA, 8), df2[c(6), c(142:153)])
p6$mohabbat <- c(rep(NA, 9), df2[c(6), c(154:156, 158:165)])
p6$aramdah <- c(rep(NA, 10), df2[c(6), c(166:175)])
p6$fakhr <- c(rep(NA, 11), df2[c(6), c(176:184)])
p6$wajd <- c(rep(NA, 12), df2[c(6), c(185:192)])
p6$haal <- c(rep(NA, 13), df2[c(6), c(193:199)])
p6$kaifiyat <- c(rep(NA, 14), df2[c(6), c(200:205)])
p6$pursukon <- c(rep(NA, 15), df2[c(6), c(206:210)])
p6$ishq <- c(rep(NA, 16), df2[c(6), c(211:214)])
p6$mast <- c(rep(NA, 17), df2[c(6), c(215:217)])
p6$udas <- c(rep(NA, 18), df2[c(6), c(218,219)])
p6$kanpna <- c(rep(NA, 19), df2[c(6), c(220)])
p6$kaif <- c(rep(NA,20))

####Participant 7
p7 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p7) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p7) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p7$faateh <- c(NA, df2[c(7), c(29:47)])
p7$mazboot <- c(rep(NA, 2), df2[c(7), c(48:65)])
p7$ruhani <- c(rep(NA, 3), df2[c(7), c(66:82)])
p7$pyara <- c(rep(NA, 4), df2[c(7), c(83:91, 93:99)])
p7$bahadur <- c(rep(NA, 5), df2[c(7), c(100:114)])
p7$sabr <- c(rep(NA, 6), df2[c(7), c(115:128)])
p7$khush <- c(rep(NA, 7), df2[c(7), c(129:141)])
p7$piyar <- c(rep(NA, 8), df2[c(7), c(142:153)])
p7$mohabbat <- c(rep(NA, 9), df2[c(7), c(154:156, 158:165)])
p7$aramdah <- c(rep(NA, 10), df2[c(7), c(166:175)])
p7$fakhr <- c(rep(NA, 11), df2[c(7), c(176:184)])
p7$wajd <- c(rep(NA, 12), df2[c(7), c(185:192)])
p7$haal <- c(rep(NA, 13), df2[c(7), c(193:199)])
p7$kaifiyat <- c(rep(NA, 14), df2[c(7), c(200:205)])
p7$pursukon <- c(rep(NA, 15), df2[c(7), c(206:210)])
p7$ishq <- c(rep(NA, 16), df2[c(7), c(211:214)])
p7$mast <- c(rep(NA, 17), df2[c(7), c(215:217)])
p7$udas <- c(rep(NA, 18), df2[c(7), c(218,219)])
p7$kanpna <- c(rep(NA, 19), df2[c(7), c(220)])
p7$kaif <- c(rep(NA,20))

####Participant 8
p8 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p8) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p8) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p8$faateh <- c(NA, df2[c(8), c(29:47)])
p8$mazboot <- c(rep(NA, 2), df2[c(8), c(48:65)])
p8$ruhani <- c(rep(NA, 3), df2[c(8), c(66:82)])
p8$pyara <- c(rep(NA, 4), df2[c(8), c(83:91, 93:99)])
p8$bahadur <- c(rep(NA, 5), df2[c(8), c(100:114)])
p8$sabr <- c(rep(NA, 6), df2[c(8), c(115:128)])
p8$khush <- c(rep(NA, 7), df2[c(8), c(129:141)])
p8$piyar <- c(rep(NA, 8), df2[c(8), c(142:153)])
p8$mohabbat <- c(rep(NA, 9), df2[c(8), c(154:156, 158:165)])
p8$aramdah <- c(rep(NA, 10), df2[c(8), c(166:175)])
p8$fakhr <- c(rep(NA, 11), df2[c(8), c(176:184)])
p8$wajd <- c(rep(NA, 12), df2[c(8), c(185:192)])
p8$haal <- c(rep(NA, 13), df2[c(8), c(193:199)])
p8$kaifiyat <- c(rep(NA, 14), df2[c(8), c(200:205)])
p8$pursukon <- c(rep(NA, 15), df2[c(8), c(206:210)])
p8$ishq <- c(rep(NA, 16), df2[c(8), c(211:214)])
p8$mast <- c(rep(NA, 17), df2[c(8), c(215:217)])
p8$udas <- c(rep(NA, 18), df2[c(8), c(218,219)])
p8$kanpna <- c(rep(NA, 19), df2[c(8), c(220)])
p8$kaif <- c(rep(NA,20))

####Participant 8
p9 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p9) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p9) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p9$faateh <- c(NA, df2[c(9), c(29:47)])
p9$mazboot <- c(rep(NA, 2), df2[c(9), c(48:65)])
p9$ruhani <- c(rep(NA, 3), df2[c(9), c(66:82)])
p9$pyara <- c(rep(NA, 4), df2[c(9), c(83:91, 93:99)])
p9$bahadur <- c(rep(NA, 5), df2[c(9), c(100:114)])
p9$sabr <- c(rep(NA, 6), df2[c(9), c(115:128)])
p9$khush <- c(rep(NA, 7), df2[c(9), c(129:141)])
p9$piyar <- c(rep(NA, 8), df2[c(9), c(142:153)])
p9$mohabbat <- c(rep(NA, 9), df2[c(9), c(154:156, 158:165)])
p9$aramdah <- c(rep(NA, 10), df2[c(9), c(166:175)])
p9$fakhr <- c(rep(NA, 11), df2[c(9), c(176:184)])
p9$wajd <- c(rep(NA, 12), df2[c(9), c(185:192)])
p9$haal <- c(rep(NA, 13), df2[c(9), c(193:199)])
p9$kaifiyat <- c(rep(NA, 14), df2[c(9), c(200:205)])
p9$pursukon <- c(rep(NA, 15), df2[c(9), c(206:210)])
p9$ishq <- c(rep(NA, 16), df2[c(9), c(211:214)])
p9$mast <- c(rep(NA, 17), df2[c(9), c(215:217)])
p9$udas <- c(rep(NA, 18), df2[c(9), c(218,219)])
p9$kanpna <- c(rep(NA, 19), df2[c(9), c(220)])
p9$kaif <- c(rep(NA,20))

####Participant 10
p10 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p10) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p10) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p10$faateh <- c(NA, df2[c(10), c(29:47)])
p10$mazboot <- c(rep(NA, 2), df2[c(10), c(48:65)])
p10$ruhani <- c(rep(NA, 3), df2[c(10), c(66:82)])
p10$pyara <- c(rep(NA, 4), df2[c(10), c(83:91, 93:99)])
p10$bahadur <- c(rep(NA, 5), df2[c(10), c(100:114)])
p10$sabr <- c(rep(NA, 6), df2[c(10), c(115:128)])
p10$khush <- c(rep(NA, 7), df2[c(10), c(129:141)])
p10$piyar <- c(rep(NA, 8), df2[c(10), c(142:153)])
p10$mohabbat <- c(rep(NA, 9), df2[c(10), c(154:156, 158:165)])
p10$aramdah <- c(rep(NA, 10), df2[c(10), c(166:175)])
p10$fakhr <- c(rep(NA, 11), df2[c(10), c(176:184)])
p10$wajd <- c(rep(NA, 12), df2[c(10), c(185:192)])
p10$haal <- c(rep(NA, 13), df2[c(10), c(193:199)])
p10$kaifiyat <- c(rep(NA, 14), df2[c(10), c(200:205)])
p10$pursukon <- c(rep(NA, 15), df2[c(10), c(206:210)])
p10$ishq <- c(rep(NA, 16), df2[c(10), c(211:214)])
p10$mast <- c(rep(NA, 17), df2[c(10), c(215:217)])
p10$udas <- c(rep(NA, 18), df2[c(10), c(218,219)])
p10$kanpna <- c(rep(NA, 19), df2[c(10), c(220)])
p10$kaif <- c(rep(NA,20))

####Participant 11
p11 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p11) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p11) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p11$faateh <- c(NA, df2[c(11), c(29:47)])
p11$mazboot <- c(rep(NA, 2), df2[c(11), c(48:65)])
p11$ruhani <- c(rep(NA, 3), df2[c(11), c(66:82)])
p11$pyara <- c(rep(NA, 4), df2[c(11), c(83:91, 93:99)])
p11$bahadur <- c(rep(NA, 5), df2[c(11), c(100:114)])
p11$sabr <- c(rep(NA, 6), df2[c(11), c(115:128)])
p11$khush <- c(rep(NA, 7), df2[c(11), c(129:141)])
p11$piyar <- c(rep(NA, 8), df2[c(11), c(142:153)])
p11$mohabbat <- c(rep(NA, 9), df2[c(11), c(154:156, 158:165)])
p11$aramdah <- c(rep(NA, 10), df2[c(11), c(166:175)])
p11$fakhr <- c(rep(NA, 11), df2[c(11), c(176:184)])
p11$wajd <- c(rep(NA, 12), df2[c(11), c(185:192)])
p11$haal <- c(rep(NA, 13), df2[c(11), c(193:199)])
p11$kaifiyat <- c(rep(NA, 14), df2[c(11), c(200:205)])
p11$pursukon <- c(rep(NA, 15), df2[c(11), c(206:210)])
p11$ishq <- c(rep(NA, 16), df2[c(11), c(211:214)])
p11$mast <- c(rep(NA, 17), df2[c(11), c(215:217)])
p11$udas <- c(rep(NA, 18), df2[c(11), c(218,219)])
p11$kanpna <- c(rep(NA, 19), df2[c(11), c(220)])
p11$kaif <- c(rep(NA,20))

####Participant 8
p12 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p12) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p12) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p12$faateh <- c(NA, df2[c(12), c(29:47)])
p12$mazboot <- c(rep(NA, 2), df2[c(12), c(48:65)])
p12$ruhani <- c(rep(NA, 3), df2[c(12), c(66:82)])
p12$pyara <- c(rep(NA, 4), df2[c(12), c(83:91, 93:99)])
p12$bahadur <- c(rep(NA, 5), df2[c(12), c(100:114)])
p12$sabr <- c(rep(NA, 6), df2[c(12), c(115:128)])
p12$khush <- c(rep(NA, 7), df2[c(12), c(129:141)])
p12$piyar <- c(rep(NA, 8), df2[c(12), c(142:153)])
p12$mohabbat <- c(rep(NA, 9), df2[c(12), c(154:156, 158:165)])
p12$aramdah <- c(rep(NA, 10), df2[c(12), c(166:175)])
p12$fakhr <- c(rep(NA, 11), df2[c(12), c(176:184)])
p12$wajd <- c(rep(NA, 12), df2[c(12), c(185:192)])
p12$haal <- c(rep(NA, 13), df2[c(12), c(193:199)])
p12$kaifiyat <- c(rep(NA, 14), df2[c(12), c(200:205)])
p12$pursukon <- c(rep(NA, 15), df2[c(12), c(206:210)])
p12$ishq <- c(rep(NA, 16), df2[c(12), c(211:214)])
p12$mast <- c(rep(NA, 17), df2[c(12), c(215:217)])
p12$udas <- c(rep(NA, 18), df2[c(12), c(218,219)])
p12$kanpna <- c(rep(NA, 19), df2[c(12), c(220)])
p12$kaif <- c(rep(NA,20))

####Participant 13
p13<- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p13) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p13) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p13$faateh <- c(NA, df2[c(13), c(29:47)])
p13$mazboot <- c(rep(NA, 2), df2[c(13), c(48:65)])
p13$ruhani <- c(rep(NA, 3), df2[c(13), c(66:82)])
p13$pyara <- c(rep(NA, 4), df2[c(13), c(83:91, 93:99)])
p13$bahadur <- c(rep(NA, 5), df2[c(13), c(100:114)])
p13$sabr <- c(rep(NA, 6), df2[c(13), c(115:128)])
p13$khush <- c(rep(NA, 7), df2[c(13), c(129:141)])
p13$piyar <- c(rep(NA, 8), df2[c(13), c(142:153)])
p13$mohabbat <- c(rep(NA, 9), df2[c(13), c(154:156, 158:165)])
p13$aramdah <- c(rep(NA, 10), df2[c(13), c(166:175)])
p13$fakhr <- c(rep(NA, 11), df2[c(13), c(176:184)])
p13$wajd <- c(rep(NA, 12), df2[c(13), c(185:192)])
p13$haal <- c(rep(NA, 13), df2[c(13), c(193:199)])
p13$kaifiyat <- c(rep(NA, 14), df2[c(13), c(200:205)])
p13$pursukon <- c(rep(NA, 15), df2[c(13), c(206:210)])
p13$ishq <- c(rep(NA, 16), df2[c(13), c(211:214)])
p13$mast <- c(rep(NA, 17), df2[c(13), c(215:217)])
p13$udas <- c(rep(NA, 18), df2[c(13), c(218,219)])
p13$kanpna <- c(rep(NA, 19), df2[c(13), c(220)])
p13$kaif <- c(rep(NA,20))

####Participant 14
p14 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p14) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p14) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p14$faateh <- c(NA, df2[c(14), c(29:47)])
p14$mazboot <- c(rep(NA, 2), df2[c(14), c(48:65)])
p14$ruhani <- c(rep(NA, 3), df2[c(14), c(66:82)])
p14$pyara <- c(rep(NA, 4), df2[c(14), c(83:91, 93:99)])
p14$bahadur <- c(rep(NA, 5), df2[c(14), c(100:114)])
p14$sabr <- c(rep(NA, 6), df2[c(14), c(115:128)])
p14$khush <- c(rep(NA, 7), df2[c(14), c(129:141)])
p14$piyar <- c(rep(NA, 8), df2[c(14), c(142:153)])
p14$mohabbat <- c(rep(NA, 9), df2[c(14), c(154:156, 158:165)])
p14$aramdah <- c(rep(NA, 10), df2[c(14), c(166:175)])
p14$fakhr <- c(rep(NA, 11), df2[c(14), c(176:184)])
p14$wajd <- c(rep(NA, 12), df2[c(14), c(185:192)])
p14$haal <- c(rep(NA, 13), df2[c(14), c(193:199)])
p14$kaifiyat <- c(rep(NA, 14), df2[c(14), c(200:205)])
p14$pursukon <- c(rep(NA, 15), df2[c(14), c(206:210)])
p14$ishq <- c(rep(NA, 16), df2[c(14), c(211:214)])
p14$mast <- c(rep(NA, 17), df2[c(14), c(215:217)])
p14$udas <- c(rep(NA, 18), df2[c(14), c(218,219)])
p14$kanpna <- c(rep(NA, 19), df2[c(14), c(220)])
p14$kaif <- c(rep(NA,20))

####Participant 15
p15 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p15) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p15) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p15$faateh <- c(NA, df2[c(15), c(29:47)])
p15$mazboot <- c(rep(NA, 2), df2[c(15), c(48:65)])
p15$ruhani <- c(rep(NA, 3), df2[c(15), c(66:82)])
p15$pyara <- c(rep(NA, 4), df2[c(15), c(83:91, 93:99)])
p15$bahadur <- c(rep(NA, 5), df2[c(15), c(100:114)])
p15$sabr <- c(rep(NA, 6), df2[c(15), c(115:128)])
p15$khush <- c(rep(NA, 7), df2[c(15), c(129:141)])
p15$piyar <- c(rep(NA, 8), df2[c(15), c(142:153)])
p15$mohabbat <- c(rep(NA, 9), df2[c(15), c(154:156, 158:165)])
p15$aramdah <- c(rep(NA, 10), df2[c(15), c(166:175)])
p15$fakhr <- c(rep(NA, 11), df2[c(15), c(176:184)])
p15$wajd <- c(rep(NA, 12), df2[c(15), c(185:192)])
p15$haal <- c(rep(NA, 13), df2[c(15), c(193:199)])
p15$kaifiyat <- c(rep(NA, 14), df2[c(15), c(200:205)])
p15$pursukon <- c(rep(NA, 15), df2[c(15), c(206:210)])
p15$ishq <- c(rep(NA, 16), df2[c(15), c(211:214)])
p15$mast <- c(rep(NA, 17), df2[c(15), c(215:217)])
p15$udas <- c(rep(NA, 18), df2[c(15), c(218,219)])
p15$kanpna <- c(rep(NA, 19), df2[c(15), c(220)])
p15$kaif <- c(rep(NA,20))

####Participant 16
p16 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p16) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p16) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p16$faateh <- c(NA, df2[c(16), c(29:47)])
p16$mazboot <- c(rep(NA, 2), df2[c(16), c(48:65)])
p16$ruhani <- c(rep(NA, 3), df2[c(16), c(66:82)])
p16$pyara <- c(rep(NA, 4), df2[c(16), c(83:91, 93:99)])
p16$bahadur <- c(rep(NA, 5), df2[c(16), c(100:114)])
p16$sabr <- c(rep(NA, 6), df2[c(16), c(115:128)])
p16$khush <- c(rep(NA, 7), df2[c(16), c(129:141)])
p16$piyar <- c(rep(NA, 8), df2[c(16), c(142:153)])
p16$mohabbat <- c(rep(NA, 9), df2[c(16), c(154:156, 158:165)])
p16$aramdah <- c(rep(NA, 10), df2[c(16), c(166:175)])
p16$fakhr <- c(rep(NA, 11), df2[c(16), c(176:184)])
p16$wajd <- c(rep(NA, 12), df2[c(16), c(185:192)])
p16$haal <- c(rep(NA, 13), df2[c(16), c(193:199)])
p16$kaifiyat <- c(rep(NA, 14), df2[c(16), c(200:205)])
p16$pursukon <- c(rep(NA, 15), df2[c(16), c(206:210)])
p16$ishq <- c(rep(NA, 16), df2[c(16), c(211:214)])
p16$mast <- c(rep(NA, 17), df2[c(16), c(215:217)])
p16$udas <- c(rep(NA, 18), df2[c(16), c(218,219)])
p16$kanpna <- c(rep(NA, 19), df2[c(16), c(220)])
p16$kaif <- c(rep(NA,20))

####Participant 17
p17 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p17) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p17) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p17$faateh <- c(NA, df2[c(17), c(29:47)])
p17$mazboot <- c(rep(NA, 2), df2[c(17), c(48:65)])
p17$ruhani <- c(rep(NA, 3), df2[c(17), c(66:82)])
p17$pyara <- c(rep(NA, 4), df2[c(17), c(83:91, 93:99)])
p17$bahadur <- c(rep(NA, 5), df2[c(17), c(100:114)])
p17$sabr <- c(rep(NA, 6), df2[c(17), c(115:128)])
p17$khush <- c(rep(NA, 7), df2[c(17), c(129:141)])
p17$piyar <- c(rep(NA, 8), df2[c(17), c(142:153)])
p17$mohabbat <- c(rep(NA, 9), df2[c(17), c(154:156, 158:165)])
p17$aramdah <- c(rep(NA, 10), df2[c(17), c(166:175)])
p17$fakhr <- c(rep(NA, 11), df2[c(17), c(176:184)])
p17$wajd <- c(rep(NA, 12), df2[c(17), c(185:192)])
p17$haal <- c(rep(NA, 13), df2[c(17), c(193:199)])
p17$kaifiyat <- c(rep(NA, 14), df2[c(17), c(200:205)])
p17$pursukon <- c(rep(NA, 15), df2[c(17), c(206:210)])
p17$ishq <- c(rep(NA, 16), df2[c(17), c(211:214)])
p17$mast <- c(rep(NA, 17), df2[c(17), c(215:217)])
p17$udas <- c(rep(NA, 18), df2[c(17), c(218,219)])
p17$kanpna <- c(rep(NA, 19), df2[c(17), c(220)])
p17$kaif <- c(rep(NA,20))

####Participant 18
p18 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p18) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p18) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p18$faateh <- c(NA, df2[c(18), c(29:47)])
p18$mazboot <- c(rep(NA, 2), df2[c(18), c(48:65)])
p18$ruhani <- c(rep(NA, 3), df2[c(18), c(66:82)])
p18$pyara <- c(rep(NA, 4), df2[c(18), c(83:91, 93:99)])
p18$bahadur <- c(rep(NA, 5), df2[c(18), c(100:114)])
p18$sabr <- c(rep(NA, 6), df2[c(18), c(115:128)])
p18$khush <- c(rep(NA, 7), df2[c(18), c(129:141)])
p18$piyar <- c(rep(NA, 8), df2[c(18), c(142:153)])
p18$mohabbat <- c(rep(NA, 9), df2[c(18), c(154:156, 158:165)])
p18$aramdah <- c(rep(NA, 10), df2[c(18), c(166:175)])
p18$fakhr <- c(rep(NA, 11), df2[c(18), c(176:184)])
p18$wajd <- c(rep(NA, 12), df2[c(18), c(185:192)])
p18$haal <- c(rep(NA, 13), df2[c(18), c(193:199)])
p18$kaifiyat <- c(rep(NA, 14), df2[c(18), c(200:205)])
p18$pursukon <- c(rep(NA, 15), df2[c(18), c(206:210)])
p18$ishq <- c(rep(NA, 16), df2[c(18), c(211:214)])
p18$mast <- c(rep(NA, 17), df2[c(18), c(215:217)])
p18$udas <- c(rep(NA, 18), df2[c(18), c(218,219)])
p18$kanpna <- c(rep(NA, 19), df2[c(18), c(220)])
p18$kaif <- c(rep(NA,20))

####Participant 19
p19 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p19) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p19) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p19$faateh <- c(NA, df2[c(19), c(29:47)])
p19$mazboot <- c(rep(NA, 2), df2[c(19), c(48:65)])
p19$ruhani <- c(rep(NA, 3), df2[c(19), c(66:82)])
p19$pyara <- c(rep(NA, 4), df2[c(19), c(83:91, 93:99)])
p19$bahadur <- c(rep(NA, 5), df2[c(19), c(100:114)])
p19$sabr <- c(rep(NA, 6), df2[c(19), c(115:128)])
p19$khush <- c(rep(NA, 7), df2[c(19), c(129:141)])
p19$piyar <- c(rep(NA, 8), df2[c(19), c(142:153)])
p19$mohabbat <- c(rep(NA, 9), df2[c(19), c(154:156, 158:165)])
p19$aramdah <- c(rep(NA, 10), df2[c(19), c(166:175)])
p19$fakhr <- c(rep(NA, 11), df2[c(19), c(176:184)])
p19$wajd <- c(rep(NA, 12), df2[c(19), c(185:192)])
p19$haal <- c(rep(NA, 13), df2[c(19), c(193:199)])
p19$kaifiyat <- c(rep(NA, 14), df2[c(19), c(200:205)])
p19$pursukon <- c(rep(NA, 15), df2[c(19), c(206:210)])
p19$ishq <- c(rep(NA, 16), df2[c(19), c(211:214)])
p19$mast <- c(rep(NA, 17), df2[c(19), c(215:217)])
p19$udas <- c(rep(NA, 18), df2[c(19), c(218,219)])
p19$kanpna <- c(rep(NA, 19), df2[c(19), c(220)])
p19$kaif <- c(rep(NA,20))

####Participant 20
p20 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p20) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p20) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p20$faateh <- c(NA, df2[c(20), c(29:47)])
p20$mazboot <- c(rep(NA, 2), df2[c(20), c(48:65)])
p20$ruhani <- c(rep(NA, 3), df2[c(20), c(66:82)])
p20$pyara <- c(rep(NA, 4), df2[c(20), c(83:91, 93:99)])
p20$bahadur <- c(rep(NA, 5), df2[c(20), c(100:114)])
p20$sabr <- c(rep(NA, 6), df2[c(20), c(115:128)])
p20$khush <- c(rep(NA, 7), df2[c(20), c(129:141)])
p20$piyar <- c(rep(NA, 8), df2[c(20), c(142:153)])
p20$mohabbat <- c(rep(NA, 9), df2[c(20), c(154:156, 158:165)])
p20$aramdah <- c(rep(NA, 10), df2[c(20), c(166:175)])
p20$fakhr <- c(rep(NA, 11), df2[c(20), c(176:184)])
p20$wajd <- c(rep(NA, 12), df2[c(20), c(185:192)])
p20$haal <- c(rep(NA, 13), df2[c(20), c(193:199)])
p20$kaifiyat <- c(rep(NA, 14), df2[c(20), c(200:205)])
p20$pursukon <- c(rep(NA, 15), df2[c(20), c(206:210)])
p20$ishq <- c(rep(NA, 16), df2[c(20), c(211:214)])
p20$mast <- c(rep(NA, 17), df2[c(20), c(215:217)])
p20$udas <- c(rep(NA, 18), df2[c(20), c(218,219)])
p20$kanpna <- c(rep(NA, 19), df2[c(20), c(220)])
p20$kaif <- c(rep(NA,20))

####Participant 21
p21 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p21) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p21) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p21$faateh <- c(NA, df2[c(21), c(29:47)])
p21$mazboot <- c(rep(NA, 2), df2[c(21), c(48:65)])
p21$ruhani <- c(rep(NA, 3), df2[c(21), c(66:82)])
p21$pyara <- c(rep(NA, 4), df2[c(21), c(83:91, 93:99)])
p21$bahadur <- c(rep(NA, 5), df2[c(21), c(100:114)])
p21$sabr <- c(rep(NA, 6), df2[c(21), c(115:128)])
p21$khush <- c(rep(NA, 7), df2[c(21), c(129:141)])
p21$piyar <- c(rep(NA, 8), df2[c(21), c(142:153)])
p21$mohabbat <- c(rep(NA, 9), df2[c(21), c(154:156, 158:165)])
p21$aramdah <- c(rep(NA, 10), df2[c(21), c(166:175)])
p21$fakhr <- c(rep(NA, 11), df2[c(21), c(176:184)])
p21$wajd <- c(rep(NA, 12), df2[c(21), c(185:192)])
p21$haal <- c(rep(NA, 13), df2[c(21), c(193:199)])
p21$kaifiyat <- c(rep(NA, 14), df2[c(21), c(200:205)])
p21$pursukon <- c(rep(NA, 15), df2[c(21), c(206:210)])
p21$ishq <- c(rep(NA, 16), df2[c(21), c(211:214)])
p21$mast <- c(rep(NA, 17), df2[c(21), c(215:217)])
p21$udas <- c(rep(NA, 18), df2[c(21), c(218,219)])
p21$kanpna <- c(rep(NA, 19), df2[c(21), c(220)])
p21$kaif <- c(rep(NA,20))

####Participant 22
p22 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p22) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p22) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p22$faateh <- c(NA, df2[c(22), c(29:47)])
p22$mazboot <- c(rep(NA, 2), df2[c(22), c(48:65)])
p22$ruhani <- c(rep(NA, 3), df2[c(22), c(66:82)])
p22$pyara <- c(rep(NA, 4), df2[c(22), c(83:91, 93:99)])
p22$bahadur <- c(rep(NA, 5), df2[c(22), c(100:114)])
p22$sabr <- c(rep(NA, 6), df2[c(22), c(115:128)])
p22$khush <- c(rep(NA, 7), df2[c(22), c(129:141)])
p22$piyar <- c(rep(NA, 8), df2[c(22), c(142:153)])
p22$mohabbat <- c(rep(NA, 9), df2[c(22), c(154:156, 158:165)])
p22$aramdah <- c(rep(NA, 10), df2[c(22), c(166:175)])
p22$fakhr <- c(rep(NA, 11), df2[c(22), c(176:184)])
p22$wajd <- c(rep(NA, 12), df2[c(22), c(185:192)])
p22$haal <- c(rep(NA, 13), df2[c(22), c(193:199)])
p22$kaifiyat <- c(rep(NA, 14), df2[c(22), c(200:205)])
p22$pursukon <- c(rep(NA, 15), df2[c(22), c(206:210)])
p22$ishq <- c(rep(NA, 16), df2[c(22), c(211:214)])
p22$mast <- c(rep(NA, 17), df2[c(22), c(215:217)])
p22$udas <- c(rep(NA, 18), df2[c(22), c(218,219)])
p22$kanpna <- c(rep(NA, 19), df2[c(22), c(220)])
p22$kaif <- c(rep(NA,20))

####Participant 23
p23 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p23) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p23) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p23$faateh <- c(NA, df2[c(23), c(29:47)])
p23$mazboot <- c(rep(NA, 2), df2[c(23), c(48:65)])
p23$ruhani <- c(rep(NA, 3), df2[c(23), c(66:82)])
p23$pyara <- c(rep(NA, 4), df2[c(23), c(83:91, 93:99)])
p23$bahadur <- c(rep(NA, 5), df2[c(23), c(100:114)])
p23$sabr <- c(rep(NA, 6), df2[c(23), c(115:128)])
p23$khush <- c(rep(NA, 7), df2[c(23), c(129:141)])
p23$piyar <- c(rep(NA, 8), df2[c(23), c(142:153)])
p23$mohabbat <- c(rep(NA, 9), df2[c(23), c(154:156, 158:165)])
p23$aramdah <- c(rep(NA, 10), df2[c(23), c(166:175)])
p23$fakhr <- c(rep(NA, 11), df2[c(23), c(176:184)])
p23$wajd <- c(rep(NA, 12), df2[c(23), c(185:192)])
p23$haal <- c(rep(NA, 13), df2[c(23), c(193:199)])
p23$kaifiyat <- c(rep(NA, 14), df2[c(23), c(200:205)])
p23$pursukon <- c(rep(NA, 15), df2[c(23), c(206:210)])
p23$ishq <- c(rep(NA, 16), df2[c(23), c(211:214)])
p23$mast <- c(rep(NA, 17), df2[c(23), c(215:217)])
p23$udas <- c(rep(NA, 18), df2[c(23), c(218,219)])
p23$kanpna <- c(rep(NA, 19), df2[c(23), c(220)])
p23$kaif <- c(rep(NA,20))

####Participant 24
p24 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p24) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p24) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p24$faateh <- c(NA, df2[c(20), c(29:47)])
p24$mazboot <- c(rep(NA, 2), df2[c(24), c(48:65)])
p24$ruhani <- c(rep(NA, 3), df2[c(24), c(66:82)])
p24$pyara <- c(rep(NA, 4), df2[c(24), c(83:91, 93:99)])
p24$bahadur <- c(rep(NA, 5), df2[c(24), c(100:114)])
p24$sabr <- c(rep(NA, 6), df2[c(24), c(115:128)])
p24$khush <- c(rep(NA, 7), df2[c(24), c(129:141)])
p24$piyar <- c(rep(NA, 8), df2[c(24), c(142:153)])
p24$mohabbat <- c(rep(NA, 9), df2[c(24), c(154:156, 158:165)])
p24$aramdah <- c(rep(NA, 10), df2[c(24), c(166:175)])
p24$fakhr <- c(rep(NA, 11), df2[c(24), c(176:184)])
p24$wajd <- c(rep(NA, 12), df2[c(24), c(185:192)])
p24$haal <- c(rep(NA, 13), df2[c(24), c(193:199)])
p24$kaifiyat <- c(rep(NA, 14), df2[c(24), c(200:205)])
p24$pursukon <- c(rep(NA, 15), df2[c(24), c(206:210)])
p24$ishq <- c(rep(NA, 16), df2[c(24), c(211:214)])
p24$mast <- c(rep(NA, 17), df2[c(24), c(215:217)])
p24$udas <- c(rep(NA, 18), df2[c(24), c(218,219)])
p24$kanpna <- c(rep(NA, 19), df2[c(24), c(220)])
p24$kaif <- c(rep(NA,20))

####Participant 25
p25 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p25) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p25) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p25$faateh <- c(NA, df2[c(25), c(29:47)])
p25$mazboot <- c(rep(NA, 2), df2[c(25), c(48:65)])
p25$ruhani <- c(rep(NA, 3), df2[c(25), c(66:82)])
p25$pyara <- c(rep(NA, 4), df2[c(25), c(83:91, 93:99)])
p25$bahadur <- c(rep(NA, 5), df2[c(25), c(100:114)])
p25$sabr <- c(rep(NA, 6), df2[c(25), c(115:128)])
p25$khush <- c(rep(NA, 7), df2[c(25), c(129:141)])
p25$piyar <- c(rep(NA, 8), df2[c(25), c(142:153)])
p25$mohabbat <- c(rep(NA, 9), df2[c(25), c(154:156, 158:165)])
p25$aramdah <- c(rep(NA, 10), df2[c(25), c(166:175)])
p25$fakhr <- c(rep(NA, 11), df2[c(25), c(176:184)])
p25$wajd <- c(rep(NA, 12), df2[c(25), c(185:192)])
p25$haal <- c(rep(NA, 13), df2[c(25), c(193:199)])
p25$kaifiyat <- c(rep(NA, 14), df2[c(25), c(200:205)])
p25$pursukon <- c(rep(NA, 15), df2[c(25), c(206:210)])
p25$ishq <- c(rep(NA, 16), df2[c(25), c(211:214)])
p25$mast <- c(rep(NA, 17), df2[c(25), c(215:217)])
p25$udas <- c(rep(NA, 18), df2[c(25), c(218,219)])
p25$kanpna <- c(rep(NA, 19), df2[c(25), c(220)])
p25$kaif <- c(rep(NA,20))

####Participant 26
p26 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p26) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p26) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p26$faateh <- c(NA, df2[c(26), c(29:47)])
p26$mazboot <- c(rep(NA, 2), df2[c(26), c(48:65)])
p26$ruhani <- c(rep(NA, 3), df2[c(26), c(66:82)])
p26$pyara <- c(rep(NA, 4), df2[c(26), c(83:91, 93:99)])
p26$bahadur <- c(rep(NA, 5), df2[c(26), c(100:114)])
p26$sabr <- c(rep(NA, 6), df2[c(26), c(115:128)])
p26$khush <- c(rep(NA, 7), df2[c(26), c(129:141)])
p26$piyar <- c(rep(NA, 8), df2[c(26), c(142:153)])
p26$mohabbat <- c(rep(NA, 9), df2[c(26), c(154:156, 158:165)])
p26$aramdah <- c(rep(NA, 10), df2[c(26), c(166:175)])
p26$fakhr <- c(rep(NA, 11), df2[c(26), c(176:184)])
p26$wajd <- c(rep(NA, 12), df2[c(26), c(185:192)])
p26$haal <- c(rep(NA, 13), df2[c(26), c(193:199)])
p26$kaifiyat <- c(rep(NA, 14), df2[c(26), c(200:205)])
p26$pursukon <- c(rep(NA, 15), df2[c(26), c(206:210)])
p26$ishq <- c(rep(NA, 16), df2[c(26), c(211:214)])
p26$mast <- c(rep(NA, 17), df2[c(26), c(215:217)])
p26$udas <- c(rep(NA, 18), df2[c(26), c(218,219)])
p26$kanpna <- c(rep(NA, 19), df2[c(26), c(220)])
p26$kaif <- c(rep(NA,20))

####Participant 27
p27 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p27) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p27) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p27$faateh <- c(NA, df2[c(27), c(29:47)])
p27$mazboot <- c(rep(NA, 2), df2[c(27), c(48:65)])
p27$ruhani <- c(rep(NA, 3), df2[c(27), c(66:82)])
p27$pyara <- c(rep(NA, 4), df2[c(27), c(83:91, 93:99)])
p27$bahadur <- c(rep(NA, 5), df2[c(27), c(100:114)])
p27$sabr <- c(rep(NA, 6), df2[c(27), c(115:128)])
p27$khush <- c(rep(NA, 7), df2[c(27), c(129:141)])
p27$piyar <- c(rep(NA, 8), df2[c(27), c(142:153)])
p27$mohabbat <- c(rep(NA, 9), df2[c(27), c(154:156, 158:165)])
p27$aramdah <- c(rep(NA, 10), df2[c(27), c(166:175)])
p27$fakhr <- c(rep(NA, 11), df2[c(27), c(176:184)])
p27$wajd <- c(rep(NA, 12), df2[c(27), c(185:192)])
p27$haal <- c(rep(NA, 13), df2[c(27), c(193:199)])
p27$kaifiyat <- c(rep(NA, 14), df2[c(27), c(200:205)])
p27$pursukon <- c(rep(NA, 15), df2[c(27), c(206:210)])
p27$ishq <- c(rep(NA, 16), df2[c(27), c(211:214)])
p27$mast <- c(rep(NA, 17), df2[c(27), c(215:217)])
p27$udas <- c(rep(NA, 18), df2[c(27), c(218,219)])
p27$kanpna <- c(rep(NA, 19), df2[c(27), c(220)])
p27$kaif <- c(rep(NA,20))

####Participant 28
p28 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p28) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p28) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p28$faateh <- c(NA, df2[c(28), c(29:47)])
p28$mazboot <- c(rep(NA, 2), df2[c(28), c(48:65)])
p28$ruhani <- c(rep(NA, 3), df2[c(28), c(66:82)])
p28$pyara <- c(rep(NA, 4), df2[c(28), c(83:91, 93:99)])
p28$bahadur <- c(rep(NA, 5), df2[c(28), c(100:114)])
p28$sabr <- c(rep(NA, 6), df2[c(28), c(115:128)])
p28$khush <- c(rep(NA, 7), df2[c(28), c(129:141)])
p28$piyar <- c(rep(NA, 8), df2[c(28), c(142:153)])
p28$mohabbat <- c(rep(NA, 9), df2[c(28), c(154:156, 158:165)])
p28$aramdah <- c(rep(NA, 10), df2[c(28), c(166:175)])
p28$fakhr <- c(rep(NA, 11), df2[c(28), c(176:184)])
p28$wajd <- c(rep(NA, 12), df2[c(28), c(185:192)])
p28$haal <- c(rep(NA, 13), df2[c(28), c(193:199)])
p28$kaifiyat <- c(rep(NA, 14), df2[c(28), c(200:205)])
p28$pursukon <- c(rep(NA, 15), df2[c(28), c(206:210)])
p28$ishq <- c(rep(NA, 16), df2[c(28), c(211:214)])
p28$mast <- c(rep(NA, 17), df2[c(28), c(215:217)])
p28$udas <- c(rep(NA, 18), df2[c(28), c(218,219)])
p28$kanpna <- c(rep(NA, 19), df2[c(28), c(220)])
p28$kaif <- c(rep(NA,20))

####Participant 29
p29 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p29) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p29) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p29$faateh <- c(NA, df2[c(29), c(29:47)])
p29$mazboot <- c(rep(NA, 2), df2[c(29), c(48:65)])
p29$ruhani <- c(rep(NA, 3), df2[c(29), c(66:82)])
p29$pyara <- c(rep(NA, 4), df2[c(29), c(83:91, 93:99)])
p29$bahadur <- c(rep(NA, 5), df2[c(29), c(100:114)])
p29$sabr <- c(rep(NA, 6), df2[c(29), c(115:128)])
p29$khush <- c(rep(NA, 7), df2[c(29), c(129:141)])
p29$piyar <- c(rep(NA, 8), df2[c(29), c(142:153)])
p29$mohabbat <- c(rep(NA, 9), df2[c(29), c(154:156, 158:165)])
p29$aramdah <- c(rep(NA, 10), df2[c(29), c(166:175)])
p29$fakhr <- c(rep(NA, 11), df2[c(29), c(176:184)])
p29$wajd <- c(rep(NA, 12), df2[c(29), c(185:192)])
p29$haal <- c(rep(NA, 13), df2[c(29), c(193:199)])
p29$kaifiyat <- c(rep(NA, 14), df2[c(29), c(200:205)])
p29$pursukon <- c(rep(NA, 15), df2[c(29), c(206:210)])
p29$ishq <- c(rep(NA, 16), df2[c(29), c(211:214)])
p29$mast <- c(rep(NA, 17), df2[c(29), c(215:217)])
p29$udas <- c(rep(NA, 18), df2[c(29), c(218,219)])
p29$kanpna <- c(rep(NA, 19), df2[c(29), c(220)])
p29$kaif <- c(rep(NA,20))


p30 <- data.frame(matrix(ncol = 20, nrow = 20))
colnames(p30) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
rownames(p30) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
p30$faateh <- c(NA, df2[c(30), c(29:47)])
p30$mazboot <- c(rep(NA, 2), df2[c(30), c(48:65)])
p30$ruhani <- c(rep(NA, 3), df2[c(30), c(66:82)])
p30$pyara <- c(rep(NA, 4), df2[c(30), c(83:91, 93:99)])
p30$bahadur <- c(rep(NA, 5), df2[c(30), c(100:114)])
p30$sabr <- c(rep(NA, 6), df2[c(30), c(115:128)])
p30$khush <- c(rep(NA, 7), df2[c(30), c(129:141)])
p30$piyar <- c(rep(NA, 8), df2[c(30), c(142:153)])
p30$mohabbat <- c(rep(NA, 9), df2[c(30), c(154:156, 158:165)])
p30$aramdah <- c(rep(NA, 10), df2[c(30), c(166:175)])
p30$fakhr <- c(rep(NA, 11), df2[c(30), c(176:184)])
p30$wajd <- c(rep(NA, 12), df2[c(30), c(185:192)])
p30$haal <- c(rep(NA, 13), df2[c(30), c(193:199)])
p30$kaifiyat <- c(rep(NA, 14), df2[c(30), c(200:205)])
p30$pursukon <- c(rep(NA, 15), df2[c(30), c(206:210)])
p30$ishq <- c(rep(NA, 16), df2[c(30), c(211:214)])
p30$mast <- c(rep(NA, 17), df2[c(30), c(215:217)])
p30$udas <- c(rep(NA, 18), df2[c(30), c(218,219)])
p30$kanpna <- c(rep(NA, 19), df2[c(30), c(220)])
p30$kaif <- c(rep(NA,20))


### Force these into matrix data frames from lists

source('convert2matrix.R')
p1b<-convert2matrix(p1)
head(p1)
head(p1b)
str(p1)
str(p1b)

p1<-convert2matrix(p1)
p2<-convert2matrix(p2)
p3<-convert2matrix(p3)
p4<-convert2matrix(p4)
p5<-convert2matrix(p5)
p6<-convert2matrix(p6)
p7<-convert2matrix(p7)
p8<-convert2matrix(p8)
p9<-convert2matrix(p9)
p10<-convert2matrix(p10)
p11<-convert2matrix(p11)
p12<-convert2matrix(p12)
p13<-convert2matrix(p13)
p14<-convert2matrix(p14)
p15<-convert2matrix(p15)
p16<-convert2matrix(p16)
p17<-convert2matrix(p17)
p18<-convert2matrix(p18)
p19<-convert2matrix(p19)
p20<-convert2matrix(p20)
p21<-convert2matrix(p21)
p22<-convert2matrix(p22)
p23<-convert2matrix(p23)
p24<-convert2matrix(p24)
p25<-convert2matrix(p25)
p26<-convert2matrix(p26)
p27<-convert2matrix(p27)
p28<-convert2matrix(p28)
p29<-convert2matrix(p29)
p30<-convert2matrix(p30)


####format data as a list of comparison matrices
# TE: I have removed participants 20 and 24. 20 is empty (NAs) and 24 is mainly rating of 4s.
individual_data <- list(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p21, p22, p23, p25, p26, p27, p28, p29,p30) # create an empty list

#### carry out MDS on one participant at a time

for(k in 1:length(individual_data)){
  print(k)
  s <- smacofSym(individual_data[[k]],ndim=2,type="interval",eps = 1e-22,itmax = 20000) 
  plot(s, type = "p", label.conf = list(label = TRUE, pos = 5, col = "darkgray"), pch = 21, col = "blue",main=paste('Example - participant',k))
  par(mfrow=c(1,1))
}
#### TE fixed up to this point. But the data for participant nro 20 is empty.
#### TE fixed up to this point. And the data for participant nro 24 is "empty."singular" too many responses of 4


#### How many dimensions are needed to capture the similarities? Let's try 2 to 7
# for each participant and summarise the "stress" of the solution from each

stress_dim<-rep(NA,1,6) ####makes the plot for p1
for(i in 2:7){ # dimensions
  stress<-NULL
  for(k in 1:length(individual_data)){ # participants
    print(paste0(i,':',k))
    diss <- sim2diss(individual_data[[k]], method = 6, to.dist = TRUE)
    s <- smacofSym(diss,ndim=i,type="interval",eps = 1e-22,itmax = 20000) 
    stress <- c(stress,s$stress)
  }
  stress_dim[i]<-mean(stress)
}


## Are these stress numbers decent?

stress_dim<-data.frame(stress=stress_dim)
stress_dim$Dim<-1:7
knitr::kable(stress_dim,caption='Mean stress for 2 to 7 dimensions of MDS',digits = 2)
set.seed(123)
rstress <- randomstress(n = 28, ndim = 2, nrep = 500, type = "ratio")
bound <- mean(rstress) - 2*sd(rstress)
print(round(bound,3)) # 0.426
solution <- smacofIndDiff(individual_data,ndim=2,type='interval',constraint = "indscal",verbose=FALSE, itmax=5000,eps=1e-8)
solution$stress # stress 0.358
bub <- plot(solution,plot.type='bubbleplot',bubscale=6)
stress <- plot(solution,plot.type='stressplot')
df<-data.frame(X=solution$gspace[,1],Y=solution$gspace[,2],Names=rownames(solution$gspace),Size=solution$spp)


g1<-ggplot(df,aes(x=X,y=Y, size=Size,label=Names))+
  geom_point(colour='red',alpha=0.60,show.legend = FALSE)+
  geom_text(show.legend = FALSE)+
  scale_size_continuous(range = c(10,3))+
  scale_x_continuous(limits = c(-1,1))+
  scale_y_continuous(limits = c(-1,1))+
  xlab('Dim. 1')+
  ylab('Dim. 2')+
  theme_bw()
g1
par(mfrow=c(5,6))
par(mar=c(1,1,1,1))
for(k in 1:28){ # participants
  s <- smacofSym(individual_data[[k]],ndim=i,type="interval")
  plot(s, type = "p", label.conf = list(label = TRUE, col = "blue"), pch = 16, col = "black",main=k,xlab='',ylab='')
}   ####this produces MDS for all ps

#### clustering -------
N<-28
dis<-matrix(0,N,N) # put an empty matrix
for (k in 1:N) {
  for (l in 1:N) {
    x<-rbind(as.numeric(unlist(individual_data[[k]])),as.numeric(unlist(individual_data[[l]])))
    dis[k,l] <- dist(x, method = "euclidean") # distance between raw data from each
  }
}
dis2<-as.dist(dis) # Make sure the matrix is distance matrix.
# Hierarchical clustering results (could be something else)
hc <- hclust(dis2, method = "ward.D") # Ward is just an option, there are many others
# Visualization of hclust

par(mfrow=c(1,1))

plot(hc)
rect.hclust(hc, k = 3, border = 2:4) # arbitrary now

####3D solution
library(rgl)
library(ggplot2)
rstress2 <- randomstress(n = 28, ndim = 3, nrep = 500, type = "ratio")
bound2 <- mean(rstress2) - 2*sd(rstress2)
print(round(bound2,3)) 
solution2 <- smacofIndDiff(individual_data,ndim=3,type='interval',constraint = "indscal",verbose=FALSE, itmax=5000,eps=1e-8)
solution2$stress
dfx<-data.frame(X=solution2$gspace[,1],Y=solution2$gspace[,2], Z=solution2$gspace[,3], Names=rownames(solution2$gspace),Size=solution2$spp)

x<-dfx$X
y<-dfx$Y
z<-dfx$Z
plot3d(x, y, z, col = 'red', type = 's', size = 1) +
  text3d(x=x,y=y,z=z,texts=dfx$Names, col=4, pos = 1)

##this is difficult to represent on paper in 2 dimensions, therefore the below shows a 2D plot with the Z-dimension

g2<-ggplot(dfx,aes(x=X,y=Y, size=Size,label=Names))+
  geom_point(colour='red',alpha=0.60,show.legend = FALSE)+
  geom_text(show.legend = FALSE)+
  scale_size_continuous(range = c(10,3))+
  scale_x_continuous(limits = c(-1,1))+
  scale_y_continuous(limits = c(-1,1))+
  xlab('X')+
  ylab('Y')+
  theme_bw()
g2

g3<-ggplot(dfx,aes(x=Y,y=Z, size=Size,label=Names))+
  geom_point(colour='green',alpha=0.60,show.legend = FALSE)+
  geom_text(show.legend = FALSE)+
  scale_size_continuous(range = c(10,3))+
  scale_x_continuous(limits = c(-1,1))+
  scale_y_continuous(limits = c(-1,1))+
  xlab('Y')+
  ylab('Z')+
  theme_bw()
g3

g4<-ggplot(dfx,aes(x=X,y=Z, size=Size,label=Names))+
  geom_point(colour='blue',alpha=0.60,show.legend = FALSE)+
  geom_text(show.legend = FALSE)+
  scale_size_continuous(range = c(10,3))+
  scale_x_continuous(limits = c(-1,1))+
  scale_y_continuous(limits = c(-1,1))+
  xlab('X')+
  ylab('Z')+
  theme_bw()
g4

####Exploratory Factor Analysis 

library(psych)
library(gdata)

####Factor Analysis

####Loading and Data Cleaning
                  
Packages <- c('readxl','reshape2','ggplot2','dplyr','smacof')
invisible(lapply(Packages, library, character.only = TRUE)); rm(Packages) ####load libraries

####Exploratory Factor Analysis 

reduceApplyListOfArrays<- function(x){
  y<-apply(array(unlist(x), c(dim(x[[1]]), dim(x[[2]]), length(x))), 
           c(1,2), mean, na.rm=TRUE)
  colnames(y)<-colnames(x[[1]])
  rownames(y)<-rownames(x[[1]])
  return(y)
}

meandata<-reduceApplyListOfArrays(individual_data)
meandata

data_blank <- meandata
data_blank[is.na(data_blank)] <- ""                     # Replace NA with blank
data_upper <-  upperTriangle(data_blank) <- lowerTriangle(data_blank, byrow=TRUE)

tmp <- data_blank
tmp2<-as.matrix(tmp) ####convert those means to a matrix called tmp2
tmp3 <- as.data.frame(tmp2)
tmp3$X1 <- as.numeric(tmp3$X1)
tmp3$X2 <- as.numeric(tmp3$X2)
tmp3$X3 <- as.numeric(tmp3$X3)
tmp3$X4 <- as.numeric(tmp3$X4)
tmp3$X5 <- as.numeric(tmp3$X5)
tmp3$X6 <- as.numeric(tmp3$X6)
tmp3$X7 <- as.numeric(tmp3$X7)
tmp3$X8 <- as.numeric(tmp3$X8)
tmp3$X9 <- as.numeric(tmp3$X9)
tmp3$X10 <- as.numeric(tmp3$X10)
tmp3$X11 <- as.numeric(tmp3$X11)
tmp3$X12 <- as.numeric(tmp3$X12)
tmp3$X13 <- as.numeric(tmp3$X13)
tmp3$X14 <- as.numeric(tmp3$X14)
tmp3$X15 <- as.numeric(tmp3$X15)
tmp3$X16 <- as.numeric(tmp3$X16)
tmp3$X17 <- as.numeric(tmp3$X17)
tmp3$X18 <- as.numeric(tmp3$X18)
tmp3$X19 <- as.numeric(tmp3$X19)
tmp3$X20 <- as.numeric(tmp3$X20)
tmp4 <- as.matrix(tmp3)
colnames(tmp3) <- c('faateh', 'mazboot', 'ruhani', 'pyara', 'bahadur', 'sabr', 'khush', 'piyar', 'mohabbat', 'aramdah', 'fakhr', 'wajd', 'haal', 'kaifiyat', 'pursukon', 'ishq', 'mast', 'udas', 'kanpna', 'kaif')
par("mar")
par(mar=c(1,1,1,1))
cor_pearson<-cor(tmp3, use = "p") ####runs a pearson correlation, "complete.obs" means all "NA" values are deleted and ignored
cor.plot(cor_pearson, numbers=T, upper=FALSE, main = "Pearson Correlation", show.legend = FALSE) ####plots pearson correlation

#### How many factors? ----------
cor_pearson_smoothed <- cor.smooth(cor_pearson) # Just to smoothen the matrix - FA requires all positive values, so this transforms the data to make all values positive
# This tries to analyse how many factors would work in this data.
par("mar")
par(mar=c(1,1,1,1))
f <- fa.parallel(cor_pearson_smoothed, fa="fa", fm = 'pa',n.obs = 28, main = "Scree Plot",n.iter = 1000,cor = 'cor') ####fa.parallel produces a scree plot of the eigenvalues, from which you can determine the appropriate number of factors basen on how many sharp dips there are. The factor method (fm) is "principal Axis" (pa), fa determines that this is factor analysis, there are 1000 iterations, and "cor" means this information will be found via pearson correlation.
print(f) ####number of factors is 3

#### Actual factor analysis -------------
# For 3 factors as suggested by scree plot
# And rotation options could be adjusted and many others things in FA analysis.
mod <- fa(cor_pearson_smoothed,nfactors = 3,n.obs = 28, rotate = 'varimax') ####this carries out factor analysis on the "smoothed" data, seeking 3 factors and rotating the data such that it maximises the variance (varimax)
knitr::kable(data.frame(psych::fa.sort(mod$loadings)[1:20,]),digits = 2) ####creates a table showing loadings of the 3 factors. 

####By looking at which emotions have the highest loadings for the 3 factor solution, 
#it seems that factor 1 is the strongest, and includes sabr, bahadur, mazboot, khush, fakhr, faateh, which are all virtues. 
#Factor 3 is the second strongest and seems to contain pyara, ishq, ruhani, piyar, and mohabbat, and thus represents spiritual love. 
#Factor 2 is the third strongest and includes kanpna, kaif, haal, and kaifiyat, and thus represents trembling/trance.

####How much of the variance is explained by each factor?
print(mod)
#the three factor solution explains 69% of variance, factor 1 explains 29%, factor 3 explains 25%, and factor 2 14%.

