####Name: Thomas Graves
####Date: 10 January 2024
####Title: A genre-specific measure of subjective feeling in music listening: Constructing the Durham Emotion in Qawwālī Scale (DEQS)
####Study 1: which emotion words have you felt  at Mahfil-e-sama'? (Drawn from sufi literature, Qureshi's book, psychology literature, Urdu traslations of GEMS words, and interviews)
####Likert scale 1-5, 1 as never, 5 as always
####Question: Which emotions are most often felt with qawwali?
####Aim: To reduce the number of emotion concepts to a manageable number to include in comparison task
setwd('~/DEQS_Questionnaire_1/')
rm(list=ls(all=TRUE)) ####cleans R memory
getwd()
df <- read.csv("~/DEQS_Questionnaire_1/Thomas_Graves_Qawwali_Emotion_Concepts_Study_1.csv")
class(df)
library(dplyr)
####Now map  only numbers to the results for each emotion term
mapping <- c("1 (kabhi nahin)" = 1, "2 (kabhi kabhaar)" = 2, "3 (kabhi kabhi)" = 3, "4 (aksar)" = 4, "5 (hamesha)" = 5)
df$Q7_1 <- mapping[df$Q7_1]
df$Q7_2 <- mapping[df$Q7_2]
df$Q7_3 <- mapping[df$Q7_3]
df$Q7_4 <- mapping[df$Q7_4]
df$Q7_5 <- mapping[df$Q7_5]
df$Q7_6 <- mapping[df$Q7_6]
df$Q7_7 <- mapping[df$Q7_7]
df$Q7_8 <- mapping[df$Q7_8]
df$Q7_9 <- mapping[df$Q7_9]
df$Q7_10 <- mapping[df$Q7_10]
df$Q7_11 <- mapping[df$Q7_11]
df$Q7_12 <- mapping[df$Q7_12]
df$Q7_13 <- mapping[df$Q7_13]
df$Q7_14 <- mapping[df$Q7_14]
df$Q7_15 <- mapping[df$Q7_15]
df$Q7_16 <- mapping[df$Q7_16]
df$Q7_17 <- mapping[df$Q7_17]
df$Q7_18 <- mapping[df$Q7_18]
df$Q7_19 <- mapping[df$Q7_19]
df$Q7_20 <- mapping[df$Q7_20]
df$Q7_21 <- mapping[df$Q7_21]
df$Q7_22 <- mapping[df$Q7_22]
df$Q7_23 <- mapping[df$Q7_23]
df$Q7_24 <- mapping[df$Q7_24]
df$Q7_25 <- mapping[df$Q7_25]
df$Q7_26 <- mapping[df$Q7_26]
df$Q7_27 <- mapping[df$Q7_27]
df$Q7_28 <- mapping[df$Q7_28]
df$Q7_29 <- mapping[df$Q7_29]
df$Q7_30 <- mapping[df$Q7_30]
df$Q7_31 <- mapping[df$Q7_31]
df$Q7_32 <- mapping[df$Q7_32]
df$Q7_33 <- mapping[df$Q7_33]
df$Q7_34 <- mapping[df$Q7_34]
df$Q7_35 <- mapping[df$Q7_35]
df$Q7_36 <- mapping[df$Q7_36]
df$Q7_37 <- mapping[df$Q7_37]
df$Q7_38 <- mapping[df$Q7_38]
df$Q7_39 <- mapping[df$Q7_39]
df$Q7_40 <- mapping[df$Q7_40]
df$Q7_41 <- mapping[df$Q7_41]
df$Q7_42 <- mapping[df$Q7_42]
df$Q7_43 <- mapping[df$Q7_43]
df$Q7_44 <- mapping[df$Q7_44]
df$Q7_45 <- mapping[df$Q7_45]
df$Q7_46 <- mapping[df$Q7_46]
df$Q7_47 <- mapping[df$Q7_47]
df$Q7_48 <- mapping[df$Q7_48]
df$Q7_49 <- mapping[df$Q7_49]
df$Q7_50 <- mapping[df$Q7_50]
df$Q7_51 <- mapping[df$Q7_51]
df$Q7_52 <- mapping[df$Q7_52]
df$Q7_53 <- mapping[df$Q7_53]
df$Q7_54 <- mapping[df$Q7_54]
df$Q7_55 <- mapping[df$Q7_55]
df$Q7_56 <- mapping[df$Q7_56]
df$Q7_57 <- mapping[df$Q7_7]
df$Q7_58 <- mapping[df$Q7_58]
df$Q7_59 <- mapping[df$Q7_59]
df$Q7_60 <- mapping[df$Q7_60]
df$Q7_61 <- mapping[df$Q7_61]
df$Q7_62 <- mapping[df$Q7_62]
df$Q7_63 <- mapping[df$Q7_63]
df$Q7_64 <- mapping[df$Q7_64]
df$Q7_65 <- mapping[df$Q7_65]
df$Q7_66 <- mapping[df$Q7_66]
df$Q7_67 <- mapping[df$Q7_67]
df$Q7_68 <- mapping[df$Q7_68]
df$Q7_69 <- mapping[df$Q7_69]
df$Q7_70 <- mapping[df$Q7_70]
df$Q7_71 <- mapping[df$Q7_71]
df$Q7_72 <- mapping[df$Q7_72]
df$Q7_73 <- mapping[df$Q7_73]
df$Q7_74 <- mapping[df$Q7_74]
df$Q7_75 <- mapping[df$Q7_75]
####Create new dataframe including number of emotion word, Mean, and SD
df2 <- data.frame(matrix(ncol = 3, nrow = 75))
x <- c("feelingwordno", "meanfreq", "SD")
colnames(df2) <- x
emonames <- c("wajd","haal", "sama","waqt", "kaif", "kaifiyat", "pursukon", "ishq", "bekhud", "behosh", "fana", "baqa", "mast", "khush", "tawaana", "udaas", "piyaar", "mutmain", "mohabbat", "khauf", "khwaahish", "tauba", "nafrat", "aaraamdah", "ghusa", "bearaam", "fakhr", "purumid", "purjosh", "ghabrayahua", "pareshaan", "dukhi", "akela", "bezaar", "tannha", "hoslashiknihua", "thakahua", "uljhahua", "karaahat", "naaraaz", "ghumgeen", "hakkabakka", "maayus", "avgjazbaati", "joshokharosh", "hasas", "tannaao", "dilchaspi", "sharminda", "rongtekharehojaana", "faateh", "mazboot", "taaqatwar", "ruhaani", "sanjeeda", "pyaara", "kaanpna", "makruh", "sust", "chirchirahua", "madhosh", "lataaluq", "bechain", "bahaadur", "aazaad", "hairat", "sabr", "fikrmand", "mazaahiya", "ajeeb", "mushtael", "shauq", "sahu", "bast", "qabiz")
df2$feelingwordno <- emonames
####Now calculate the mean of each emotion word, excluding missing values and add to df2
avg <- c(mean(df$Q7_1, na.rm=TRUE), mean(df$Q7_2, na.rm=TRUE), mean(df$Q7_3, na.rm=TRUE), mean(df$Q7_4, na.rm=TRUE), mean(df$Q7_5, na.rm=TRUE), mean(df$Q7_6, na.rm=TRUE), mean(df$Q7_7, na.rm=TRUE), mean(df$Q7_8, na.rm=TRUE), mean(df$Q7_9, na.rm=TRUE), mean(df$Q7_10, na.rm=TRUE), mean(df$Q7_11, na.rm=TRUE), mean(df$Q7_12, na.rm=TRUE), mean(df$Q7_13, na.rm=TRUE), mean(df$Q7_14, na.rm=TRUE), mean(df$Q7_15, na.rm=TRUE), mean(df$Q7_16, na.rm=TRUE), mean(df$Q7_17, na.rm=TRUE), mean(df$Q7_18, na.rm=TRUE), mean(df$Q7_19, na.rm=TRUE), mean(df$Q7_20, na.rm=TRUE), mean(df$Q7_21, na.rm=TRUE), mean(df$Q7_22, na.rm=TRUE), mean(df$Q7_23, na.rm=TRUE), mean(df$Q7_24, na.rm=TRUE), mean(df$Q7_25, na.rm=TRUE), mean(df$Q7_26, na.rm=TRUE), mean(df$Q7_27, na.rm=TRUE), mean(df$Q7_28, na.rm=TRUE), mean(df$Q7_29, na.rm=TRUE), mean(df$Q7_30, na.rm=TRUE), mean(df$Q7_31, na.rm=TRUE), mean(df$Q7_32, na.rm=TRUE), mean(df$Q7_33, na.rm=TRUE), mean(df$Q7_34, na.rm=TRUE), mean(df$Q7_35, na.rm=TRUE), mean(df$Q7_36, na.rm=TRUE), mean(df$Q7_37, na.rm=TRUE), mean(df$Q7_38, na.rm=TRUE), mean(df$Q7_39, na.rm=TRUE), mean(df$Q7_40, na.rm=TRUE), mean(df$Q7_41, na.rm=TRUE), mean(df$Q7_42, na.rm=TRUE), mean(df$Q7_43, na.rm=TRUE), mean(df$Q7_44, na.rm=TRUE), mean(df$Q7_45, na.rm=TRUE), mean(df$Q7_46, na.rm=TRUE), mean(df$Q7_47, na.rm=TRUE), mean(df$Q7_48, na.rm=TRUE), mean(df$Q7_49, na.rm=TRUE), mean(df$Q7_50, na.rm=TRUE), mean(df$Q7_51, na.rm=TRUE), mean(df$Q7_52, na.rm=TRUE), mean(df$Q7_53, na.rm=TRUE), mean(df$Q7_54, na.rm=TRUE), mean(df$Q7_55, na.rm=TRUE), mean(df$Q7_56, na.rm=TRUE), mean(df$Q7_57, na.rm=TRUE), mean(df$Q7_58, na.rm=TRUE), mean(df$Q7_59, na.rm=TRUE), mean(df$Q7_60, na.rm=TRUE), mean(df$Q7_61, na.rm=TRUE), mean(df$Q7_62, na.rm=TRUE), mean(df$Q7_63, na.rm=TRUE), mean(df$Q7_64, na.rm=TRUE), mean(df$Q7_65, na.rm=TRUE), mean(df$Q7_66, na.rm=TRUE), mean(df$Q7_67, na.rm=TRUE), mean(df$Q7_68, na.rm=TRUE), mean(df$Q7_69, na.rm=TRUE), mean(df$Q7_70, na.rm=TRUE), mean(df$Q7_71, na.rm=TRUE), mean(df$Q7_72, na.rm=TRUE), mean(df$Q7_73, na.rm=TRUE), mean(df$Q7_74, na.rm=TRUE), mean(df$Q7_75, na.rm=TRUE))
df2$meanfreq <- avg
####Now calculate the standard deviation of each emotion word, excluding missing values and add to df2
sd <- c(sd(df$Q7_1, na.rm=TRUE), sd(df$Q7_2, na.rm=TRUE), sd(df$Q7_3, na.rm=TRUE), sd(df$Q7_4, na.rm=TRUE), sd(df$Q7_5, na.rm=TRUE), sd(df$Q7_6, na.rm=TRUE), sd(df$Q7_7, na.rm=TRUE), sd(df$Q7_8, na.rm=TRUE), sd(df$Q7_9, na.rm=TRUE), sd(df$Q7_10, na.rm=TRUE), sd(df$Q7_11, na.rm=TRUE), sd(df$Q7_12, na.rm=TRUE), sd(df$Q7_13, na.rm=TRUE), sd(df$Q7_14, na.rm=TRUE), sd(df$Q7_15, na.rm=TRUE), sd(df$Q7_16, na.rm=TRUE), sd(df$Q7_17, na.rm=TRUE), sd(df$Q7_18, na.rm=TRUE), sd(df$Q7_19, na.rm=TRUE), sd(df$Q7_20, na.rm=TRUE), sd(df$Q7_21, na.rm=TRUE), sd(df$Q7_22, na.rm=TRUE), sd(df$Q7_23, na.rm=TRUE), sd(df$Q7_24, na.rm=TRUE), sd(df$Q7_25, na.rm=TRUE), sd(df$Q7_26, na.rm=TRUE), sd(df$Q7_27, na.rm=TRUE), sd(df$Q7_28, na.rm=TRUE), sd(df$Q7_29, na.rm=TRUE), sd(df$Q7_30, na.rm=TRUE), sd(df$Q7_31, na.rm=TRUE), sd(df$Q7_32, na.rm=TRUE), sd(df$Q7_33, na.rm=TRUE), sd(df$Q7_34, na.rm=TRUE), sd(df$Q7_35, na.rm=TRUE), sd(df$Q7_36, na.rm=TRUE), sd(df$Q7_37, na.rm=TRUE), sd(df$Q7_38, na.rm=TRUE), sd(df$Q7_39, na.rm=TRUE), sd(df$Q7_40, na.rm=TRUE), sd(df$Q7_41, na.rm=TRUE), sd(df$Q7_42, na.rm=TRUE), sd(df$Q7_43, na.rm=TRUE), sd(df$Q7_44, na.rm=TRUE), sd(df$Q7_45, na.rm=TRUE), sd(df$Q7_46, na.rm=TRUE), sd(df$Q7_47, na.rm=TRUE), sd(df$Q7_48, na.rm=TRUE), sd(df$Q7_49, na.rm=TRUE), sd(df$Q7_50, na.rm=TRUE), sd(df$Q7_51, na.rm=TRUE), sd(df$Q7_52, na.rm=TRUE), sd(df$Q7_53, na.rm=TRUE), sd(df$Q7_54, na.rm=TRUE), sd(df$Q7_55, na.rm=TRUE), sd(df$Q7_56, na.rm=TRUE), sd(df$Q7_57, na.rm=TRUE), sd(df$Q7_58, na.rm=TRUE), sd(df$Q7_59, na.rm=TRUE) ,sd(df$Q7_60, na.rm=TRUE) ,sd(df$Q7_61, na.rm=TRUE), sd(df$Q7_62, na.rm=TRUE), sd(df$Q7_63, na.rm=TRUE), sd(df$Q7_64, na.rm=TRUE), sd(df$Q7_65, na.rm=TRUE), sd(df$Q7_66, na.rm=TRUE), sd(df$Q7_67, na.rm=TRUE), sd(df$Q7_68, na.rm=TRUE), sd(df$Q7_69, na.rm=TRUE), sd(df$Q7_70, na.rm=TRUE), sd(df$Q7_71, na.rm=TRUE), sd(df$Q7_72, na.rm=TRUE), sd(df$Q7_73, na.rm=TRUE), sd(df$Q7_74, na.rm=TRUE), sd(df$Q7_75, na.rm=TRUE))
df2$SD <- sd
View(df2)
####Eliminate all emotion words with mean below 4, create dataframe of emotions to include
df3 <- df2 %>%
  filter(meanfreq >= 4)
View(df3)
####I will also include mast, wajd, haal, and kaifiyat because of their theoretical importance, and udaas in order to include a negatively valenced word



