clear all
set(0,'defaulttextinterpreter','latex')

fontsizevalue = 8;
NP = 6401;
%L = 40;
%B = 40/(NP-1);
NDAT = 201;

hbar = 1.054571726*10^(-34);
u = 1.660539040*10^(-27);
omega = 2*pi*5; 
mLi = 7*u;

load('inversemap.mat');
L1 = sqrt(hbar/(1*mLi*omega))
B =16*L1/(NP-1);
ort = [-8*L1:B:8*L1]*10^6;
T = 2*pi/omega;
zeit = [0:T/(NDAT-1):T]*1000;


axes('Position',[0.2 0.52 0.25 0.25])
data = load('Fig1a.dat');
datamat = reshape(data(:,3),NP,NDAT);
sum(datamat(1:3201,101))/sum(datamat(:,101))
sum(datamat(1:3201,201))/sum(datamat(:,201))
imagesc(ort,zeit,(datamat').^(1/2))
set(gca,'XLim',[-60 60],'XTick',[-60,-30,0.0,30,60],'XTickLabel',{'-60','','0','','60'},'YTick',[0,100,200],'FontSize', fontsizevalue)
xlabel('$x$ [$\mu$m]', 'FontSize', fontsizevalue)
ylabel('$t$ [ms]', 'FontSize', fontsizevalue)
text(-56,180,'(a)','color','w', 'FontSize', fontsizevalue)
set(gca,'YDIR','NORM')
colormap(inversemap)

L100 = sqrt(hbar/(100*mLi*omega));
B = 60*L100/(NP-1);
ort = [-60*L100:B:60*L100]*10^6;


axes('Position',[0.2 0.2 0.25 0.25])
data = load('Fig1b.DAT');
mathlp1 = zeros(3200,NDAT);
mathlp2 = zeros(3200,NDAT);
datamat = reshape(data(:,3),NP,NDAT);
datamat = [mathlp1;datamat;mathlp2];
imagesc(ort,zeit,(datamat').^(1/2))
set(gca,'XLim',100*[-0.6 0.6],'XTick',100*[-0.6,-0.3,0.0,0.3,0.6],'XTickLabel',{'-60','','0','','60'},'YTick',[0,100,200],'FontSize', fontsizevalue)
xlabel('$X$ [$\mu$m]', 'FontSize', fontsizevalue)
ylabel('$t$ [ms]', 'FontSize', fontsizevalue)
text(-57,180,'(b)','color','w', 'FontSize', fontsizevalue)
set(gca,'YDIR','NORM')
colormap(inversemap)

print -depsc2 Fig1.eps
