% compute imagesc plot
set(0,'defaulttextinterpreter','latex')
fsv = 8;

hbar = 1.054571726*10^(-34);
u = 1.660539040*10^(-27);
omega = 2*pi*5; 
mLi = 7*u;

L1 = sqrt(hbar/(100*mLi*omega));

data = load('Fig2a.dat');


xs = data(1:33,2);
xs = [-flipud(xs);xs(2:end)];
axes('Position',[0.2 0.7 0.25 0.2])
ell = 0.5*[0.0:0.025:0.625]*L1*10^6;
datamat = reshape(data(:,4),33,26);
datamatfull = [flipud(datamat);datamat(2:end,:)];
cbarmax = max(max(datamatfull))
imagesc(xs*L1*10^6,ell,datamatfull',[0 cbarmax])
xlabel('$X_s [\mu m]$','FontSize',fsv)
ylabel('$\xi_N [\mu m]$','FontSize',fsv)
load('inversemap.mat');
colormap(inversemap)
cbar = colorbar('Location','EastOutside','YTick',[0.0 0.5 0.998]);
zlab = get(cbar,'ylabel');
set(zlab,'String','$T$');

set(cbar,'Position',[0.46 0.7 0.015 0.2])
set(gca,'XLim',[-0.2 0.2],'YLim',[0.0 0.5],'YDir','Norm','XTick',[-0.2,-0.1,0,0.1,0.2],'YTick',[0.0,0.125,0.25,0.375,0.5], ...
    'XTickLabel',{'-0.2','','0.0','','0.2'},'YTickLabel',{'0.0','','0.25','','0.5'},'FontSize',fsv)
text(-0.19,0.54,'(a)', 'FontSize', fsv)
%title('(a)', 'FontSize', fsv)

axes('Position',[0.2 0.4 0.25 0.2])

data = load('Fig2b.dat');

xs = data(1:33,2);
xs = [-flipud(xs);xs(2:end)];


%x0 = [1:1:9];
x0 = [17.6535*1*L1*10^6:-0.5*1.76535*L1*10^6:0.8827*L1*10^6];
datamat = reshape(data(:,4),33,20);
%
datamatfull = [flipud(datamat);datamat(2:end,:)];

datamat2 = datamatfull';
datamat2 = datamat2(1:end-1,:);
cbarmax = max(max(datamat2))
cbarmin = min(min(datamat2))

imagesc(xs*L1*10^6,x0(1:end-1),datamat2,[0.0 cbarmax])
xlabel('$X_s [\mu m]$','FontSize',fsv)
ylabel('$X_0 [\mu m]$','FontSize',fsv)
%colorbar
cbar = colorbar('Location','EastOutside','YTick',[cbarmin 0.35 0.689],'YTickLabel',{'0.0','0.35','0.689'});
%cbar = colorbar('Location','EastOutside','YTick',[0.0 0.35 0.689]);
zlab = get(cbar,'ylabel');
set(zlab,'String','$T$');
set(cbar,'Position',[0.46 0.4 0.015 0.2])
set(gca,'XLim',[-0.2 0.2],'YLim',[5 30],'YDir','Norm','XTick',[-0.2,-0.1, 0,0.1,0.2 ],'YTick',[5,17.5,30], ...
   'XTickLabel',{'-0.2','','0.0','','0.2'},'YTickLabel',{'5.0','17.5','30.0'},'FontSize',fsv)
text(-0.19,33,'(b)', 'FontSize', fsv)
%title('(b)', 'FontSize', fsv)

axes('Position',[0.2 0.1 0.25 0.2])

data = load('Fig2b.dat');

xs = data(1:33,2);
xs = [-flipud(xs);xs(2:end)];

data = load('TanalytN100.dat');
%x0 = [1:1:9];
x0 = [17.6535*1*L1*10^6:-0.5*1.76535*L1*10^6:0.8827*L1*10^6];
%datamat = reshape(data(:,4),33,20);
datamat = reshape(data(:,4),133,101);
%
%datamatfull = [flipud(datamat);datamat(2:end,:)];
cbarmax = max(max(datamat));
cbarmin = min(min(datamat));
imagesc(data(1:101:end,3),data(1:133,2),datamat,[0.0 cbarmax])
xlabel('$X_s [\mu m]$','FontSize',fsv)
ylabel('$X_0 [\mu m]$','FontSize',fsv)
cbar = colorbar('Location','EastOutside','YTick',[cbarmin 0.5 1],'YTickLabel',{'0.0','0.5','1.0'});
%cbar = colorbar('Location','EastOutside','YTick',[0.0 0.35 0.689]);
zlab = get(cbar,'ylabel');
set(zlab,'String','$T$');
set(cbar,'Position',[0.46 0.1 0.015 0.2])
set(gca,'XLim',[-0.2 0.2],'YLim',[5 30],'YDir','Norm','XTick',[-0.2,-0.1, 0,0.1,0.2 ],'YTick',[5,17.5,30], ...
   'XTickLabel',{'-0.2','','0.0','','0.2'},'YTickLabel',{'5.0','17.5','30.0'},'FontSize',fsv)
text(-0.19,33,'(c)', 'FontSize', fsv)
%title('(c)', 'FontSize', fsv)


print -depsc Fig2.eps
