import dwave_networkx as dnx
import minorminer as mm
import domain_wall_and_one_hot_encode as dwoh
import numpy as np
import numpy.random as rand

nColorList=np.array(range(3,10))
nSample=10
one_hot_min_sizes=np.zeros([len(nColorList),nSample])
domain_wall_min_sizes=np.zeros([len(nColorList),nSample])
one_hot_counts=np.zeros([len(nColorList),nSample])
domain_wall_counts=np.zeros([len(nColorList),nSample])
one_hot_counts_noEmb=np.zeros([len(nColorList),nSample])
domain_wall_counts_noEmb=np.zeros([len(nColorList),nSample])
for iSample in range(nSample): # run 10 random embeddings to get statistics for plot
    (one_hot_min_sizes[:,iSample],one_hot_counts[:,iSample],one_hot_counts_noEmb[:,iSample],domain_wall_min_sizes[:,iSample],domain_wall_counts[:,iSample],domain_wall_counts_noEmb[:,iSample])=dwoh.smallest_chimera_embedding_random_fixed_color_ratio(0.75,2,nColorList)
saveData={}
saveData['nColorList']=nColorList
saveData['one_hot_min_sizes']=one_hot_min_sizes
saveData['domain_wall_min_sizes']=domain_wall_min_sizes
saveData['one_hot_counts']=one_hot_counts
saveData['domain_wall_counts']=domain_wall_counts
saveData['one_hot_counts_noEmb']=one_hot_counts_noEmb
saveData['domain_wall_counts_noEmb']=domain_wall_counts_noEmb
np.save('fix_ratio_color_0p75_r2_multi_data',saveData)
