import dwave_networkx as dnx
import minorminer as mm
import domain_wall_and_one_hot_encode as dwoh
import numpy as np
import numpy.random as rand

sizeList=np.array(range(3,31))
nSample=10
one_hot_min_sizes=np.zeros([len(sizeList),nSample])
domain_wall_min_sizes=np.zeros([len(sizeList),nSample])
one_hot_counts=np.zeros([len(sizeList),nSample])
domain_wall_counts=np.zeros([len(sizeList),nSample])
one_hot_counts_noEmb=np.zeros([len(sizeList),nSample])
domain_wall_counts_noEmb=np.zeros([len(sizeList),nSample])
for iSample in range(nSample): # run 10 random embeddings to get statistics for plot
    (one_hot_min_sizes[:,iSample],one_hot_counts[:,iSample],one_hot_counts_noEmb[:,iSample],domain_wall_min_sizes[:,iSample],domain_wall_counts[:,iSample],domain_wall_counts_noEmb[:,iSample])=dwoh.smallest_pegasus_embedding_independent_random_color(0.5,3,sizeList)
saveData={}
saveData['sizeList']=sizeList
saveData['one_hot_min_sizes']=one_hot_min_sizes
saveData['domain_wall_min_sizes']=domain_wall_min_sizes
saveData['one_hot_counts']=one_hot_counts
saveData['domain_wall_counts']=domain_wall_counts
saveData['one_hot_counts_noEmb']=one_hot_counts_noEmb
saveData['domain_wall_counts_noEmb']=domain_wall_counts_noEmb
np.save('three_color_0p5_multi_data_peg',saveData)
