import dwave_networkx as dnx
import minorminer as mm
import domain_wall_and_one_hot_encode as dwoh
import numpy as np
import numpy.random as rand

nEventList=[5,10,15]
conflictProb=0.75
eventTimeRatio=2
nSample=10
maxDuration=5
one_hot_min_sizes=np.zeros([len(nEventList),nSample])
domain_wall_min_sizes=np.zeros([len(nEventList),nSample])
one_hot_counts=np.zeros([len(nEventList),nSample])
domain_wall_counts=np.zeros([len(nEventList),nSample])
one_hot_counts_noEmb=np.zeros([len(nEventList),nSample])
domain_wall_counts_noEmb=np.zeros([len(nEventList),nSample])
for iSample in range(nSample): # run 10 random embeddings to get statistics for plot
    (one_hot_min_sizes[:,iSample],one_hot_counts[:,iSample],one_hot_counts_noEmb[:,iSample],domain_wall_min_sizes[:,iSample],domain_wall_counts[:,iSample],domain_wall_counts_noEmb[:,iSample])=dwoh.smallest_chimera_embedding_random_fixed_time_nEvent_ratio(conflictProb,maxDuration,eventTimeRatio,nEventList)
saveData={}
saveData['nEventList']=nEventList
saveData['one_hot_min_sizes']=one_hot_min_sizes
saveData['domain_wall_min_sizes']=domain_wall_min_sizes
saveData['one_hot_counts']=one_hot_counts
saveData['domain_wall_counts']=domain_wall_counts
saveData['one_hot_counts_noEmb']=one_hot_counts_noEmb
saveData['domain_wall_counts_noEmb']=domain_wall_counts_noEmb
np.save('fix_ETratio_sched_0p75conflict_ETratio2_maxDuration5_multi_data',saveData)
