module routines

use common_var

implicit none

contains
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ALEA :: generates a pseudo-random number between 0 and 1
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function alea(iseed)

implicit none
integer :: iseed
integer :: j,k
real(8) :: alea
integer, parameter :: im1=2147483563,im2=2147483399, imm1=im1-1, ia1=40014, &
ia2=40692,iq1=53668,iq2=52774,ir1=12211,ir2=3791, ntab=32,ndiv=1+imm1/ntab
real(8), parameter :: am=1.d0/im1, eps=1.2e-16,rnmx=1.-eps
integer, save :: iy,iseed2
integer, dimension(ntab), save :: iv
data iseed2/123456789/, iv/ntab*0/, iy/0/

if (iseed.le.0) then
        iseed=max(-iseed,1)
        iseed2=iseed
        do 11 j=ntab+8,1,-1
          k=iseed/iq1
          iseed=ia1*(iseed-k*iq1)-k*ir1
          if (iseed.lt.0) iseed=iseed+im1
          if (j.le.ntab) iv(j)=iseed
11      continue
        iy=iv(1)
      endif
      k=iseed/iq1
      iseed=ia1*(iseed-k*iq1)-k*ir1
      if (iseed.lt.0) iseed=iseed+im1
      k=iseed2/IQ2
      iseed2=IA2*(iseed2-k*IQ2)-k*ir2
      if (iseed2.lt.0) iseed2=iseed2+im2
      j=1+iy/ndiv
      iy=iv(j)-iseed2
      iv(j)=iseed
      if(iy.lt.1)iy=iy+imm1
      alea=min(am*iy,rnmx)
      return

end function
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! NEIGHBOURS :: finds the neighbours of each bin
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine neighbours(pos,nline,ncolumn,nsites)

implicit none
integer, intent(in) :: nline, ncolumn, nsites
real, dimension(nsites,2), intent(out) :: pos
integer :: i, j, k

k = 0

do i = 1, nline

  do j = 1, ncolumn

    k = k + 1

    pos(k,1) = real(i) / real(nline) 
    pos(k,2) = real(j) / real(ncolumn)

    if (i == 1) then
      neigh(k,1) = k + (nline-1) * ncolumn
      neigh(k,3) = k + ncolumn
    else if (i == nline) then
      neigh(k,1) = k - ncolumn
      neigh(k,3) = k - (nline-1) *  ncolumn
    else
      neigh(k,1) = k - ncolumn
      neigh(k,3) = k + ncolumn
    end if

    if (j == 1) then
      neigh(k,4) = k + (ncolumn-1)
      neigh(k,2) = k + 1
    else if (j == ncolumn) then
      neigh(k,4) = k - 1
      neigh(k,2) = k - (ncolumn-1)
    else
      neigh(k,4) = k - 1
      neigh(k,2) = k + 1
    end if

  end do

end do

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! INIT_SPIN :: Generates a random distribution of spins
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine init_spin(n,f)

implicit none
integer, intent(in) :: n
integer :: ncount, i
real, intent(in) :: f
real(8) :: r

ncount=nint(n*f)
s=0

if (f==0.0) then

  s = 0

else if (f==1.0) then

  s = 1

else

  do while (ncount>0)

  12 r = alea(seed)
     i = int(r*n)

     if (i==0) go to 12
     if (s(i)==0) then
       s(i) = 1
       ncount = ncount - 1
     else
     end if

  end do

end if

end subroutine


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ELINETENSION: computes the energy of a site i due to line tension
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function elinetension(i,n,spins)

implicit none
integer, intent(in) :: i, n
real(8), dimension(n), intent(in) :: spins
integer :: j, l
real(8) :: elinetension

elinetension = 0.

do j = 1, 4
  l = int(neigh(i,j))
  elinetension = elinetension+xor(int(spins(i)),int(spins(l)))
end do

end function
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ELINETENSION_THERMO: computes the energy of a site i due to line tension for 
! thermodinamic integration. Allows values of spin which are not integers
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function elinetension_thermo(i,n,spins)

implicit none
integer, intent(in) :: i, n
real(8), dimension(n), intent(in) :: spins
integer :: j, l
real(8) :: elinetension_thermo

elinetension_thermo = 0.

do j = 1, 4
  l = int(neigh(i,j))
  elinetension_thermo = elinetension_thermo+abs(spins(i)-spins(l))
end do

end function

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ENER :: computes the total energy of the system
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine energy(n,ener)

implicit none
integer, intent(in) :: n
integer :: i
real(8), intent(out) :: ener

ener = 0.

do i = 1, n

  ener = ener + elinetension(i,n,s)

end do

ener = 0.5 * inter_par * ener  

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ENER_THERMO :: computes the total energy of the system for thermodynamic 
! integration. Allows values of spin which are not integers
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine energy_thermo(n,ener)

implicit none
integer, intent(in) :: n
integer :: i
real(8), intent(out) :: ener

ener = 0.

do i = 1, n

  ener = ener + elinetension_thermo(i,n,s)

end do

ener = 0.5 * inter_par * ener  

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ENERGY_TI :: computes the total energy of the system with a value of lambda
!              for thermodynamic integration. 
!              U(lambda) = U(A) + lambda*sum[h*(sp-si)]
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine energy_ti(nfixed,ener,npatch)

implicit none
integer, intent(in) :: nfixed, npatch
integer :: i
real(8) :: ener1, ener2
real(8), intent(out) :: ener

!ener1 :: energy cost of protein 1
!ener2 :: energy cost of protein 2

ener = 0.
ener1 = 0.
ener2 = 0.

if (npatch==1) then 
  do i = 1, nfixed
    ener1 = ener1 + (sblock1(i)-s(fixed1(i)))**2.
  end do
else if (npatch == 2 .or. npatch == 3) then
  do i = 1, nfixed
    ener1 = ener1 + (sblock1(i)-s(fixed1(i)))**2.
    ener2 = ener2 + (sblock2(i)-s(fixed2(i)))**2.
  end do
end if

ener = ext_field * (ener1 + ener2)

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! SORT: makes an array with the tiles with spin=1 (green) first and then tiles 
!       with spin=0 (red)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine sort(n,n1)

implicit none
integer, intent(in) :: n
integer :: i, iarray
integer, intent(out) :: n1

sorted = 0
iarray = 0
n1 = 0

do i = 1, n

  if ( s(i) == 1 ) then
    iarray = iarray + 1
    sorted(iarray) = i
  end if

end do

n1 = iarray

do i = 1, n

  if ( s(i) == 0 ) then
    iarray = iarray + 1
    sorted(iarray) = i
  end if

end do

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! MC_SWAP :: picks one green tile (spin=1) at random and tries to exchange it 
!            with a red tile (spin=0) also picked at random.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine mc_swap(n1,n,iacc,nf)

implicit none
integer, intent(in) :: n, n1, nf
integer :: ran_spin, s_ran, i
integer, intent(out) :: iacc
real(8) :: eline_old, de_line, dener
real(8) :: r

iacc = 1

!Picking one spin randomly
10 ran_spin = rand_tile(0,n)

do i = 1, nf
  if (ran_spin == fixed1(i) .or. ran_spin == fixed2(i)) go to 10
end do

!Saving the values of its spin and energies
s_ran = s(ran_spin)
eline_old = elinetension(ran_spin,n,s)

!Proposing the swap
if (s_ran == 1) then 
  s(ran_spin) = 0
else
  s(ran_spin) = 1
end if

!Calculating the energy
de_line = inter_par * ( elinetension(ran_spin,n,s) - eline_old )
dener = de_line 

!Applying the Metropolis criterion
if (dener > 0.) then

  r=alea(seed)

  if (r > exp(-beta*dener)) then
    s(ran_spin) = s_ran
    iacc = 0
  end if

end if

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! rand_tile: picks one tile at random from an interval between nmin and nmax 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function rand_tile(nmin,nmax)

integer, intent(in) :: nmin, nmax
integer :: l
integer :: rand_tile

l = nmax - nmin

rand_tile = int(alea(seed)*l+nmin)

if (rand_tile == nmin) rand_tile = nmax

end function


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! DISKS :: creates two blocky disks 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine disks(nline,ncolumn,length,nf,npatch,init)

implicit none
integer :: t_init, ilike, ierror, i, j, k, u, v, add1, add2, nadd1, nadd2, dist
integer :: t1a, t1b, t2a, t2b, counter, add, nsites, dsize
integer, dimension(length) :: block1, block2
integer, intent(in) :: nline, ncolumn, length, npatch, init
integer, intent(out) :: nf


if (init == 1) then

  open(unit=40, file='interactions.inp', status='old', action='read', iostat=ierror)
  if (ierror/= 0) write(*,*) 'error while opening interactions.inp'

  !initializing variables
  read(40,*) t_init, t_init, t_init, dist
  close(40)
  nsites = nline * ncolumn
  dsize = 1
  nadd1 = 0
  nadd2 = 0
  block1=0
  block2=0
  fixed1=0
  fixed2=0
  block1(1) = t_init
  block2(1) = t_init + dist
  nf = length + 4*int(sqrt(real(length)))

  if (npatch /= 0) then

10  nadd1 = dsize
    nadd2 = dsize

    do i = 1, dsize

      do j = 3, 4

        add1 = 1
        add2 = 1

        do k = 1, dsize!nf
          if (neigh(block1(i),j) == block1(k)) add1 = 0
          if (neigh(block2(i),j) == block2(k)) add2 = 0
        end do

        if (add1 == 1) then
          nadd1 = nadd1 + 1
          block1(nadd1) = neigh(block1(i),j)
        end if
        if (add2 == 1) then
          nadd2 = nadd2 + 1
          block2(nadd1) = neigh(block2(i),j)
        end if
      end do

    end do

    dsize = nadd1
    i=0
    counter = dsize

    do while (counter > 0)
      i = i + 1
      t1a = block1(i)
      t2a = block2(i)

      do j = i + 1, dsize

        t1b = block1(j)
        t2b = block2(j)

        do u = 1, 2
          do v = 1, 2
            if (neigh(t1a,u+2) == neigh(t1b,v+2)) then
              add = 1
              do k = 1, dsize
                if (block1(k) == neigh(t1a,u+2))  add = 0
              end do
              if (add/=0) then
                dsize = dsize + 1
                counter = counter + 1
                block1(dsize) = neigh(t1a,u+2)
                block2(dsize) = neigh(t2a,u+2)
                if (dsize < length) go to 10
              end if
            end if
          end do
        end  do

      end do

    counter = counter -1
    end do

! fixing the solvent adjacent to the patch
    nadd1 = 0
    nadd2 = 0
    fixed1=-1
    fixed2=-1

    do i =1, dsize
      fixed1(i) = block1(i)
      fixed2(i) = block2(i)
    end do



    do i = 1, dsize

      do j = 1, 4 !!!!CHANGE THE VALUE OF J TO 3!!!!!!!

        add1 = 1
        add2 = 1

        do k = 1, nf
          if (neigh(block1(i),j) == fixed1(k)) add1 = 0
          if (neigh(block2(i),j) == fixed2(k)) add2 = 0
        end do

        if (add1 == 1) then
          nadd1 = nadd1 + 1
          fixed1(dsize+nadd1) = neigh(block1(i),j)
        end if    
        if (add2 == 1) then 
          nadd2 = nadd2 + 1
          fixed2(dsize+nadd2) = neigh(block2(i),j)
        end if
      end do
      
    end do

    if (npatch == 1) then 
      fixed2 = -10
    else if (npatch == 0) then
      fixed1 = -10
      fixed2 = -10
    end if

  else

    block1=-10
    block2=-10
    fixed1=-10
    fixed2=-10

  end if

else 

  nf = length + 4*int(sqrt(real(length)))

end if

end subroutine

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! GREATEST :: subroutine to sort an array from its greatest to its lowest value
! Arrays must have values greater than zero
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine greatest(n, B, t)
implicit none
integer, intent(in) :: n
integer, dimension(n), intent(inout) ::  B
integer, dimension(n) :: B2, pos
integer, intent(out) :: t
integer :: Bmax, lmax, i, iout

!B : array to be sorted
!n : dimension of the array
!Bmax : value of the greatest element
!lmax : position of the greatest element in the array

B2 = B
t = 0

10 iout = 0
Bmax = B(n)

do i = 1 , n

  if (B2(i) >= Bmax .and. B2(i) > 0) then
    Bmax = B2(i)
    lmax= i
    iout = 1
  end if

end do


if (iout == 1) then
  t = t + 1
  B2(lmax) = 0
  pos(t) = lmax
  go to 10
end if

do i = 1, t
  B2(i) = B(pos(i))
end do

B = B2

return

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! DIST :: writes a file with the distances between sites
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine dist(nsites,nline,ncolumn,pos)

implicit none
integer, intent(in) :: nsites, nline, ncolumn
real, dimension(nsites,2), intent(in) :: pos
integer :: i, j
real(8) :: dx, dy, dz, d

open(unit=14,file='dist.dat',status='replace',action='write')

do j = 1, nsites
  dx = pos(1,1) - pos(j,1)
  dy = pos(1,2) - pos(j,2)
!  d = sqrt(((dx-dnint(dx))*nline)**2. + ((dy-dnint(dy))*ncolumn)**2. )
  d = sqrt(((dx-nint(dx))*nline)**2. + ((dy-nint(dy))*ncolumn)**2. )
  write(14,*) d
end do

close(14)

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! SWITCH_PATCH :: Asigns values to the spins in the patches according to the 
! value of the thermodynamic integration parameter. 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine switch_patch(nfixed,nsites,mode,pattern,npatch)

implicit none
integer, intent(in) :: nfixed, nsites, mode, npatch, pattern
real :: spin1, spin2
integer :: i
real(8) :: alea

! mode=0 :: reads a configuration for patches 1 and 2
! mode=1 :: starts a new configuration for patches 1 and 2
! mode=2 :: writes the actual configuration of patches 1 and 2
! npatch :: number of patches in the configuration

if (mode == 2) then

  open(unit=726,file='fixed1.dat',status='replace',action='write')
  open(unit=727,file='fixed2.dat',status='replace',action='write')

  if (npatch == 2 .or. npatch == 3) then

    do i = 1, nfixed
      write(726,*) fixed1(i), sfixed1(i), s(fixed1(i))
      write(727,*) fixed2(i), sfixed2(i), s(fixed2(i))
    end do

  else if (npatch == 1) then

    do i = 1, nfixed
      write(726,*) fixed1(i), sfixed1(i), s(fixed1(i))
      write(727,*) fixed2(i), fixed2(i), fixed2(i)
    end do

  else

    do i = 1, nfixed
      write(726,*) fixed1(i), fixed1(i), fixed1(i)
      write(727,*) fixed2(i), fixed2(i), fixed2(i)
    end do

  end if

  close(726)
  close(727)

elseif (mode == 1) then

  open(unit=726,file='fixed1.dat',status='replace',action='write')
  open(unit=727,file='fixed2.dat',status='replace',action='write')

  if (pattern == 1) then
  open(unit=12,file='spins1.dat',status='old',action='read')
  open(unit=13,file='spins2.dat',status='old',action='read')
  do i = 1, nfixed
    read(12,*) sblock1(i)
    read(13,*) sblock2(i)
  end do
  close(12)
  close(13)
  else if (pattern == 0) then
    sblock1 = sblock1(1)
    sblock2 = sblock2(1)
  end if
 
  do i = 1, nfixed

    if (npatch == 3) then
      spin1 = sblock1(i)
      sfixed1(i) = spin1 
      s(fixed1(i)) = spin1
      write(726,*) fixed1(i), spin1, s(fixed1(i))
      spin2 = s(fixed2(i))
      sfixed2(i) = spin2
      write(727,*) fixed2(i), spin2, s(fixed2(i))
    elseif (npatch == 2) then
      spin1 = s(fixed1(i))
      sfixed1(i) = spin1
      write(726,*) fixed1(i), spin1, s(fixed1(i))
      spin2 = s(fixed2(i))
      sfixed2(i) = spin2
      write(727,*) fixed2(i), spin2, s(fixed2(i))
    else if (npatch == 1) then
      spin1 = s(fixed1(i))
      sfixed1(i) = spin1
      write(726,*) fixed1(i), spin1, s(fixed1(i))
    end if

  end do

  close(726)
  close(727)

else if (mode == 0) then

  open(unit=726,file='fixed1.dat',status='old',action='read')
  open(unit=727,file='fixed2.dat',status='old',action='read')
  open(unit=12,file='spins1.dat',status='old',action='read')
  open(unit=13,file='spins2.dat',status='old',action='read')

  if (pattern == 1) then
  do i = 1, nfixed
    read(12,*) sblock1(i)
    read(13,*) sblock2(i)
  end do
  else if (pattern == 0) then
    sblock1 = sblock1(1)
    sblock2 = sblock2(1)
  end if

  do i = 1, nfixed

    if (npatch == 2 .or. npatch == 3) then
      read(726,*) fixed1(i), sfixed1(i), s(fixed1(i))
      read(727,*) fixed2(i), sfixed2(i), s(fixed2(i))
    else if (npatch == 1) then
      read(726,*) fixed1(i), sfixed1(i), s(fixed1(i))
      read(727,*) fixed2(i)
    else    
      read(726,*) fixed1(i)
      read(727,*) fixed2(i)
    end if
  
  end do

  close(12)
  close(13)
  close(726)
  close(727)

end if


end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! MC_FLIP_THERMO_2 :: picks one random tile and flips its spin. (for two proteins)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine mc_flip_thermo_2(eline_tot,n,nf,iacc)
implicit none
integer, intent(in) :: n, nf
integer :: ran_spin, i
integer, intent(out) :: iacc 
real :: sfixed_ran, s_ran
real(8) :: e_old, e_new, eline_new, eline_old, e_p1, e_p2, dener
real(8) :: r, eline_tot_old
real(8), intent(inout) :: eline_tot

!eline_new :: energy due to line tension of site i
!eline_tot :: energy due to total line tension
!e_p1 :: energy to the external field creating protein 1
!e_p2 :: energy to the external field creating protein 2

iacc = 1

!Picking one spin randomly
ran_spin = rand_tile(0,n)

!Calculating the energy of the configuration
e_p1 = 0
e_p2 = 0
eline_old = inter_par * elinetension_thermo(ran_spin,n,s)

do i = 1, nf
  e_p1 = e_p1 + lambda * ext_field * (sblock1(i)-s(fixed1(i)))**2.
  e_p2 = e_p2 + lambda * ext_field * (sblock2(i)-s(fixed2(i)))**2.
end do

!Saving the values of its spin and energies
eline_tot_old = eline_tot
s_ran = s(ran_spin)
e_old = eline_tot + e_p1 + e_p2

!Proposing the swap
if (s_ran == 1) then 
  s(ran_spin) = 0
else
  s(ran_spin) = 1
end if

do i = 1, nf
  if (ran_spin == fixed1(i) .or. ran_spin == fixed2(i)) then
    s(ran_spin) = alea(seed) 
    if ( s(ran_spin) <= 1. .and. s(ran_spin) > 0.8 ) then
      s(ran_spin) = 1.
    else if ( s(ran_spin) <= 0.8 .and. s(ran_spin) > 0.6 ) then
      s(ran_spin) = 0.75
    else if ( s(ran_spin) <= 0.6 .and. s(ran_spin) > 0.4 ) then
      s(ran_spin) = 0.5
    else if ( s(ran_spin) <= 0.4 .and. s(ran_spin) > 0.2 ) then
      s(ran_spin) = 0.25
    else if ( s(ran_spin) <= 0.2 ) then
      s(ran_spin) = 0.0
    end if
  end if
end do

!Calculating the energy of the new configuration
e_p1 = 0
e_p2 = 0
eline_new = inter_par * elinetension_thermo(ran_spin,n,s)
eline_tot = eline_tot_old + (eline_new - eline_old)

do i = 1, nf
  e_p1 = e_p1 + lambda * ext_field * (sblock1(i)-s(fixed1(i)))**2.
  e_p2 = e_p2 + lambda * ext_field * (sblock2(i)-s(fixed2(i)))**2.
end do

e_new = eline_tot + e_p1 + e_p2

!Applying the Metropolis criterion
dener = ( e_new - e_old )

if (dener > 0.) then

  r=alea(seed)

  if (r > exp(-beta*dener)) then
    s(ran_spin) = s_ran
    eline_tot = eline_tot_old
    iacc = 0
  end if

end if

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! MC_FLIP_THERMO_0 :: picks one random tile and flips its spin. (without proteins)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine mc_flip_thermo_0(eline_tot,n,nf,iacc)
implicit none
integer, intent(in) :: n, nf
integer :: ran_spin, i
integer, intent(out) :: iacc 
real :: sfixed_ran, s_ran
real(8) :: e_old, e_new, eline_new, eline_old, e_p1, e_p2, dener
real(8) :: r, eline_tot_old
real(8), intent(inout) :: eline_tot

!eline_new :: energy due to line tension of site i
!eline_tot :: energy due to total line tension
!e_p1 :: energy to the external field creating protein 1
!e_p2 :: energy to the external field creating protein 2

iacc = 1

!Picking one spin randomly
ran_spin = rand_tile(0,n)

!Calculating the energy of the configuration
e_p1 = 0
e_p2 = 0
eline_old = inter_par * elinetension_thermo(ran_spin,n,s)


!Saving the values of its spin and energies
eline_tot_old = eline_tot
s_ran = s(ran_spin)
e_old = eline_tot + e_p1 + e_p2

!Proposing the swap
if (s_ran == 1) then 
  s(ran_spin) = 0
else
  s(ran_spin) = 1
end if

do i = 1, nf
  if (ran_spin == fixed1(i) .or. ran_spin == fixed2(i)) then
    s(ran_spin) = alea(seed) 
    if ( s(ran_spin) <= 1. .and. s(ran_spin) > 0.8 ) then
      s(ran_spin) = 1.
    else if ( s(ran_spin) <= 0.8 .and. s(ran_spin) > 0.6 ) then
      s(ran_spin) = 0.75
    else if ( s(ran_spin) <= 0.6 .and. s(ran_spin) > 0.4 ) then
      s(ran_spin) = 0.5
    else if ( s(ran_spin) <= 0.4 .and. s(ran_spin) > 0.2 ) then
      s(ran_spin) = 0.25
    else if ( s(ran_spin) <= 0.2 ) then
      s(ran_spin) = 0.0
    end if
  end if
end do

!Calculating the energy of the new configuration
e_p1 = 0
e_p2 = 0
eline_new = inter_par * elinetension_thermo(ran_spin,n,s)
eline_tot = eline_tot_old + (eline_new - eline_old)

e_new = eline_tot + e_p1 + e_p2

!Applying the Metropolis criterion
dener = ( e_new - e_old )

if (dener > 0.) then

  r=alea(seed)

  if (r > exp(-beta*dener)) then
    s(ran_spin) = s_ran
    eline_tot = eline_tot_old
    iacc = 0
  end if

end if

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! MC_FLIP_THERMO_1 :: picks one random tile and flips its spin. (for 1 protein)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine mc_flip_thermo_1(eline_tot,n,nf,iacc)
implicit none
integer, intent(in) :: n, nf
integer :: ran_spin, i
integer, intent(out) :: iacc 
real :: sfixed_ran, s_ran
real(8) :: e_old, e_new, eline_new, eline_old, e_p1, e_p2, dener
real(8) :: r, eline_tot_old
real(8), intent(inout) :: eline_tot

!eline_new :: energy due to line tension of site i
!eline_tot :: energy due to total line tension
!e_p1 :: energy to the external field creating protein 1
!e_p2 :: energy to the external field creating protein 2

iacc = 1

!Picking one spin randomly
ran_spin = rand_tile(0,n)

!Calculating the energy of the configuration
e_p1 = 0
e_p2 = 0
eline_old = inter_par * elinetension_thermo(ran_spin,n,s)

do i = 1, nf
  e_p1 = e_p1 + lambda * ext_field * (sblock1(i)-s(fixed1(i)))**2.
end do

!Saving the values of its spin and energies
eline_tot_old = eline_tot
s_ran = s(ran_spin)
e_old = eline_tot + e_p1 + e_p2

!Proposing the swap
if (s_ran == 1) then 
  s(ran_spin) = 0
else
  s(ran_spin) = 1
end if

do i = 1, nf
  if (ran_spin == fixed1(i) .or. ran_spin == fixed2(i)) then
    s(ran_spin) = alea(seed) 
    if ( s(ran_spin) <= 1. .and. s(ran_spin) > 0.8 ) then
      s(ran_spin) = 1.
    else if ( s(ran_spin) <= 0.8 .and. s(ran_spin) > 0.6 ) then
      s(ran_spin) = 0.75
    else if ( s(ran_spin) <= 0.6 .and. s(ran_spin) > 0.4 ) then
      s(ran_spin) = 0.5
    else if ( s(ran_spin) <= 0.4 .and. s(ran_spin) > 0.2 ) then
      s(ran_spin) = 0.25
    else if ( s(ran_spin) <= 0.2 ) then
      s(ran_spin) = 0.0
    end if
  end if
end do

!Calculating the energy of the new configuration
e_p1 = 0
e_p2 = 0
eline_new = inter_par * elinetension_thermo(ran_spin,n,s)
eline_tot = eline_tot_old + (eline_new - eline_old)

do i = 1, nf
  e_p1 = e_p1 + lambda * ext_field * (sblock1(i)-s(fixed1(i)))**2.
end do

e_new = eline_tot + e_p1 + e_p2

!Applying the Metropolis criterion
dener = ( e_new - e_old )

if (dener > 0.) then

  r=alea(seed)

  if (r > exp(-beta*dener)) then
    s(ran_spin) = s_ran
    eline_tot = eline_tot_old
    iacc = 0
  end if

end if

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! MC_FLIP_THERMO_1FIXED :: picks one random tile and flips its spin. The spins 
!                          in protein 1 are not allowed to change
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine mc_flip_thermo_1fixed(eline_tot,n,nf,iacc)
implicit none
integer, intent(in) :: n, nf
integer :: ran_spin, i
integer, intent(out) :: iacc 
real :: sfixed_ran, s_ran
real(8) :: e_old, e_new, eline_new, eline_old, e_p1, e_p2, dener
real(8) :: r, eline_tot_old
real(8), intent(inout) :: eline_tot

!eline_new :: energy due to line tension of site i
!eline_tot :: energy due to total line tension
!e_p1 :: energy to the external field creating protein 1
!e_p2 :: energy to the external field creating protein 2

iacc = 1

!Picking one spin randomly
20 ran_spin = rand_tile(0,n)

do i = 1, nf
  if (ran_spin == fixed1(i)) go to 20
end do

!Calculating the energy of the configuration
e_p1 = 0
e_p2 = 0
eline_old = inter_par * elinetension_thermo(ran_spin,n,s)

do i = 1, nf
  e_p1 = e_p1 + lambda * ext_field * (sblock1(i)-s(fixed1(i)))**2.
  e_p2 = e_p2 + lambda * ext_field * (sblock2(i)-s(fixed2(i)))**2.
end do

!Saving the values of its spin and energies
eline_tot_old = eline_tot
s_ran = s(ran_spin)
e_old = eline_tot + e_p1 + e_p2

!Proposing the swap
if (s_ran == 1) then 
  s(ran_spin) = 0
else
  s(ran_spin) = 1
end if

do i = 1, nf
  if (ran_spin == fixed1(i) .or. ran_spin == fixed2(i)) then
    s(ran_spin) = alea(seed) 
    if ( s(ran_spin) <= 1. .and. s(ran_spin) > 0.8 ) then
      s(ran_spin) = 1.
    else if ( s(ran_spin) <= 0.8 .and. s(ran_spin) > 0.6 ) then
      s(ran_spin) = 0.75
    else if ( s(ran_spin) <= 0.6 .and. s(ran_spin) > 0.4 ) then
      s(ran_spin) = 0.5
    else if ( s(ran_spin) <= 0.4 .and. s(ran_spin) > 0.2 ) then
      s(ran_spin) = 0.25
    else if ( s(ran_spin) <= 0.2 ) then
      s(ran_spin) = 0.0
    end if
  end if
end do

!Calculating the energy of the new configuration
e_p1 = 0
e_p2 = 0
eline_new = inter_par * elinetension_thermo(ran_spin,n,s)
eline_tot = eline_tot_old + (eline_new - eline_old)

do i = 1, nf
  e_p1 = e_p1 + lambda * ext_field * (sblock1(i)-s(fixed1(i)))**2.
  e_p2 = e_p2 + lambda * ext_field * (sblock2(i)-s(fixed2(i)))**2.
end do

e_new = eline_tot + e_p1 + e_p2

!Applying the Metropolis criterion
dener = ( e_new - e_old )

if (dener > 0.) then

  r=alea(seed)

  if (r > exp(-beta*dener)) then
    s(ran_spin) = s_ran
    eline_tot = eline_tot_old
    iacc = 0
  end if

end if

end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! AVERAGES :: locates the lattice whose average spins we want to measure
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine averages(t_init,nlat,av)
implicit none
integer, intent(in) :: t_init, nlat
integer :: i, j, k, t, save_t
integer, dimension(nlat*nlat), intent(out) :: av

av = 0
t = t_init
k = 1
av(k) = t

!Getting lattice points on the top-right quadrant
do i = 1, nlat/2-1 
  k = k + 1
  av(k) = neigh(t,2)
  t = av(k)
end do

t = t_init

do i = 1, nlat/2 !sites to the top
  k = k + 1
  av(k) = neigh(t,3)
  t = av(k)
  save_t = t
  do j = 1, nlat/2-1  !sites to the right
    k = k + 1
    av(k) = neigh(t,2)
    t = av(k)
  end do
  t = save_t
end do 

!Getting lattice points on the top-left quadrant
t = t_init
do i = 1, nlat/2
  k = k + 1
  av(k) = neigh(t,4)
  t = av(k)
end do

t = t_init

do i = 1, nlat/2 !sites to the top
  t = neigh(t,3)
  save_t = t
  do j = 1, nlat/2 !sites to the left
    k = k + 1
    av(k) = neigh(t,4)
    t = av(k)
  end do
  t = save_t
end do 

!Getting lattice points on the bottom-right quadrant
t = t_init

do i = 1, nlat/2-1 !sites to the bottom
  k = k + 1
  av(k) = neigh(t,1)
  t = av(k)
  save_t = t
  do j = 1, nlat/2-1 !sites to the right
    k = k + 1
    av(k) = neigh(t,2)
    t = av(k)
  end do
  t = save_t
end do 

!Getting lattice points on the bottom-left quadrant
t = t_init

do i = 1, nlat/2-1 !sites to the bottom
  t = neigh(t,1)
  save_t = t
  do j = 1, nlat/2 !sites to the left
    k = k + 1
    av(k) = neigh(t,4)
    t = av(k)
  end do
  t = save_t
end do 
do i = 1, 36
write(36,*) av(i)
end do
end subroutine
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

end module
