module common_var

! Module with variables shared along the program

implicit none
integer :: seed
real(8), allocatable, dimension(:) :: sblock1, sblock2
real(8) :: inter_par, beta, lambda, ext_field
integer, allocatable, dimension(:) :: sorted
integer, dimension(50) :: fixed1, fixed2
integer, allocatable, dimension(:,:) :: neigh
real(8), allocatable, dimension(:) :: s, s2
real, dimension(50) :: sfixed1, sfixed2


!inter_par :: J interaction in the Ising model
!beta :: inverse temperature
!s :: list with the spin values of each tile
!sorted :: list with tiles sorted according to their spin values. Tiles with 
!          spin=1 appear first.
!neigh :: matrix with the neighbouring tiles of each tile
!seed :: random number 
!lambda :: parameter for the reversible path in thermodynamic integration
!sblock1 :: matrix with the target spin value of patch 1
!sblock2 :: matrix with the target spin value of patch 2
!fixed1 :: tiles forming patch 1 + tiles of the neighbouring solvent
!fixed2 :: tiles forming patch 2 + tiles of the neighbouring solvent

end module
