program ising

use common_var
use routines

implicit none
integer :: nline, ncolumn, nsites, n1, nfixed, dsize, nblock, pattern
integer :: nsteps, neq, ncycle, nav, istep_eq, ntot, frec, init, ithermo
integer :: s_init, idist
integer :: i, j, k, ierror, iwrite, npatch, iacc, nlattice
real :: frac
real(8) :: ener, acc, eline_tot, sumtot
real, allocatable, dimension(:,:) :: pos
real(8), allocatable, dimension(:) :: sum1, sum2
integer, allocatable, dimension(:) :: av1, av2
real(8), allocatable, dimension(:) :: sum_av1, sum_av2

!dsize :: number of tiles of the fixed disk
!init :: determines how to get the initial configuration
!        0 -> reads a configuration from spins.txt
!        1 -> creates a new configuration 
!        2 -> reads a configuration from spins_cpt.txt
!pattern :: dermines if the protein is not homogeneous
!           0 -> homogeneous, all spins are the same
!           1 -> not homogeneous, reads patterns from files spin1.dat and 
!                spin2.dat

open(unit=212,file='instant_ener.xyz',action='write')
open(unit=213,file='ener_ti.dat',action='write')
open(unit=125,file='spins.txt',action='read')
open(unit=10,file='ising.inp',status='old',action='read')
open(unit=11,file='interactions.inp',status='old',action='read')
open(unit=214,file='av_spins.dat',action='write')
open(unit=215,file='av_spins_surroundings.dat',action='write')


read(10,*) nline, ncolumn, ncycle
read(10,*) beta, inter_par, frac, init, ithermo, seed
read(10,*) neq, nsteps, frec, iwrite
read(11,*) npatch, dsize, s_init, idist
read(11,*) 
read(11,*) 
read(11,*) 
read(11,*) nlattice
close(10)
close(11)

if (ithermo == 1 .and. npatch == 0) then
  ithermo = 0
  write(*,*) 'WARNING: no patches in the system, setting ithermo=0'
end if

beta = 1. / beta
nsites = nline * ncolumn
istep_eq = 0
ntot = 0
nav = 0
acc = 0
sumtot = 0 !sum for averages of spins 
eline_tot = 0 !total energy of teh system due to line tension
allocate(neigh(nsites,4), s(nsites), sorted(nsites), s2(nsites))
allocate(pos(nsites,2))
call disks(nline,ncolumn,dsize,nfixed,npatch,0)
allocate(sblock1(nfixed), sblock2(nfixed), sum1(nfixed), sum2(nfixed))
allocate(av1(nlattice*nlattice), av2(nlattice*nlattice))
allocate(sum_av1(nlattice*nlattice), sum_av2(nlattice*nlattice))
sum_av1 = 0. !sum for averages in the surroundings of protein 1
sum_av2 = 0.  !sum for averages in the surroundings of protein 2
sum1 = 0.  !sum for averages of spin values in protein 1
sum2 = 0.  !sum for averages of spin values in protein 

open(unit=11,file='interactions.inp',status='old',action='read')
read(11,*) 
read(11,*) sblock1(1), sblock2(1)
read(11,*) lambda, ext_field
read(11,*) pattern
close(11)

if ( iwrite == 1 ) then 
  open(unit=64,file='raw_spins.dat',form='unformatted',status='unknown')
  write(64) int(nsteps/frec), nsites
end if

call neighbours(pos,nline,ncolumn,nsites)
!call dist(nsites,nline,ncolumn,pos)
call averages(s_init,nlattice,av1)
s_init = s_init + idist
call averages(s_init,nlattice,av2)

!getting the initial configuration 
if (init == 1) then
  call init_spin(nsites,frac)
else if (init == 2) then
  open(unit=17,file='spins_cpt.txt',status='old',action='read')
  do i = 1, nsites
    read(17,*) s(i)
  end do
  close(17)
else if (init == 0) then
  do i = 1, nsites
    read(125,*) s(i)
  end do
else
  write(*,*) 'error when getting initial configuration'
end if

close(125)
open(unit=125,file='spins.txt',action='write')

call sort(nsites,n1)

!Creating disks
if (init == 1) then 
  call disks(nline,ncolumn,dsize,nfixed,npatch,1)
else
  call disks(nline,ncolumn,dsize,nfixed,npatch,0)
end if

if (ithermo==1) then

  if (init /= 1) then
    call switch_patch(nfixed,nsites,0,pattern,npatch)
  else 
    call switch_patch(nfixed,nsites,1,pattern,npatch)
  end if

else
 
  if (init /= 1) then
    open(unit=726,file='fixed1.dat',status='old',action='read')
    open(unit=727,file='fixed2.dat',status='old',action='read')
    do i = 1, nfixed
      read(726,*) fixed1(i)
      read(727,*) fixed2(i)
    end do
    close(726)
    close(727)
  end if

end if

s2 = s

if (npatch == 1) then
  do i = 1, nfixed
    s2(fixed1(i)) = sblock1(i)
  end do
  if ( init /= 1) then
    call energy_ti(nfixed,ener,npatch)
    write(213,*) ntot, ener
  end if
else if (npatch == 2) then
  do i = 1, nfixed
    s2(fixed1(i)) = sblock1(i)
    s2(fixed2(i)) = sblock2(i)
  end do
  if ( init /= 1) then
  call energy_ti(nfixed,ener,npatch)
  write(213,*) ntot, ener
  end if
end if

if ( init /= 1) then
  call energy_thermo(nsites,ener)
  write(212,*) ntot, ener
end if

do i = 1, nsites
  eline_tot = eline_tot + elinetension_thermo(i,nsites,s)
end do
eline_tot = eline_tot / 2.

10 do i = 1, ncycle

if (npatch == 2) then
  call mc_flip_thermo_2(eline_tot,nsites,nfixed,iacc)
elseif (npatch == 0) then
  call mc_flip_thermo_0(eline_tot,nsites,nfixed,iacc)
elseif (npatch == 1) then
  call mc_flip_thermo_1(eline_tot,nsites,nfixed,iacc)
elseif (npatch == 3) then
  call mc_flip_thermo_1fixed(eline_tot,nsites,nfixed,iacc)
end if

acc = acc + real(iacc)/ncycle

end do
!call wolff(nsites,stack,block1,block2,dsize,iacc)

if (istep_eq < neq) then
  
  istep_eq = istep_eq + 1
  go to 10

end if

if ( mod(ntot,frec) == 0 ) then
!    call energy(nsites,s,,ener)
!    call correlation(n,.false.,.false.)
    call energy_thermo(nsites,ener)
    write(212,*) ntot+1, ener

    if ( npatch /= 0 ) then
      call energy_ti(nfixed,ener,npatch)
      write(213,*) ntot+1, ener
    end if

    open(unit=17,file='spins_cpt.txt',status='replace',action='write')
    do j = 1, nsites
      write(17,*) s(j)
    end do
    close(17)

    call switch_patch(nfixed,nsites,2,pattern,npatch)  

    if (iwrite == 1) then
      do i = 1, nsites
        write(64) s(i)
      end do
    end if

    do i=1,nfixed
      if (npatch /= 0) sum1(i)=sum1(i)+s(fixed1(i))
      if (npatch == 2 .or. npatch == 3) sum2(i)=sum2(i)+s(fixed2(i))
    end do
    do j = 1, nsites
      sumtot=sumtot+s(j)/real(nsites)
    end do
    do i = 1, nlattice*nlattice
!      sum_av1(i) = sum_av1(i) + s(av1(i))
!      sum_av2(i) = sum_av2(i) + s(av2(i))
      sum_av1(i) = sum_av1(i) + s(i)
      sum_av2(i) = sum_av2(i) + s(i)
    end do

    nav = nav + 1

end if

ntot = ntot + 1
if (ntot < nsteps) go to 10

do j = 1, nsites
  write(125,*) s(j)
end do

do i = 1, nfixed
  write(214,*) sum1(i)/nav, sum2(i)/nav
end do
write(214,*) sumtot/nav, acc/(neq+ntot)

!writing the spin averages of lattice points surrounding protein 1 and protein 2
write(*,*) nlattice*nlattice
do i = 1, nlattice*nlattice
  write(215,*) sum_av1(i)/nav, sum_av2(i)/nav
end do


deallocate(neigh, s, s2, av1, av2, sum_av1, sum_av2)
close(214)
close(215)
end program
