import numpy as np


ex = np.genfromtxt('cu2o_230807.ex', delimiter=' ')
mat_el = np.genfromtxt('cu2o_230807.mat', delimiter = ' ')

nps = ex[ex[:,1]==1]


results = []
for row in nps:
    n = row[0]
    mask = ((mat_el[:,0]==n)&(mat_el[:,1]==1))|((mat_el[:,2]==n)&(mat_el[:,3]==1))
    dipole = max(abs(mat_el[mask,4]))
    print(dipole)
    largest_nl = mat_el[abs(mat_el[:,4])==dipole][0][:2]
    print(largest_nl)

    energy_gap = abs(ex[(ex[:,0]==largest_nl[0])&(ex[:,1]==largest_nl[1])][0][2] - row[2])
    width = 2*row[3]

    strong_driving = width/dipole *1e6
    usd = max(strong_driving, energy_gap/dipole * 1e6)

    results.append([n,largest_nl[0],largest_nl[1],row[2],strong_driving,usd])

for line in results:
    print(line)

np.savetxt('sd_and_usd_thresholds.txt', np.array(results))
