import sys
import numpy as np
from matplotlib import pyplot as plt


cns_in = sys.argv[1:]
peak = cns_in[0].split('/')[-1].split('_')[0]
em = []
data_cns = []
for a in sorted(cns_in, key = lambda x: float(x.split('/')[-1].split('_')[3].removesuffix('.cns'))):
    em += [float(a.split('/')[-1].split('_')[3].removesuffix('.cns'))]
    data_cns += [np.genfromtxt(a, delimiter=' ', dtype=float)]


data = data_cns[0]
for c in [x.T[1].T for x in data_cns[1:]]:
    data = np.c_[data, c]


all_n = data.T[0]
n = abs(all_n[int(len(all_n)/2):])[::-1]
checklist = [1]*len(n)
with open(peak + '_1_sigma.photons', 'w+') as f:
    f.write('0.0, 0.0\n')
    for i,c in enumerate(data.T[1:]):
        for j in n:
            if sum(c[abs(all_n)<=j]) < 0.68*sum(c) and checklist[int(j)]:
                f.write(str(j+1) + ', ' + str(em[i]) + str('\n'))
                f.write(str(-j-1) + ', ' + str(em[i]) + str('\n'))
                checklist[int(j)]=0

checklist = [1]*len(n)
with open(peak + '_2_sigma.photons', 'w+') as f:
    f.write('0.0, 0.0\n')
    for i,c in enumerate(data.T[1:]):
        for j in n:
            if sum(c[abs(all_n)<=j]) < 0.95*sum(c) and checklist[int(j)]:
                f.write(str(j+1) + ', ' + str(em[i]) + str('\n'))
                f.write(str(-j-1) + ', ' + str(em[i]) + str('\n'))
                checklist[int(j)]=0



