from matplotlib import pyplot as plt
import numpy as np
import sys
from scipy.interpolate import interp1d

plt.rcParams['font.family'] = 'Latin Modern Roman'
files = sys.argv[1:]

col = ['green','orange','blue']
shapes = ['o','*','x']

for i,f in enumerate(files):
    data = np.genfromtxt(f, delimiter=',').T[::-1]
    
    upperx = data[0,data[1]>=0]
    uppery = data[1,data[1]>=0]
    lowerx = data[0,data[1]<=0]
    lowery = data[1,data[1]<=0]

    data = data[:,data[0]<=min(max(upperx),max(lowerx))]
    
    upper = interp1d(upperx, uppery)
    lower = interp1d(lowerx, lowery)

    #plt.scatter(data[0], data[1], marker=shapes[i], color=col[i])
    plt.fill_between(data[0], lower(data[0]), upper(data[0]), alpha = 0.7, color=col[i])
    #plt.fill_between(np.r_[data[0],[720]], lower(np.r_[data[0],[720]]), upper(np.r_[data[0], [720]]), alpha = 0.8, color=col[i])

    
plt.text(340, 0, '68%', c='black', fontsize=18)
plt.text(450, 4, '95%', c='black', fontsize=18)

plt.xlabel('Microwave field strength, V/m', fontsize=18)
plt.ylabel('Floquet N', fontsize=18)
plt.xlim([0,680])
plt.yticks(np.linspace(10,-10,11), fontsize=18)
plt.xticks(fontsize=18)
#plt.title('12p')
plt.tight_layout()
plt.savefig(sys.argv[1].split('.')[0] + '.pdf')
