from matplotlib import pyplot as plt
import numpy as np
import sys

plt.rcParams['font.family'] = 'Latin Modern Roman'
plt.rc('font', size=18)
once = True
scale = 688/309
fig,ax1 = plt.subplots()
ax2 = ax1.twinx()
for i,f in enumerate(sorted(sys.argv[1:], key = lambda x: float(x.split('_')[0]))[:]):
    if f.split('_')[0] in ['20', '78', '120', '183', '239', '309']:

        data = np.genfromtxt(f, delimiter=',', comments='[', skip_header=True)
        Em = float(f.split('_')[0])

        if not once:
            x = data.T[0][(data.T[0]>2.169)&(data.T[0]<2.1718)]
            y = data.T[2][(data.T[0]>2.169)&(data.T[0]<2.1718)]
            ax2.plot([x[0],x[-1]], [0,0], c='black', lw=1)
            #plt.scatter(x, y*30+Em, color='black',s=0.1)
            print('yes')
            ax2.plot(x, y*100, color='black', lw=1)
            ax2.fill_between(x, y*100, [0]*len(x), alpha=0.5, zorder=40)
            once = True

        #_,p,Em,_,mf,_ = f.split('_')
        #p = float(p)
        #Em = float(Em)
        #mf = float(mf)

        x = data.T[0][(data.T[0]>2.169)&(data.T[0]<2.1718)]
        y = data.T[1][(data.T[0]>2.169)&(data.T[0]<2.1718)]

        ax2.plot([x[0],x[-1]], [Em*scale,Em*scale], c='black', lw=1)
        #plt.scatter(x, y*30+Em, color='black',s=0.1)
        ax2.plot(x, y*100+Em*scale, color='black', lw=1)
        ax2.fill_between(x, y*100+Em*scale, [Em*scale]*len(x), alpha=0.5, zorder=30-i)



ex = np.genfromtxt('cu2o_new.ex', delimiter=' ')
nPs = ex.T[2][ex.T[1]==1]
offset=-1e-5
for i in range(len(nPs)):
    nP = nPs[i]
    if 2.169 < nP < 2.1718 and i + 6 < 16:
        ax2.plot([nP+offset, nP+offset], [0, 900], color = "k", lw = 1, linestyle = 'dashed', alpha = 0.5)
        if i + 6 < 11:
            ax2.text(nP-5e-5+offset, 940, str(i+6) + "P", fontsize=18)



ax2.set_ylabel('$\mathcal{E}_\\text{M}$, Vm$^{-1}$')
ax1.set_xlabel('Probe laser energy, eV')
#plt.title(f'Waterfall Plot, 7Ghz, Experiment')
plt.margins(x=0)
ax2.set_ylim([0,1000])
#plt.xticks(np.linspace(2.1705,2.1717,4),fontsize=12)
ax1.set_ylim([0,1000/100])
ax1.set_ylabel('Optical Depth')
ax2.set_xticks([2.1690, 2.1695, 2.1700, 2.1705, 2.1710, 2.1715])

ax2.text(2.1691, 920, '(a)')

plt.savefig(f'waterfall_7ghz_exp_final_rast.pdf', bbox_inches='tight')
