import numpy as np
from matplotlib import pyplot as plt
from scipy.interpolate import interp1d
import sys
plt.rcParams['font.family'] = 'Latin Modern Roman'


exp_data = np.loadtxt(sys.argv[1])

wp = 2.171267016
peak = '11p-delta'
data = []
p = []

temp = np.genfromtxt(sys.argv[2], delimiter=' ')
for r in temp:
        if abs(r[0] - wp) == min(np.absolute(temp.T[0] - wp)):
            off = r[1]

for f in sorted(sys.argv[3:], key = lambda x: float(x.split('_')[1])):
    p += [float(f.split('_')[1])]
    em = float(f.split('_')[2])
    temp = np.genfromtxt(f, delimiter=' ')
    for r in temp:
        if abs(r[0] - wp) == min(np.absolute(temp.T[0] - wp)):
            data += [r[1]]


plt.plot(p,data-off, c='red')
plt.errorbar(exp_data[:,0], exp_data[:,1], yerr=exp_data[:,2], capsize=0, fmt='o', color='red')

plt.plot([0,180], [-0.56, -0.56], c='brown')

plt.xlabel('Polarisation Angle, degrees', fontsize=18)
plt.ylabel('$\\Delta \\alpha L$', fontsize=18)
plt.xlim([0,180])
plt.xticks(fontsize=18)
plt.yticks(fontsize=18)
plt.tight_layout()
#plt.legend(['Theory','Exp.'], loc='upper right', fontsize=18)
plt.savefig(f'{wp}_{em}_Vm_vs_pol_ang_vs_exp_test.pdf')
