import numpy as np
import sys
from matplotlib import pyplot as plt

plt.rcParams['font.family'] = 'Latin Modern Roman'
prop_cycle = plt.rcParams['axes.prop_cycle']
colors = prop_cycle.by_key()['color']
print(colors)

fig,ax = plt.subplots(figsize=(13,3))

exp = np.genfromtxt(sys.argv[1], delimiter=',', skip_header=1)
theoryon = np.genfromtxt(sys.argv[2], delimiter=' ',comments='[').T
theoryoff = np.genfromtxt(sys.argv[3], delimiter=' ',comments='[').T
diff = (theoryon[1] - theoryoff[1])

ex = np.genfromtxt('cu2o_230807.ex', delimiter=' ')
nPs = ex.T[2][ex.T[1]==1]


plt.errorbar(exp.T[0], exp.T[3], yerr=exp.T[6], fmt='.',elinewidth=1,capsize=0, c=colors[1],label='Experiment')
plt.plot(theoryon[0], diff, c=colors[1],label='Theory')

for i in range(len(nPs)):
    nP = nPs[i]
    if 2.169 < nP < 2.1718 and i + ex.T[0,1] < 16:
        if i + ex.T[0,1] < 7:
            plt.plot([nP, nP], [0.1, -0.1], color = "k", lw = 1, alpha=0.5, linestyle='dashed')
        else:
            plt.plot([nP, nP], [0.1, -0.3], color = "k", lw = 1, alpha=0.5, linestyle='dashed')
        if i + ex.T[0,1] < 11:
            plt.text(nP-5e-5, 0.11, str(i+int(ex.T[0,1])) + "P", fontsize=18)


plt.ylabel('$\\Delta\\alpha L$', fontsize = 18)
plt.xlabel('Probe Laser Energy, eV', fontsize = 18)
plt.ylim([-0.3,0.2])
plt.xlim(2.169,2.1718)
#plt.legend(loc='lower left', fontsize=16, frameon=False, markerscale=0.5)
plt.tight_layout(pad=2)
plt.text(2.1691,-0.2,'$\\mathcal{E}_\\text{m} = 173 \pm 1~$Vm$^{-1}$', fontsize=18)
plt.text(2.1691, 0.11,'(b)', fontsize=18)
plt.xticks(fontsize=18)
plt.yticks(fontsize=18)
s = sys.argv[2].split('/')[-1].split('_')[2]
plt.savefig(f'diff_vs_exp_{s}_Vm.pdf')
