from matplotlib import pyplot as plt
import numpy as np
import sys

plt.rcParams['font.family'] = 'Latin Modern Roman'
plt.rc('font', size=18)
offset = -1e-5

fig,ax1 = plt.subplots()
ax2 = ax1.twinx()
for i,f in enumerate(sorted(sys.argv[1:], key = lambda x: float(x.split('_')[2]))[:]):
    if f != 'off.spec' and f.split('_')[2] in ['40.00','160.00','280.00','400.00','520.00','688.00']:
        #_,p,Em,_,mf,_ = f.split('_')
        Em = f.split('_')[2]
        #p = float(p)
        Em = float(Em)
        print(Em)
        #mf = float(mf)
        data = np.genfromtxt(f, delimiter=' ')
        x = data.T[0]+offset
        y = data.T[1]#[(2.1704<x)&(x<2.1718)]
        #x = x[(2.1704<x)&(x<2.1718)]

        ax2.plot([x[0],x[-1]], [Em,Em], c='black', lw=1)
        #plt.scatter(x, y*30+Em, color='black',s=0.1)
        ax2.plot(x, y*100+Em, color='black', lw=1)
        ax2.fill_between(x, y*100+Em, [Em]*len(x), alpha=0.5, zorder=30-i)


ex = np.genfromtxt('cu2o_230807.ex', delimiter=' ')
nPs = ex.T[2][ex.T[1]==1]

for i in range(len(nPs)):
    nP = nPs[i]
    if 2.169 < nP < 2.1718 and i + ex.T[0,1] < 16:
        ax2.plot([nP+offset, nP+offset], [0, 900], color = "k", lw = 1, linestyle='dashed', alpha=0.5)
        if i + ex.T[0,1] < 11:
            ax2.text(nP-5e-5+offset, 940, str(i+int(ex.T[0,1])) + "P", fontsize=18)



ax2.set_ylabel('$\mathcal{E}_\\text{M}$, Vm$^{-1}$',fontsize=18)
ax1.set_xlabel('Probe Laser Energy, eV',fontsize=18)
#plt.title(f'Waterfall Plot, 7Ghz, Floquet Theory')
plt.margins(x=0)
ax2.set_ylim([0,1000])
#plt.xticks(np.linspace(2.1693,2.1717,4), fontsize=12)
ax1.set_ylim([0,1000/100])
ax1.set_ylabel('Optical Depth', fontsize=18)
ax2.set_xticks([2.1690, 2.1695, 2.1700, 2.1705, 2.1710, 2.1715])
#ax2.tick_params(axis='x', which='minor', labelsize=18)
plt.yticks(fontsize=18)

ax2.text(2.1691, 920, '(b)')

plt.savefig(f'waterfall_7ghz_floq_theory_no_sph.pdf', bbox_inches='tight')
