(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    201086,       3520]
NotebookOptionsPosition[    198219,       3478]
NotebookOutlinePosition[    198562,       3493]
CellTagsIndexPosition[    198519,       3490]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "measuredJccDIVJbb", ",", " ", "measuredJccDIVJbbErr", ",", " ", 
    "measuredJbcDIVJbb", ",", " ", "measuredJbcDIVJbbErr", ",", " ", 
    "sqrtMeasuredJccDIVJbb", ",", " ", "sqrtMeasuredJccDIVJbbErr", ",", " ", 
    "xc1", ",", " ", "xc2", ",", " ", "xc1alt", ",", " ", "xc2alt", ",", " ", 
    "xc1ExpHigh", ",", " ", "xc1ExpLow", ",", " ", "xc1ExpMean", ",", " ", 
    "xc1ExpErr", ",", " ", "xc2ExpHigh", ",", " ", "xc2ExpLow", ",", " ", 
    "xc2ExpMean", ",", " ", "xc2ExpErr", ",", " ", "fontSize", ",", " ", 
    "tmpgraph"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"measuredJccDIVJbb", " ", "=", " ", 
  RowBox[{"1.2807", "/", "6.21714"}]}], "\[IndentingNewLine]", 
 RowBox[{"measuredJccDIVJbbErr", " ", "=", " ", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.08925", "/", "1.2807"}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.08811", "/", "6.21714"}], ")"}], "^", "2"}]}], "]"}], "*", 
   "measuredJccDIVJbb"}]}], "\[IndentingNewLine]", 
 RowBox[{"measuredJbcDIVJbb", " ", "=", " ", 
  RowBox[{"4.26279", "/", "6.21714"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"measuredJbcDIVJbbErr", " ", "=", " ", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.32025", "/", "4.26279"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.08811", "/", "6.21714"}], ")"}], "^", "2"}]}], "]"}], "*", 
    "measuredJbcDIVJbb"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"sqrtMeasuredJccDIVJbb", " ", "=", " ", 
  RowBox[{"Sqrt", "[", "measuredJccDIVJbb", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sqrtMeasuredJccDIVJbbErr", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"measuredJccDIVJbbErr", "/", "measuredJccDIVJbb"}], ")"}], "/",
       "2"}], ")"}], "*", "sqrtMeasuredJccDIVJbb"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xc1", "[", 
    RowBox[{
     RowBox[{"JbcDIVJbb_:", "measuredJbcDIVJbb"}], 
     RowBox[{"(*", 
      RowBox[{"Sqrt", "[", "measuredJccDIVJbb", "]"}], "*)"}], ",", " ", 
     RowBox[{"JccDIVJbb_:", "measuredJccDIVJbb"}]}], " ", 
    RowBox[{"(*", " ", "Known", " ", "*)"}], "]"}], " ", ":=", " ", 
   RowBox[{"x", "/.", " ", 
    RowBox[{"First", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"JbcDIVJbb", "*", "2", "*", "x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}]}], "\[Equal]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "x"}], ")"}], "^", "2"}]}], ",", " ", 
         RowBox[{"0", "<", "x", "<", "1"}]}], "}"}], ",", " ", "x"}], "]"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xc2", "[", 
     RowBox[{
      RowBox[{"JbcDIVJbb_:", "measuredJbcDIVJbb"}], 
      RowBox[{"(*", 
       RowBox[{"Sqrt", "[", "measuredJccDIVJbb", "]"}], "*)"}], ",", " ", 
      RowBox[{"JccDIVJbb_:", "measuredJccDIVJbb"}]}], " ", 
     RowBox[{"(*", " ", "Known", " ", "*)"}], "]"}], " ", ":=", " ", 
    RowBox[{"x", "/.", " ", 
     RowBox[{"First", "[", 
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"JbcDIVJbb", "*", "2", "*", "x", "*", 
            RowBox[{"(", 
             RowBox[{"1", "-", "x"}], ")"}]}], "\[Equal]", 
           RowBox[{"JccDIVJbb", "*", 
            RowBox[{"x", "^", "2"}]}]}], ",", " ", 
          RowBox[{"0", "<", "x", "<", "1"}]}], "}"}], ",", " ", "x"}], "]"}], 
      "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xc1alt", "[", 
     RowBox[{
      RowBox[{"JbcDIVJbb_:", 
       RowBox[{"measuredJbcDIVJbb", "?", "NumericQ"}]}], 
      RowBox[{"(*", 
       RowBox[{"Sqrt", "[", "measuredJccDIVJbb", "]"}], "*)"}], ",", " ", 
      RowBox[{"JccDIVJbb_:", "measuredJccDIVJbb"}]}], " ", 
     RowBox[{"(*", " ", "Known", " ", "*)"}], "]"}], " ", ":=", " ", 
    RowBox[{"x", "/.", " ", 
     RowBox[{"First", "[", 
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "x"}], ")"}], "^", "2"}], "\[Equal]", 
           RowBox[{
            RowBox[{"JbcDIVJbb", "*", "2", "*", "x", "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", "x"}], ")"}]}], "+", 
            RowBox[{"JccDIVJbb", "*", 
             RowBox[{"x", "^", "2"}]}]}]}], ",", " ", 
          RowBox[{"0", "<", "x", "<", "1"}]}], "}"}], ",", " ", "x"}], "]"}], 
      "]"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Better", "!"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xc2alt", "[", 
     RowBox[{
      RowBox[{"JbcDIVJbb_:", 
       RowBox[{"measuredJbcDIVJbb", "?", "NumericQ"}]}], 
      RowBox[{"(*", 
       RowBox[{"Sqrt", "[", "measuredJccDIVJbb", "]"}], "*)"}], ",", " ", 
      RowBox[{"JccDIVJbb_:", "measuredJccDIVJbb"}]}], " ", 
     RowBox[{"(*", " ", "Known", " ", "*)"}], "]"}], " ", ":=", " ", 
    RowBox[{"x", "/.", " ", 
     RowBox[{"First", "[", 
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"JccDIVJbb", "*", 
            RowBox[{"x", "^", "2"}]}], "\[Equal]", 
           RowBox[{
            RowBox[{"JbcDIVJbb", "*", "2", "*", "x", "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", "x"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "x"}], ")"}], "^", "2"}]}]}], ",", " ", 
          RowBox[{"0", "<", "x", "<", "1"}]}], "}"}], ",", " ", "x"}], "]"}], 
      "]"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Better", "!"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xc1alt", "[", "#", "]"}], ",", " ", 
      RowBox[{"xc2alt", "[", "#", "]"}]}], "}"}], "&"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"measuredJbcDIVJbb", ",", " ", 
     RowBox[{"4.0", "/", "6.29"}], ",", " ", 
     RowBox[{"Sqrt", "[", "measuredJccDIVJbb", "]"}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"xc1alt", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"measuredJbcDIVJbb", ",", " ", "measuredJccDIVJbb"}], "}"}], 
        "+", "#"}], ")"}]}], ")"}], "&"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"measuredJbcDIVJbbErr", ",", " ", "measuredJccDIVJbbErr"}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "measuredJbcDIVJbbErr"}], ",", " ", 
       RowBox[{"-", "measuredJccDIVJbbErr"}]}], "}"}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"xc1alt", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"measuredJbcDIVJbb", ",", " ", "measuredJccDIVJbb"}], "}"}], 
        "+", "#"}], ")"}]}], ")"}], "&"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"measuredJbcDIVJbbErr", ",", " ", 
       RowBox[{"-", "measuredJccDIVJbbErr"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "measuredJbcDIVJbbErr"}], ",", " ", 
       "measuredJccDIVJbbErr"}], "}"}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"xc2alt", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"measuredJbcDIVJbb", ",", " ", "measuredJccDIVJbb"}], "}"}], 
        "+", "#"}], ")"}]}], ")"}], "&"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"measuredJbcDIVJbbErr", ",", " ", "measuredJccDIVJbbErr"}], 
      "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "measuredJbcDIVJbbErr"}], ",", " ", 
       RowBox[{"-", "measuredJccDIVJbbErr"}]}], "}"}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"xc2alt", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"measuredJbcDIVJbb", ",", " ", "measuredJccDIVJbb"}], "}"}],
          "+", "#"}], ")"}]}], ")"}], "&"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"measuredJbcDIVJbbErr", ",", " ", 
        RowBox[{"-", "measuredJccDIVJbbErr"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "measuredJbcDIVJbbErr"}], ",", " ", 
        "measuredJccDIVJbbErr"}], "}"}]}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"xc1ExpHigh", " ", "=", " ", "0.41"}], "\[IndentingNewLine]", 
 RowBox[{"xc1ExpLow", " ", "=", " ", "0.23"}], "\[IndentingNewLine]", 
 RowBox[{"xc2ExpHigh", " ", "=", " ", "0.89"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xc2ExpLow", " ", "=", " ", "0.77"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"xc1ExpMean", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"xc1ExpHigh", "+", "xc1ExpLow"}], ")"}], "/", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{"xc1ExpErr", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"xc1ExpHigh", "-", "xc1ExpLow"}], ")"}], "/", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{"xc2ExpMean", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"xc2ExpHigh", "+", "xc2ExpLow"}], ")"}], "/", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xc2ExpErr", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"xc2ExpHigh", "-", "xc2ExpLow"}], ")"}], "/", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fontSize", " ", "=", " ", "17"}], 
  RowBox[{"(*", "16", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmpgraph", " ", "=", " ", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#3", ",", " ", 
          RowBox[{"Opacity", "[", "0.2", "]"}], ",", " ", 
          RowBox[{"Thickness", "[", "Medium", "]"}], 
          RowBox[{"(*", "Thick", "*)"}], ",", " ", "Dashed", ",", " ", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", " ", "#1"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "#1"}], "}"}]}], "}"}], "]"}], ",", " ", 
          RowBox[{"Opacity", "[", "0.2", "]"}], ",", " ", 
          RowBox[{"Rectangle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", " ", 
              RowBox[{"#1", "-", "#2"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"1", ",", " ", 
              RowBox[{"#1", "+", "#2"}]}], "}"}]}], "]"}], ",", " ", 
          RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Experiment\>\"", ",", " ", "Bold", ",", " ", "fontSize"}], 
             "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"0.03", ",", " ", "#1"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], "&"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"xc1ExpMean", ",", " ", "xc2ExpMean"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"xc1ExpErr", ",", " ", "xc2ExpErr"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", "Red"}], "}"}]}], "}"}]}], "]"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xc2alt", "[", "JbcDIVJbb", "]"}], ",", " ", 
        RowBox[{"xc1alt", "[", "JbcDIVJbb", "]"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"JbcDIVJbb", ",", " ", "0", ",", " ", "1"}], "}"}], 
      RowBox[{"(*", 
       RowBox[{",", " ", 
        RowBox[{"GridLines", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"None", ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.41", ",", " ", 
               RowBox[{"Directive", "[", 
                RowBox[{"Blue", ",", " ", 
                 RowBox[{"Thickness", "[", "0.1", "]"}], ",", " ", 
                 RowBox[{"Opacity", "[", "0.2", "]"}]}], "]"}]}], "}"}], ",", 
             " ", 
             RowBox[{"{", 
              RowBox[{"0.83", ",", " ", 
               RowBox[{"Directive", "[", 
                RowBox[{"Orange", ",", " ", "Dashed"}], "]"}]}], "}"}]}], 
            "}"}]}], "}"}]}]}], "*)"}], ",", " ", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{"#", ",", " ", "Thick"}], "]"}], "&"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Red", ",", " ", "Black"}], "}"}]}], "]"}]}], ",", " ", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<Upper critical level \
\!\(\*SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"c2\",FontSlant->\"Plain\"]]\)\>\"", 
           RowBox[{
           "(*", "\"\<Upper \
(\!\(\*SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"c2\",FontSlant->\"Plain\"]]\))\>\"", "*)"}], ",", " ", 
           "\"\<Lower critical level \
\!\(\*SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"c1\",FontSlant->\"Plain\"]]\)\>\""}], 
          RowBox[{
          "(*", "\"\<Lower \
(\!\(\*SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"c1\",FontSlant->\"Plain\"]]\))\>\"", "*)"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"Left", ",", " ", "Bottom"}], "}"}]}], "]"}]}], ",", " ", 
      RowBox[{"LabelStyle", "\[Rule]", "fontSize"}], ",", " ", 
      RowBox[{"FrameStyle", "\[Rule]", "fontSize"}]}], "]"}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Darker", "@", "Green"}], ",", " ", 
         RowBox[{"Opacity", "[", "0.7", "]"}], 
         RowBox[{"(*", 
          RowBox[{",", " ", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#1", ",", " ", 
               RowBox[{"-", "0.008"}]}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"#2", ",", " ", "0.008"}], "}"}]}], "]"}], ",", " ", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#1", ",", " ", 
               RowBox[{"1", "-", "0.006"}]}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"#2", ",", " ", 
               RowBox[{"1", "+", "0.006"}]}], "}"}]}], "]"}]}], "*)"}], ",", 
         " ", 
         RowBox[{"Thickness", "[", "Medium", "]"}], ",", " ", "Dashed", ",", 
         " ", 
         RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"#1", ",", " ", "0"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"#1", ",", " ", "1"}], "}"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"#2", ",", " ", "0"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"#2", ",", " ", "1"}], "}"}]}], "}"}]}], "}"}], "]"}], 
         ",", " ", 
         RowBox[{"Opacity", "[", "0.8", 
          RowBox[{"(*", "0.7", "*)"}], "]"}], ",", " ", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#1", ",", " ", 
             RowBox[{"xc1alt", "[", "#1", "]"}]}], "}"}], ",", " ", "0.009"}],
           "]"}], 
         RowBox[{"(*", 
          RowBox[{",", " ", 
           RowBox[{"Disk", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#2", ",", " ", 
               RowBox[{"xc1alt", "[", "#2", "]"}]}], "}"}], ",", " ", 
             "0.009"}], "]"}]}], "*)"}], ",", " ", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#2", ",", " ", 
             RowBox[{"xc2alt", "[", "#2", "]"}]}], "}"}], ",", " ", "0.009"}],
           "]"}], ",", " ", 
         RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"#2", ",", " ", "Bold", ",", " ", "fontSize"}], "]"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{"#1", ",", " ", "0.63"}], 
               RowBox[{"(*", "0.015", "*)"}], 
               RowBox[{"(*", "0.030", "*)"}], 
               RowBox[{"(*", "0.04", "*)"}], 
               RowBox[{"(*", "0.03", "*)"}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0", 
                RowBox[{"(*", 
                 RowBox[{"-", "1"}], "*)"}], ",", " ", "#3"}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0", ",", " ", "1"}], "}"}]}], "]"}], "&"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#1", ",", " ", "#2"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"(*", "\"\<Lower bound\>\"", "*)"}], 
              RowBox[{"\"\<Lower exp. bound\>\"", ",", " ", 
               RowBox[{"(*", "\"\<Upper bound\>\"", "*)"}], 
               "\"\<Upper exp. bound\>\""}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "}"}]}], "]"}], 
         ",", " ", "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Allowed\>\"", 
             RowBox[{"(*", "\"\<Exp.\>\"", "*)"}], 
             RowBox[{"(*", "\"\<Allowed\\nby exp.\>\"", "*)"}], 
             RowBox[{"(*", "\"\<Allowed\\nby exp.\>\"", "*)"}], ",", " ", 
             "Bold", ",", " ", "fontSize"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"#1", "+", "#2"}], ")"}], "/", "2"}], ",", " ", 
             "1.0055"}], 
            RowBox[{"(*", "1", "*)"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"0", ",", " ", 
             RowBox[{"-", "1"}]}], "}"}]}], 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"#1", "+", "#2"}], ")"}], "/", "2"}], ",", " ", 
              RowBox[{"-", "0.01"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"0", ",", " ", "1"}], "}"}]}], "*)"}], 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"#1", "+", "#2"}], ")"}], "/", "2"}], ",", " ", 
              "0.01"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"0", ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], "*)"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.2", "]"}], ",", " ", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#1", ",", " ", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"#2", ",", " ", "1"}], "}"}]}], "]"}]}], "}"}]}], " ", 
        RowBox[{"(*", "*)"}], "\[IndentingNewLine]", "}"}], "]"}], "&"}], "[", 
     RowBox[{"0.647", 
      RowBox[{"(*", "0.431", "*)"}], 
      RowBox[{"(*", "0.489", "*)"}], ",", " ", "0.779"}], 
     RowBox[{"(*", "0.816", "*)"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"MapThread", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"#4", ",", " ", 
          RowBox[{"Thickness", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"#3", 
            RowBox[{"(*", 
             RowBox[{",", " ", "Thick"}], "*)"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"#1", ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"#1", ",", " ", "1"}], "}"}]}], "}"}], "]"}], ",", 
            " ", 
            RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
            RowBox[{"Disk", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"#1", ",", " ", 
                RowBox[{"xc1alt", "[", "#1", "]"}]}], "}"}], ",", " ", 
              "0.009"}], "]"}], ",", " ", 
            RowBox[{"Disk", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"#1", ",", " ", 
                RowBox[{"xc2alt", "[", "#1", "]"}]}], "}"}], ",", " ", 
              "0.009"}], "]"}], ",", " ", 
            RowBox[{"If", "[", 
             RowBox[{"#5", ",", " ", 
              RowBox[{"{", 
               RowBox[{"Dashed", ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"xc1alt", "[", "#1", "]"}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"xc1alt", "[", "#1", "]"}]}], "}"}]}], "}"}], 
                 "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"xc2alt", "[", "#1", "]"}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"xc2alt", "[", "#1", "]"}]}], "}"}]}], "}"}], 
                 "]"}]}], "}"}], ",", " ", "Nothing"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Thick", ",", " ", "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "-", "#2"}], ",", " ", 
                    RowBox[{"-", "#2"}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "+", "#2"}], ",", " ", "#2"}], "}"}]}], 
                  "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "-", "#2"}], ",", " ", "#2"}], "}"}], ",", 
                   " ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "+", "#2"}], ",", " ", 
                    RowBox[{"-", "#2"}]}], "}"}]}], "}"}]}], "}"}], "]"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "-", "#2"}], ",", " ", 
                    RowBox[{"1", "-", "#2"}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "+", "#2"}], ",", " ", 
                    RowBox[{"1", "+", "#2"}]}], "}"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "-", "#2"}], ",", " ", 
                    RowBox[{"1", "+", "#2"}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "+", "#2"}], ",", " ", 
                    RowBox[{"1", "-", "#2"}]}], "}"}]}], "}"}]}], "}"}], 
               "]"}]}], "\[IndentingNewLine]", "}"}], "&"}], "[", 
           RowBox[{"#1", ",", " ", "0.010"}], 
           RowBox[{"(*", "0.011", "*)"}], "]"}], 
          RowBox[{"(*", 
           RowBox[{"Annulus", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#", ",", " ", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0.005", ",", " ", "0.009"}], "}"}]}], "]"}], "*)"}], 
          ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"#2", ",", " ", "fontSize"}], "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#1", "+", "0.005"}], ",", "  ", "0.63"}], 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"xc1alt", "[", "#1", "]"}], "+", 
                 RowBox[{"xc2alt", "[", "#1", "]"}]}], ")"}], "/", "2"}], 
              "*)"}], 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"xc1ExpMean", "+", "xc2ExpMean"}], ")"}], "/", "2"}], 
              "*)"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"0", ",", " ", "1"}], "}"}], 
            RowBox[{"(*", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", " ", "0"}], "}"}], "*)"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"0", ",", " ", "1"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Opacity", "[", "0.2", "]"}], ",", " ", 
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "#6"}], ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "+", "#6"}], ",", " ", "1"}], "}"}]}], "]"}]}],
             "}"}], " ", 
           RowBox[{"(*", "*)"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "#6"}], ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "+", "#6"}], ",", " ", "0"}], "}"}]}], "}"}], 
             "]"}], ",", " ", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "+", "#6", "-", "0.025"}], ",", " ", "0"}], 
               "}"}], ",", " ", "0.025", ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "#"}], ",", " ", "#"}], "}"}], "&"}], "[", 
               RowBox[{"18", "Degree"}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "-", "#6", "+", "0.025"}], ",", " ", "0"}], 
               "}"}], ",", " ", "0.025", ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"Pi", "+", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "#"}], ",", " ", "#"}], "}"}]}], "&"}], "[", 
               RowBox[{"18", "Degree"}], "]"}]}], "]"}]}], 
           RowBox[{"(*", 
            RowBox[{",", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#1", "-", "#6"}], ",", " ", "1"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#1", "+", "#6"}], ",", " ", "1"}], "}"}]}], "}"}], 
              "]"}], ",", " ", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "+", "#6", "-", "0.025"}], ",", " ", "1"}], 
                "}"}], ",", " ", "0.025", ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "#"}], ",", " ", "#"}], "}"}], "&"}], "[", 
                RowBox[{"18", "Degree"}], "]"}]}], "]"}], ",", " ", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "#6", "+", "0.025"}], ",", " ", "1"}], 
                "}"}], ",", " ", "0.025", ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Pi", "+", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "#"}], ",", " ", "#"}], "}"}]}], "&"}], "[", 
                RowBox[{"18", "Degree"}], "]"}]}], "]"}]}], "*)"}], 
           "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
        "]"}], "&"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"measuredJbcDIVJbb", ",", " ", "sqrtMeasuredJccDIVJbb"}], 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Fitted value\>\"", 
            RowBox[{
            "(*", "\"\<Fitted \
\!\(\*SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Cl\"}],FontSlant->\"Plain\"]]\)\!\(\*StyleBox[\"/\",FontSlant->\"Italic\"]\)\
\!\(\*StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\>\"", "*)"}], 
            RowBox[{
            "(*", "\"\<Fitted \
\!\(\*SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \"Cl\"}],FontSlant->\"Plain\"]]\)\>\"", 
             "*)"}], 
            RowBox[{"(*", "\"\<Exchange best fit\>\"", "*)"}], 
            RowBox[{"(*", "\"\<Best fit\>\"", "*)"}], 
            RowBox[{
            "(*", "\"\<Fit of \
\!\(\*StyleBox[\"J\",FontSlant->\"Italic\"]\)(\!\(\*StyleBox[\"x\",FontSlant->\
\"Italic\"]\))\>\"", "*)"}], ",", " ", "Bold"}], "]"}], ",", " ", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<\!\(\*SqrtBox[RowBox[{SubscriptBox[StyleBox[\"J\",FontSlant->\
\"Italic\"], StyleBox[RowBox[{\"Cl\", \"-\", \"Cl\"}],FontSlant->\"Plain\"]], \
StyleBox[\"/\",FontSlant->\"Italic\"], \
StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]}]]\)\>\"", ",", " ", 
            "Bold"}], "]"}]}], 
         RowBox[{
         "(*", "\"\<\!\(\*SqrtBox[RowBox[{SubscriptBox[StyleBox[\"J\",\
FontSlant->\"Italic\"], StyleBox[RowBox[{\"Cl\", \"-\", \
\"Cl\"}],FontSlant->\"Plain\"]], StyleBox[\"/\",FontSlant->\"Italic\"], \
StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]}]]\)\>\"", "*)"}], 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dashing", "[", "None", "]"}], ",", " ", "Dashed"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", " ", "Gray"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"False", 
          RowBox[{"(*", "True", "*)"}], ",", " ", "False"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
         "measuredJbcDIVJbbErr", ",", " ", "sqrtMeasuredJccDIVJbbErr"}], 
         "}"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
     "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"PlotRangePadding", "\[Rule]", "None"}], 
    RowBox[{"(*", 
     RowBox[{",", " ", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<ShrinkWrap\>\"", "\[Rule]", "True"}], "}"}]}]}], "*)"}], 
    ",", " ", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", " ", 
    RowBox[{"LabelStyle", "\[Rule]", "fontSize"}], ",", " ", 
    RowBox[{"FrameStyle", "\[Rule]", "fontSize"}], ",", " ", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Critical substitution level\>\"", ",", " ", "None"}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"]\
, StyleBox[RowBox[{\"Br\", \"-\", \"Cl\"}],FontSlant->\"Plain\"]],FontSlant->\
\"Italic\"]\)\!\(\*StyleBox[\"/\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\
SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], StyleBox[RowBox[{\"Br\", \
\"-\", \"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\>\"", ",", 
         " ", "\"\<\>\""}], 
        RowBox[{"(*", "None", "*)"}], 
        RowBox[{
        "(*", "\"\<\!\(\*SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Cl\", \"-\", \
\"Cl\"}],FontSlant->\"Plain\"]]\)\!\(\*StyleBox[\"/\",FontSlant->\"Italic\"]\)\
\!\(\*StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)= 1.27(9)/6.21(8)\>\"", "*)"}], "}"}]}], "}"}]}], 
    ",", " ", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.789385328387625*^9, 3.789385623387498*^9}, {
   3.78938566678798*^9, 3.7893857030130525`*^9}, {3.789385768283786*^9, 
   3.7893857982955027`*^9}, {3.7893858535966654`*^9, 3.789385859821021*^9}, {
   3.7893859042095604`*^9, 3.789386168353668*^9}, {3.789386213876272*^9, 
   3.7893862885035405`*^9}, {3.789386331244985*^9, 3.789386434599897*^9}, {
   3.7893920543893304`*^9, 3.789392084738066*^9}, {3.7893921719850564`*^9, 
   3.789392179529488*^9}, {3.7893924505799913`*^9, 3.7893924727412586`*^9}, {
   3.7893925315836244`*^9, 3.789392732167097*^9}, {3.7893927824409723`*^9, 
   3.789392822101241*^9}, {3.7893929183367453`*^9, 3.7893931828098726`*^9}, {
   3.789393232406709*^9, 3.7893932326507235`*^9}, {3.789393263950513*^9, 
   3.789393338129756*^9}, {3.7893935525250187`*^9, 3.789393742743899*^9}, {
   3.7893937889315405`*^9, 3.789393791769703*^9}, {3.789393903180075*^9, 
   3.78939410799579*^9}, {3.7893941632909527`*^9, 3.7893942455006547`*^9}, {
   3.7893943033499637`*^9, 3.7893944413768587`*^9}, {3.7893944885965595`*^9, 
   3.7893949011701565`*^9}, {3.7893949455796967`*^9, 
   3.7893950696867957`*^9}, {3.7893951092370577`*^9, 
   3.7893956593375216`*^9}, {3.7893957020109625`*^9, 3.789395946987974*^9}, {
   3.7930148566509676`*^9, 3.793015026368675*^9}, {3.793015105693212*^9, 
   3.793015202650758*^9}, {3.7930152688755455`*^9, 3.7930152700476127`*^9}, {
   3.7930153022254534`*^9, 3.793015391325549*^9}, {3.793015430030763*^9, 
   3.7930154489958477`*^9}, {3.793015655547662*^9, 3.7930156906596704`*^9}, {
   3.793015727997806*^9, 3.79301573068996*^9}, {3.793015762125758*^9, 
   3.793015866801745*^9}, {3.793015908449127*^9, 3.7930159534887033`*^9}, {
   3.793015985846554*^9, 3.7930163785710163`*^9}, {3.793016439192484*^9, 
   3.7930164422126565`*^9}, {3.7930164795167904`*^9, 3.793016577804412*^9}, {
   3.793016642363105*^9, 3.7930166711577516`*^9}, {3.7930168008691707`*^9, 
   3.7930168202982817`*^9}, {3.79308518837387*^9, 3.7930851973783846`*^9}, {
   3.7930997133216496`*^9, 3.793099724244274*^9}, {3.7930997929532037`*^9, 
   3.7930997943002806`*^9}, {3.793102461487835*^9, 3.7931027154723625`*^9}, {
   3.79310278309123*^9, 3.793102783353245*^9}, {3.7931030415730143`*^9, 
   3.7931030851455064`*^9}, {3.7931031419537554`*^9, 
   3.7931031772367735`*^9}, {3.7931032503889575`*^9, 
   3.7931032579363894`*^9}, {3.793103297211636*^9, 3.7931033938411627`*^9}, {
   3.7931034822502193`*^9, 3.7931035256116996`*^9}, {3.7931035639078903`*^9, 
   3.7931036571602235`*^9}, {3.793103699074621*^9, 3.793103768212576*^9}, 
   3.793103809677947*^9, {3.793103943265588*^9, 3.7931040653455706`*^9}, {
   3.7931041015176396`*^9, 3.7931041036477613`*^9}, {3.793104152958582*^9, 
   3.793104389988139*^9}, {3.7931044396549797`*^9, 3.7931044427881594`*^9}, {
   3.7935987260885744`*^9, 3.7935987306828375`*^9}, {3.7936191707553864`*^9, 
   3.7936191838660507`*^9}, {3.7936197127342086`*^9, 3.793619862032667*^9}, {
   3.793619914133283*^9, 3.7936199735478277`*^9}, {3.7936200208673363`*^9, 
   3.7936204001484995`*^9}, {3.7936204353439684`*^9, 
   3.7936205467131104`*^9}, {3.793620581086975*^9, 3.793621229336793*^9}, {
   3.7936213046593575`*^9, 3.7936214360465417`*^9}, {3.7936214679465923`*^9, 
   3.793621481215277*^9}, {3.7936215118111625`*^9, 3.793621684865638*^9}, {
   3.793621734406928*^9, 3.793621737026761*^9}, {3.7936217997612276`*^9, 
   3.79362191908488*^9}, {3.7936219652982483`*^9, 3.793622000554225*^9}, {
   3.793622070170065*^9, 3.7936220828301725`*^9}, 3.7936224531822014`*^9, {
   3.793622568671867*^9, 3.7936225712141895`*^9}, {3.793622601526539*^9, 
   3.793622675932987*^9}, {3.7936227268259497`*^9, 3.793622790528039*^9}, {
   3.7936228699486237`*^9, 3.7936229480720444`*^9}, 3.793623241137759*^9, {
   3.793643530412134*^9, 3.7936435996470947`*^9}, {3.794581508804676*^9, 
   3.7945815440506926`*^9}, {3.794581719691738*^9, 3.79458172688315*^9}, {
   3.794581773122794*^9, 3.7945817826483393`*^9}, {3.7945818192164307`*^9, 
   3.794581909446592*^9}, {3.7945819941914387`*^9, 3.7945820268383064`*^9}, {
   3.794582081384426*^9, 3.7945821367455926`*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"06f7c522-ac9a-4699-80f4-0bf4ef23def9"],

Cell[BoxData["0.2059950395197792`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144606042*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"f999d40a-7843-4cdf-8972-6a5a11f3b5c9"],

Cell[BoxData["0.014649316674734953`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821446110425`*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"9088a26d-b37e-41f0-a074-b510e78975fb"],

Cell[BoxData["0.6856512801706252`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821446140423`*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"d1d2bbfc-60cb-45c0-bd0f-c808b25365b0"],

Cell[BoxData["0.05241934242321986`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144618043*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"2e19cc78-0f54-4150-a9e7-766708f93188"],

Cell[BoxData["0.4538667640616343`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144623043*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"77539d4b-78be-4a0c-adf8-d04d0fcec788"],

Cell[BoxData["0.01613834481251595`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144628043*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"6ee2c0a3-da27-4e9a-bea5-16aa56b56f02"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.39873807121651295`", ",", "0.8798096787870848`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.413699686861584`", ",", "0.8730938273941816`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.47716040757921685`", ",", "0.8417524223856625`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821446330433`*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"74904b6c-d26f-4e8c-82df-726b2d8de13d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.39873807121651295`", ",", "0.38271098346923094`", ",", 
   "0.41617061110108955`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821447050476`*^9},
 CellLabel->
  "Out[198]=",ExpressionUUID->"aa1bad7d-4a2b-49b0-bad1-789215342221"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.39873807121651295`", ",", "0.38520358905520413`", ",", 
   "0.4129389938198801`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821447090483`*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"8b7289db-10a8-4ca7-af53-2482ed4c8221"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8798096787870848`", ",", "0.8796648658833427`", ",", 
   "0.8799743108499215`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821447120485`*^9},
 CellLabel->
  "Out[200]=",ExpressionUUID->"23b3b055-8696-4ac8-99f2-9f45dc10e47d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8798096787870848`", ",", "0.892945987366173`", ",", 
   "0.8656499607808135`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821447780523`*^9},
 CellLabel->
  "Out[201]=",ExpressionUUID->"fe7ef38a-95a3-4b93-a2c5-451976dffc1a"],

Cell[BoxData["0.41`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144782052*^9},
 CellLabel->
  "Out[202]=",ExpressionUUID->"857d00fa-f282-4aa1-a0e0-c80033dda5f0"],

Cell[BoxData["0.23`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144787052*^9},
 CellLabel->
  "Out[203]=",ExpressionUUID->"ae223439-723c-4147-8e60-e0d082f04efa"],

Cell[BoxData["0.89`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144790053*^9},
 CellLabel->
  "Out[204]=",ExpressionUUID->"2d77344b-c0de-4df1-9508-eb7b4822494c"],

Cell[BoxData["0.77`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821447930527`*^9},
 CellLabel->
  "Out[205]=",ExpressionUUID->"29f6d34a-f371-4766-b0b4-970f29244557"],

Cell[BoxData["0.32`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144796053*^9},
 CellLabel->
  "Out[206]=",ExpressionUUID->"bf52683a-9745-4bf1-929f-819d00c7b718"],

Cell[BoxData["0.08999999999999998`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144799053*^9},
 CellLabel->
  "Out[207]=",ExpressionUUID->"68c078e1-9a2b-4239-8c3f-78d3acf817a2"],

Cell[BoxData["0.8300000000000001`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821448040533`*^9},
 CellLabel->
  "Out[208]=",ExpressionUUID->"c0836361-0d3d-4528-b9b8-01deebb133c9"],

Cell[BoxData["0.06`"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.794582144809054*^9},
 CellLabel->
  "Out[209]=",ExpressionUUID->"fec93b1d-7a84-4038-a98b-0ac035cad73e"],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821448120537`*^9},
 CellLabel->
  "Out[210]=",ExpressionUUID->"21c404f1-981f-4c24-b132-fdb22edca525"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{
      {GrayLevel[0], Thickness[Medium], Opacity[0.2], Dashing[{Small, Small}],
        LineBox[{{0, 0.32}, {1, 0.32}}], 
       {Opacity[0.2], RectangleBox[{0, 0.23000000000000004}, {1, 0.41}]}, 
       {Opacity[0.7], InsetBox[
         StyleBox["\<\"Experiment\"\>",
          StripOnInput->False,
          FontSize->17,
          FontWeight->Bold], {0.03, 0.32}, {-1, -1}]}}, 
      {RGBColor[1, 0, 0], Thickness[Medium], Opacity[0.2], 
       Dashing[{Small, Small}], 
       LineBox[{{0, 0.8300000000000001}, {1, 0.8300000000000001}}], 
       {Opacity[0.2], RectangleBox[{0, 0.77}, {1, 0.8900000000000001}]}, 
       {Opacity[0.7], InsetBox[
         StyleBox["\<\"Experiment\"\>",
          StripOnInput->False,
          FontSize->17,
          
          FontWeight->
           Bold], {0.03, 0.8300000000000001}, {-1, -1}]}}}, {{{}, {}, 
       TagBox[
        {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVx3841AcAx3F3tOiHqLATolS6sn7MlGo+LYaILfTQMwmrNLX8SI/VUq4w
PwqVpxTO+ZGtDBE95Wer21V+JO7kKh1d19fdfb9f31pkrrDv/ng/7+dlFxHt
v5erp6fny/b/vfequ+9qdrju4ryfW8wlYOBmGTPAc0Kw8auAbn0CXxblFdzk
uWM8YCKJM42AT2dfbSEvEOO154rCpxMI2jPWfJ63BzlFSsp2FoGXq35zO8uL
h6XHWHO+GQGR2XepGbxkeLWv0QgcCAgMby5L5+VC/v6tZrYfgeCdxdVv35Uh
v3JZhouQwMwpQYinTTVC2ocVkUMElmwfVt/PrINl2u2d0Y5DSHjsgryRO9Dd
oTcHJQzBos5UweG04tibfaUeDUO4pXTr6Np0D39OOJgk6alxL6pwwU5KDMFk
q56RmxqjS7+eU/nzA2x6oOZoTqjBHa8wWbCkDUfO/F1yqFkN56mwWwFVHUjc
mH4uc1SNjmSnxxJ+F1a7GiUc4WuwMIccvzb8BEnp13RZ4RqQYwOK3tU9qGte
GyA/r0GZtrHNOEuKCuOuEa5EA2Pr3xmVSob4lr6Wzz5ocOan+n0i+6e4G0P2
qGy1+LC5QrX/ZB/Wu7V6hPtqEb9WXGd+X44Rg/lOFke0GKgSZ3bbPYdE6izf
INTiY5Qsf/mxF/h8XfinNrEWK76ZPrmvsR/FYiNX5yEtPEvsImssFNiSmJap
mUEiwXr3olchAwi5YBHdwSexktoxs893EMd7szRiLxLz5rw1FOsGUfWwa0Id
ScKgNb96ccEr6JqOfWo5TeKAU+MzIx8l5LTWtFxEomJrhKjlgxLrSkb1uxpJ
jJKWJsTF17go4D60kpGoD/DUz3VXodQ1MCWSJnHSK6WojlDB/p81zSYGFOxe
estLU95Alnr0cjSPwoZ1ybm8tQSE/DKHhlUUQmy6xjlSAlWTgyfuuFEYbTur
jBEMwdAq2PxCMIU8g9B4f3s1pkW0jPkeoDBPUV/CFasRfNVpMzeRwrREQaBL
rAbXHxUxp7Ip6F0LrVbO1UInjN6/TEQh7kr12bn3tNC217ln1FBoXpFmaHqI
RNjQGpdPf1Ew9Y5becqYQkt6nKj9CYV+xyfSo00UlLKact9BCjeEsFeF0ogX
mnVvHaawq9rZ1HqSRkdfY0PWRwpJKcWC/uvDKNAlZf9qRKNSbZ1vvI3BLKng
+WxzGmmFKWEKPwYb2v81/5b1Hn96SdV2BjFmlT7HWVs1Nd3wDWLwvURaqGWd
kf2D5EwEg4hz7m8kFjT2O19+N+MoA8pvBvcEj8ai5Ple08sZ5L+XJBJWNCbX
H5/d9wcDya0XYitrGs/o1z3lFQzitoYaBLDOCbq5y6OGwW5Z7cFW1lN8/8Mp
TQzyHO8rL9nQ6O/OFupLGaxc2rnX05bG7dSxH6W9DLaYxTolss7duHt5qZzB
0tQrH2tZ+1z9om6LgkFA5+nDNnY0Gn7pfCTQMPCekBuNsr7o+FX2dorBNqOe
Av4iGrHKgkA7hsFT3xCHMNYO2w4O3B1hYLuDv7ydtQFHVpYzxsCPEyvUW0xj
sH5jVJiOwYvbfrOcWTdFla5aPcFAyIjjDrC+tHDm6NQUAxNeb7eI9X8+s3xd

          "]]},
        Annotation[#, "Charting`Private`Tag$75224#1"]& ], 
       TagBox[
        {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJwVzn8803kAx/H5Ua1cin4ZqQdxpd8n507U26GrttIl/SShQuL8SLm60umI
q2QnpEh+VSRWfnU11TIPdfKj2pexZpvZhsw+9ciYOtzdH6/H89+XVWCE12F9
Go229b/+l3m47w2vf+f6fUYZ9Hx9FQzdzSOlDAdEeMgqI/VUWHMzK6eS4QGX
FVEsV5oKrGZhxQ2GN4JMr0A6psTuQyNP0hiH4EazWjd/VImuVUnuKYwY6G49
vZpGlMibs+38BUYCxl9FLIgSKxFPr1z8ByMdHTPkc3XVSuzZm8/58LEI/3Sl
JHEClDCaiPfduICDOPdMDcNUCdvtmj7+xSoMml9WxvAViG1xQtbQI9iJ7vI5
4QrMqzKR6Ok9A3vMLjncUoEauXtTq0sdwgq484839KAu9IbFXnU9yq4bdG6L
6oH263UzysJfoI4XdJNl3QP90dKZFraNcHweZe/aLIfjhH/NjvIm6DLGvHLj
5GhKcGhpWNoKsS56TqC9HAvZA6MlmtfQHY7t5cm6MTAilbStfouVTmsHazK6
UfSe22h8WQB/kseu3tANY8s7RKGgcGLocdp1nQyXjlQH5dm0o97n6PppFTIM
u5YqQs4KYf6cKCcHyxBjX181l98BsyQd/6S1DNLy+otvrEQIKDsRXlgpxZdQ
Ktvu1DswK2i5zCVSLPthyngQV4wQQYBoQ4kEGwusgh/Mk4BOu1LXbC1BrOUB
625fKY4v5oZtLu7CcvVOI+FWGejTSxzG7bswa8YHev1nGZ7+PlMjrhHD8Fk2
Z1FON0x7zWL7Nohx1IHbOZUlh/jO5Ja0lnco3RyY93RYDldNuu6U7ztoB8xn
qjJ70M8SRDwZEqF6x0aDdA8FaKdnh8xLEuHspsSbVSoF1Fks8d5FIlh1MTsK
E5WQH931aZjfibXfJaQz7FXwZnsfMznQCd8FraN6AhVETW2qbQad0DamyCPj
e2FuambiV9CBLEO/GC+bPvRp3dm2zA7MklQX6Nf3ITNYn8fTCjHpTLy3U1Q/
ctvKs87kCEEr8ePITd+jYl/kcjeWENHXOSmmde9RVOJTGaZtx5NlyXSTnweg
PhaX51nYDhNm9PJzxmrYNHju+HNPO8QrXgtO1qqh4F7+FDe1HfdzYaPwG0TY
EbPo2Odt2M9xNLEcHwTzZZXTr6fb8Ftifrz4rgZNi5cheE0byvoss423EOQW
7zN8+4FC8o1Ef4knAX1nu909QuGQ16Bt+XaC5DzP8PMaCvNra+9v3U1Q/MrG
01lN4UKqT8OlQAJhmvbE7V4KIY7XPk47SZD5MjvgnISCdcLsTVNuEziqOXE/
NVEY//70dGExQblU5bPyFYXOwZ63t0sJ1rte2/VVIwX27sr9Pz7472eTf9HL
FxQmlnodS6wlqMqYku/GpyB+k5prICAIHl1n4fKYwl/nRw4K2giK+re0WDyi
kO58wK6wgyAj+Wrul4cUWLdWVrlJCLqGWzO51RQe/9L8d3w/QWSFn9LlAYXM
Fd+mblcTiL4Rx1vepxAlz/G2IgQOD487j5dTWLIlTMobIpg8bXAS7x4FQz2q
iD1CMHuobm5+KQVZtXOo/2cCZ8tbHufuUqgNLVy1eozAPiM19WAJhasLjbQT
EwRrw+JGPIop/AszaYKG
          "]]},
        Annotation[#, "Charting`Private`Tag$75224#2"]& ]}, {}}, 
     {RGBColor[0, 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], Thickness[Medium], Opacity[
      0.7], Dashing[{Small, Small}], 
      LineBox[{{{0.647, 0}, {0.647, 1}}, {{0.779, 0}, {0.779, 1}}}], 
      {Opacity[0.8], DiskBox[{0.647, 0.4102868854456022}, 0.009], 
       DiskBox[{0.779, 0.8908097115552562}, 0.009]}, 
      {Opacity[0.7], {InsetBox[
         StyleBox["\<\"Lower exp. bound\"\>",
          StripOnInput->False,
          FontSize->17,
          FontWeight->Bold], {0.647, 0.63}, {0, -1}, Automatic, {0, 1}], 
        InsetBox[
         StyleBox["\<\"Upper exp. bound\"\>",
          StripOnInput->False,
          FontSize->17,
          FontWeight->Bold], {0.779, 0.63}, {0, 1}, Automatic, {0, 1}]}, 
       InsetBox[
        StyleBox["\<\"Allowed\"\>",
         StripOnInput->False,
         FontSize->17,
         FontWeight->Bold], {0.7130000000000001, 1.0055}, {0, -1}], 
       {Opacity[0.2], RectangleBox[{0.647, 0}, {0.779, 1}]}}}, 
     {RGBColor[0, 0, 1], Thickness[Medium], Opacity[0.7], 
      {Dashing[None], 
       LineBox[{{0.6856512801706252, 0}, {0.6856512801706252, 1}}], 
       {Opacity[0.7], 
        DiskBox[{0.6856512801706252, 0.39873807121651295}, 0.009], 
        DiskBox[{0.6856512801706252, 0.8798096787870848}, 0.009]}}, 
      {Thickness[Large], 
       LineBox[{{{0.6756512801706251, -0.01}, {0.6956512801706252, 0.01}}, {{
        0.6756512801706251, 0.01}, {0.6956512801706252, -0.01}}}], 
       LineBox[{{{0.6756512801706251, 0.99}, {0.6956512801706252, 1.01}}, {{
        0.6756512801706251, 1.01}, {0.6956512801706252, 0.99}}}]}, 
      {Opacity[0.7], InsetBox[
        StyleBox[
         StyleBox["\<\"Fitted value\"\>",
          StripOnInput->False,
          FontWeight->Bold],
         StripOnInput->False,
         FontSize->17], {0.6906512801706252, 0.63}, {0, 1}, Automatic, {0, 
        1}], 
       {Thickness[0.005], 
        LineBox[{{0.6332319377474053, 0}, {0.738070622593845, 0}}], 
        CircleBox[{0.713070622593845, 0}, 0.025, 
         NCache[{(-18) Degree, 18 Degree}, {-0.3141592653589793, 
          0.3141592653589793}]], 
        CircleBox[{0.6582319377474053, 0}, 0.025, 
         NCache[{(-18) Degree + Pi, 18 Degree + Pi}, {2.827433388230814, 
          3.4557519189487724`}]]}}}, 
     {GrayLevel[0.5], Thickness[Medium], Opacity[0.7], 
      {Dashing[{Small, Small}], 
       LineBox[{{0.4538667640616343, 0}, {0.4538667640616343, 1}}], 
       {Opacity[0.7], 
        DiskBox[{0.4538667640616343, 0.47716040757921685}, 0.009], 
        DiskBox[{0.4538667640616343, 0.8417524223856625}, 0.009]}}, 
      {Thickness[Large], 
       LineBox[{{{0.4438667640616343, -0.01}, {0.4638667640616343, 0.01}}, {{
        0.4438667640616343, 0.01}, {0.4638667640616343, -0.01}}}], 
       LineBox[{{{0.4438667640616343, 0.99}, {0.4638667640616343, 1.01}}, {{
        0.4438667640616343, 1.01}, {0.4638667640616343, 0.99}}}]}, 
      {Opacity[0.7], InsetBox[
        StyleBox[
         StyleBox["\<\"\\!\\(\\*SqrtBox[RowBox[{SubscriptBox[StyleBox[\\\"J\\\
\",FontSlant->\\\"Italic\\\"], StyleBox[RowBox[{\\\"Cl\\\", \\\"-\\\", \\\"Cl\
\\\"}],FontSlant->\\\"Plain\\\"]], StyleBox[\\\"/\\\",FontSlant->\\\"Italic\\\
\"], StyleBox[SubscriptBox[StyleBox[\\\"J\\\",FontSlant->\\\"Italic\\\"], \
StyleBox[RowBox[{\\\"Br\\\", \\\"-\\\", \
\\\"Br\\\"}],FontSlant->\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]}]]\\)\"\>",
          StripOnInput->False,
          FontWeight->Bold],
         StripOnInput->False,
         FontSize->17], {0.4588667640616343, 0.63}, {0, 1}, Automatic, {0, 
        1}], 
       {Thickness[0.005], 
        LineBox[{{0.4377284192491183, 0}, {0.47000510887415026`, 0}}], 
        CircleBox[{0.44500510887415023, 0}, 0.025, 
         NCache[{(-18) Degree, 18 Degree}, {-0.3141592653589793, 
          0.3141592653589793}]], 
        CircleBox[{0.46272841924911834, 0}, 0.025, 
         NCache[{(-18) Degree + Pi, 18 Degree + Pi}, {2.827433388230814, 
          3.4557519189487724`}]]}}}}, InsetBox[
     TemplateBox[{
      "\"Upper critical level \
\\!\\(\\*SubscriptBox[StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"], \
StyleBox[\\\"c2\\\",FontSlant->\\\"Plain\\\"]]\\)\"",
       "\"Lower critical level \
\\!\\(\\*SubscriptBox[StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"], \
StyleBox[\\\"c1\\\",FontSlant->\\\"Plain\\\"]]\\)\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.11699999999999999`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.11699999999999999`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 17, FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                   ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", "17"}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.01, 0.01}], ImageScaled[{0, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->Automatic,
   DisplayFunction->Identity,
   Frame->True,
   FrameLabel->{{
      FormBox["\"Critical substitution level\"", TraditionalForm], None}, {
      FormBox[
      "\"\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"J\\\",FontSlant->\\\"\
Italic\\\"], StyleBox[RowBox[{\\\"Br\\\", \\\"-\\\", \\\"Cl\\\"}],FontSlant->\
\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"/\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"J\\\"\
,FontSlant->\\\"Italic\\\"], StyleBox[RowBox[{\\\"Br\\\", \\\"-\\\", \\\"Br\\\
\"}],FontSlant->\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]\\)\"", 
       TraditionalForm], 
      FormBox["\"\"", TraditionalForm]}},
   FrameStyle->17,
   ImageSize->Large,
   LabelStyle->17,
   PlotRange->{{0, 1}, {0, 1}},
   PlotRangePadding->None],
  InterpretTemplate[Legended[
    Graphics[{{{
        GrayLevel[0], 
        Opacity[0.2], 
        Thickness[Medium], 
        Dashing[{Small, Small}], 
        Line[{{0, 0.32}, {1, 0.32}}], 
        Opacity[0.2], 
        Rectangle[{0, 0.23000000000000004`}, {1, 0.41}], 
        Opacity[0.7], 
        Text[
         Style["Experiment", Bold, 17], {0.03, 0.32}, {-1, -1}]}, {
        RGBColor[1, 0, 0], 
        Opacity[0.2], 
        Thickness[Medium], 
        Dashing[{Small, Small}], 
        Line[{{0, 0.8300000000000001}, {1, 0.8300000000000001}}], 
        Opacity[0.2], 
        Rectangle[{0, 0.77}, {1, 0.8900000000000001}], 
        Opacity[0.7], 
        Text[
         Style["Experiment", Bold, 17], {0.03, 
         0.8300000000000001}, {-1, -1}]}}, {{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            RGBColor[1, 0, 0], 
            Thickness[Large]], 
           Line[CompressedData["
1:eJwVx3841AcAx3F3tOiHqLATolS6sn7MlGo+LYaILfTQMwmrNLX8SI/VUq4w
PwqVpxTO+ZGtDBE95Wer21V+JO7kKh1d19fdfb9f31pkrrDv/ng/7+dlFxHt
v5erp6fny/b/vfequ+9qdrju4ryfW8wlYOBmGTPAc0Kw8auAbn0CXxblFdzk
uWM8YCKJM42AT2dfbSEvEOO154rCpxMI2jPWfJ63BzlFSsp2FoGXq35zO8uL
h6XHWHO+GQGR2XepGbxkeLWv0QgcCAgMby5L5+VC/v6tZrYfgeCdxdVv35Uh
v3JZhouQwMwpQYinTTVC2ocVkUMElmwfVt/PrINl2u2d0Y5DSHjsgryRO9Dd
oTcHJQzBos5UweG04tibfaUeDUO4pXTr6Np0D39OOJgk6alxL6pwwU5KDMFk
q56RmxqjS7+eU/nzA2x6oOZoTqjBHa8wWbCkDUfO/F1yqFkN56mwWwFVHUjc
mH4uc1SNjmSnxxJ+F1a7GiUc4WuwMIccvzb8BEnp13RZ4RqQYwOK3tU9qGte
GyA/r0GZtrHNOEuKCuOuEa5EA2Pr3xmVSob4lr6Wzz5ocOan+n0i+6e4G0P2
qGy1+LC5QrX/ZB/Wu7V6hPtqEb9WXGd+X44Rg/lOFke0GKgSZ3bbPYdE6izf
INTiY5Qsf/mxF/h8XfinNrEWK76ZPrmvsR/FYiNX5yEtPEvsImssFNiSmJap
mUEiwXr3olchAwi5YBHdwSexktoxs893EMd7szRiLxLz5rw1FOsGUfWwa0Id
ScKgNb96ccEr6JqOfWo5TeKAU+MzIx8l5LTWtFxEomJrhKjlgxLrSkb1uxpJ
jJKWJsTF17go4D60kpGoD/DUz3VXodQ1MCWSJnHSK6WojlDB/p81zSYGFOxe
estLU95Alnr0cjSPwoZ1ybm8tQSE/DKHhlUUQmy6xjlSAlWTgyfuuFEYbTur
jBEMwdAq2PxCMIU8g9B4f3s1pkW0jPkeoDBPUV/CFasRfNVpMzeRwrREQaBL
rAbXHxUxp7Ip6F0LrVbO1UInjN6/TEQh7kr12bn3tNC217ln1FBoXpFmaHqI
RNjQGpdPf1Ew9Y5becqYQkt6nKj9CYV+xyfSo00UlLKact9BCjeEsFeF0ogX
mnVvHaawq9rZ1HqSRkdfY0PWRwpJKcWC/uvDKNAlZf9qRKNSbZ1vvI3BLKng
+WxzGmmFKWEKPwYb2v81/5b1Hn96SdV2BjFmlT7HWVs1Nd3wDWLwvURaqGWd
kf2D5EwEg4hz7m8kFjT2O19+N+MoA8pvBvcEj8ai5Ple08sZ5L+XJBJWNCbX
H5/d9wcDya0XYitrGs/o1z3lFQzitoYaBLDOCbq5y6OGwW5Z7cFW1lN8/8Mp
TQzyHO8rL9nQ6O/OFupLGaxc2rnX05bG7dSxH6W9DLaYxTolss7duHt5qZzB
0tQrH2tZ+1z9om6LgkFA5+nDNnY0Gn7pfCTQMPCekBuNsr7o+FX2dorBNqOe
Av4iGrHKgkA7hsFT3xCHMNYO2w4O3B1hYLuDv7ydtQFHVpYzxsCPEyvUW0xj
sH5jVJiOwYvbfrOcWTdFla5aPcFAyIjjDrC+tHDm6NQUAxNeb7eI9X8+s3xd

            "]]}, "Charting`Private`Tag$75224#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            GrayLevel[0], 
            Thickness[Large]], 
           Line[CompressedData["
1:eJwVzn8803kAx/H5Ua1cin4ZqQdxpd8n507U26GrttIl/SShQuL8SLm60umI
q2QnpEh+VSRWfnU11TIPdfKj2pexZpvZhsw+9ciYOtzdH6/H89+XVWCE12F9
Go229b/+l3m47w2vf+f6fUYZ9Hx9FQzdzSOlDAdEeMgqI/VUWHMzK6eS4QGX
FVEsV5oKrGZhxQ2GN4JMr0A6psTuQyNP0hiH4EazWjd/VImuVUnuKYwY6G49
vZpGlMibs+38BUYCxl9FLIgSKxFPr1z8ByMdHTPkc3XVSuzZm8/58LEI/3Sl
JHEClDCaiPfduICDOPdMDcNUCdvtmj7+xSoMml9WxvAViG1xQtbQI9iJ7vI5
4QrMqzKR6Ok9A3vMLjncUoEauXtTq0sdwgq484839KAu9IbFXnU9yq4bdG6L
6oH263UzysJfoI4XdJNl3QP90dKZFraNcHweZe/aLIfjhH/NjvIm6DLGvHLj
5GhKcGhpWNoKsS56TqC9HAvZA6MlmtfQHY7t5cm6MTAilbStfouVTmsHazK6
UfSe22h8WQB/kseu3tANY8s7RKGgcGLocdp1nQyXjlQH5dm0o97n6PppFTIM
u5YqQs4KYf6cKCcHyxBjX181l98BsyQd/6S1DNLy+otvrEQIKDsRXlgpxZdQ
Ktvu1DswK2i5zCVSLPthyngQV4wQQYBoQ4kEGwusgh/Mk4BOu1LXbC1BrOUB
625fKY4v5oZtLu7CcvVOI+FWGejTSxzG7bswa8YHev1nGZ7+PlMjrhHD8Fk2
Z1FON0x7zWL7Nohx1IHbOZUlh/jO5Ja0lnco3RyY93RYDldNuu6U7ztoB8xn
qjJ70M8SRDwZEqF6x0aDdA8FaKdnh8xLEuHspsSbVSoF1Fks8d5FIlh1MTsK
E5WQH931aZjfibXfJaQz7FXwZnsfMznQCd8FraN6AhVETW2qbQad0DamyCPj
e2FuambiV9CBLEO/GC+bPvRp3dm2zA7MklQX6Nf3ITNYn8fTCjHpTLy3U1Q/
ctvKs87kCEEr8ePITd+jYl/kcjeWENHXOSmmde9RVOJTGaZtx5NlyXSTnweg
PhaX51nYDhNm9PJzxmrYNHju+HNPO8QrXgtO1qqh4F7+FDe1HfdzYaPwG0TY
EbPo2Odt2M9xNLEcHwTzZZXTr6fb8Ftifrz4rgZNi5cheE0byvoss423EOQW
7zN8+4FC8o1Ef4knAX1nu909QuGQ16Bt+XaC5DzP8PMaCvNra+9v3U1Q/MrG
01lN4UKqT8OlQAJhmvbE7V4KIY7XPk47SZD5MjvgnISCdcLsTVNuEziqOXE/
NVEY//70dGExQblU5bPyFYXOwZ63t0sJ1rte2/VVIwX27sr9Pz7472eTf9HL
FxQmlnodS6wlqMqYku/GpyB+k5prICAIHl1n4fKYwl/nRw4K2giK+re0WDyi
kO58wK6wgyAj+Wrul4cUWLdWVrlJCLqGWzO51RQe/9L8d3w/QWSFn9LlAYXM
Fd+mblcTiL4Rx1vepxAlz/G2IgQOD487j5dTWLIlTMobIpg8bXAS7x4FQz2q
iD1CMHuobm5+KQVZtXOo/2cCZ8tbHufuUqgNLVy1eozAPiM19WAJhasLjbQT
EwRrw+JGPIop/AszaYKG
            "]]}, "Charting`Private`Tag$75224#2"]}}, {}}, {
       RGBColor[0, 
        Rational[2, 3], 0], 
       Opacity[0.7], 
       Thickness[Medium], 
       Dashing[{Small, Small}], 
       Opacity[0.7], 
       Line[{{{0.647, 0}, {0.647, 1}}, {{0.779, 0}, {0.779, 1}}}], 
       Opacity[0.8], 
       Disk[{0.647, 0.4102868854456022}, 0.009], 
       Disk[{0.779, 0.8908097115552562}, 0.009], 
       Opacity[0.7], {
        Text[
         Style["Lower exp. bound", Bold, 17], {0.647, 0.63}, {0, -1}, {0, 1}], 
        Text[
         Style["Upper exp. bound", Bold, 17], {0.779, 0.63}, {0, 1}, {0, 1}]}, 
       Text[
        Style["Allowed", Bold, 17], {0.7130000000000001, 1.0055}, {0, -1}], {
        Opacity[0.2], 
        Rectangle[{0.647, 0}, {0.779, 1}]}}, {
       RGBColor[0, 0, 1], 
       Thickness[Medium], 
       Opacity[0.7], {
        Dashing[None], 
        Line[{{0.6856512801706252, 0}, {0.6856512801706252, 1}}], 
        Opacity[0.7], 
        Disk[{0.6856512801706252, 0.39873807121651295`}, 0.009], 
        Disk[{0.6856512801706252, 0.8798096787870848}, 0.009]}, {
        Thickness[Large], 
        Line[{{{0.6756512801706251, -0.01}, {0.6956512801706252, 0.01}}, {{
         0.6756512801706251, 0.01}, {0.6956512801706252, -0.01}}}], 
        Line[{{{0.6756512801706251, 0.99}, {0.6956512801706252, 1.01}}, {{
         0.6756512801706251, 1.01}, {0.6956512801706252, 0.99}}}]}, 
       Opacity[0.7], 
       Text[
        Style[
         Style["Fitted value", Bold], 17], {0.6906512801706252, 0.63}, {0, 
        1}, {0, 1}], {
        Thickness[0.005], 
        Line[{{0.6332319377474053, 0}, {0.738070622593845, 0}}], 
        Circle[{0.713070622593845, 0}, 0.025, {(-18) Degree, 18 Degree}], 
        Circle[{0.6582319377474053, 0}, 
         0.025, {(-18) Degree + Pi, 18 Degree + Pi}]}}, {
       GrayLevel[0.5], 
       Thickness[Medium], 
       Opacity[0.7], {
        Dashing[{Small, Small}], 
        Line[{{0.4538667640616343, 0}, {0.4538667640616343, 1}}], 
        Opacity[0.7], 
        Disk[{0.4538667640616343, 0.47716040757921685`}, 0.009], 
        Disk[{0.4538667640616343, 0.8417524223856625}, 0.009]}, {
        Thickness[Large], 
        Line[{{{0.4438667640616343, -0.01}, {0.4638667640616343, 0.01}}, {{
         0.4438667640616343, 0.01}, {0.4638667640616343, -0.01}}}], 
        Line[{{{0.4438667640616343, 0.99}, {0.4638667640616343, 1.01}}, {{
         0.4438667640616343, 1.01}, {0.4638667640616343, 0.99}}}]}, 
       Opacity[0.7], 
       Text[
        Style[
         Style[
         "\!\(\*SqrtBox[RowBox[{SubscriptBox[StyleBox[\"J\",FontSlant->\"\
Italic\"], StyleBox[RowBox[{\"Cl\", \"-\", \"Cl\"}],FontSlant->\"Plain\"]], \
StyleBox[\"/\",FontSlant->\"Italic\"], \
StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]}]]\)", Bold], 17], {
        0.4588667640616343, 0.63}, {0, 1}, {0, 1}], {
        Thickness[0.005], 
        Line[{{0.4377284192491183, 0}, {0.47000510887415026`, 0}}], 
        Circle[{0.44500510887415023`, 0}, 0.025, {(-18) Degree, 18 Degree}], 
        Circle[{0.46272841924911834`, 0}, 
         0.025, {(-18) Degree + Pi, 18 Degree + Pi}]}}}, {
     PlotRange -> {{0, 1}, {0, 1}}, PlotRangePadding -> None, Frame -> True, 
      ImageSize -> Large, LabelStyle -> 17, FrameStyle -> 17, 
      FrameLabel -> {{"Critical substitution level", None}, {
        "\!\(\*StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\"Italic\"], \
StyleBox[RowBox[{\"Br\", \"-\", \
\"Cl\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"/\",\
FontSlant->\"Italic\"]\)\!\(\*StyleBox[SubscriptBox[StyleBox[\"J\",FontSlant->\
\"Italic\"], StyleBox[RowBox[{\"Br\", \"-\", \
\"Br\"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)", ""}}, AspectRatio -> 
      Automatic}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Thickness[Large]]}, {
       "Upper critical level \
\!\(\*SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"c2\",FontSlant->\"Plain\"]]\)", 
        "Lower critical level \
\!\(\*SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"c1\",FontSlant->\"Plain\"]]\)"}, LegendMarkers -> None, LabelStyle -> 
       17, LegendLayout -> "Column"]], {Left, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.7893857986985254`*^9, 3.7893859179563465`*^9, {3.78938601312879*^9, 
   3.7893860290407*^9}, {3.789386063224655*^9, 3.789386123155083*^9}, 
   3.789386168925701*^9, {3.7893862418878746`*^9, 3.789386289415593*^9}, 
   3.7893864381420994`*^9, 3.7893920851650906`*^9, 3.7893921806065493`*^9, 
   3.7893924740323324`*^9, 3.789392513570594*^9, 3.789392584745665*^9, 
   3.7893927010263157`*^9, {3.7893928133317394`*^9, 3.7893928225532665`*^9}, {
   3.789392934031643*^9, 3.7893929621692524`*^9}, 3.7893930374075556`*^9, {
   3.78939314273158*^9, 3.7893931834369082`*^9}, {3.7893933245849814`*^9, 
   3.789393338443774*^9}, {3.789393554255118*^9, 3.7893935584713593`*^9}, {
   3.78939364538033*^9, 3.7893937430129137`*^9}, {3.7893939047391644`*^9, 
   3.7893939363689737`*^9}, {3.7893939909880977`*^9, 3.78939406830952*^9}, 
   3.7893941086648283`*^9, {3.7893941852262073`*^9, 3.78939424577367*^9}, {
   3.7893943037639875`*^9, 3.7893943415911508`*^9}, {3.7893944030266647`*^9, 
   3.789394441742879*^9}, {3.7893945135499864`*^9, 3.7893945207904005`*^9}, 
   3.7893945902333727`*^9, {3.7893946380841093`*^9, 3.789394648028678*^9}, {
   3.789394722580942*^9, 3.7893948435688624`*^9}, {3.7893949473377976`*^9, 
   3.7893950280864162`*^9}, 3.7893950704988422`*^9, {3.789395110812148*^9, 
   3.7893952053125525`*^9}, {3.789395272835415*^9, 3.7893954009247413`*^9}, {
   3.7893954637793365`*^9, 3.789395499418375*^9}, {3.7893955298861175`*^9, 
   3.789395581489069*^9}, {3.789395640566448*^9, 3.789395659713543*^9}, {
   3.7893958141023736`*^9, 3.789395907032689*^9}, 3.789395947597009*^9, 
   3.7930150298098717`*^9, {3.7930151738721113`*^9, 3.7930152031277847`*^9}, 
   3.7930152709376636`*^9, 3.7930153187433977`*^9, 3.7930153918675804`*^9, {
   3.7930154382142315`*^9, 3.793015450828953*^9}, {3.793015657858794*^9, 
   3.79301569170073*^9}, 3.793015731181988*^9, {3.793015765019923*^9, 
   3.7930158670917616`*^9}, {3.793015944272176*^9, 3.793015954695772*^9}, 
   3.7930159978342395`*^9, 3.79301604050568*^9, {3.79301623020053*^9, 
   3.7930163198916607`*^9}, {3.793016359105903*^9, 3.793016378996041*^9}, 
   3.7930164429707003`*^9, 3.7930164874202423`*^9, {3.793016521444188*^9, 
   3.7930165784374485`*^9}, {3.793016648613462*^9, 3.7930166714907703`*^9}, 
   3.7930168230684404`*^9, {3.7930851849256725`*^9, 3.7930851984264445`*^9}, 
   3.793099725848366*^9, 3.793099794793309*^9, {3.793102482644045*^9, 
   3.793102492030582*^9}, {3.7931025942804303`*^9, 3.793102715871385*^9}, 
   3.7931027837162657`*^9, {3.793103044034155*^9, 3.7931030855025268`*^9}, 
   3.793103177752803*^9, 3.793103259888501*^9, 3.793103316146719*^9, 
   3.7931033513517323`*^9, 3.7931033965713186`*^9, 3.793103484618355*^9, {
   3.7931035164891777`*^9, 3.793103526061725*^9}, {3.793103573047413*^9, 
   3.7931036591243362`*^9}, {3.7931037055039887`*^9, 3.793103768886614*^9}, 
   3.793103946119751*^9, {3.7931039961896152`*^9, 3.793104017760849*^9}, 
   3.7931040661926193`*^9, 3.7931041042347946`*^9, {3.793104153554616*^9, 
   3.7931041787270555`*^9}, {3.793104224537676*^9, 3.7931042508381805`*^9}, {
   3.7931043239433613`*^9, 3.793104390762183*^9}, 3.7931044439062233`*^9, 
   3.793598759622493*^9, 3.79361920150029*^9, 3.7936198632793255`*^9, {
   3.7936199604871693`*^9, 3.7936199743574305`*^9}, {3.793620027295653*^9, 
   3.7936200415509634`*^9}, 3.793620236009156*^9, {3.793620283570696*^9, 
   3.793620294750615*^9}, 3.793620354298177*^9, 3.7936204015001707`*^9, {
   3.7936205121237183`*^9, 3.7936205474822083`*^9}, {3.793620585134489*^9, 
   3.7936206057161026`*^9}, {3.7936206444200172`*^9, 3.793620725638831*^9}, {
   3.793620791407683*^9, 3.793620814667136*^9}, {3.7936208648165045`*^9, 
   3.7936208769215417`*^9}, {3.793620926351818*^9, 3.793620974123885*^9}, {
   3.79362102440727*^9, 3.7936212297298427`*^9}, {3.7936213404844065`*^9, 
   3.7936213516258216`*^9}, 3.7936213989528313`*^9, 3.7936214690282297`*^9, 
   3.793621501056797*^9, {3.7936215848679395`*^9, 3.7936216851981797`*^9}, 
   3.7936217380038853`*^9, {3.7936218285758867`*^9, 3.793621922374297*^9}, {
   3.793621972036604*^9, 3.793622000979779*^9}, 3.7936220881308455`*^9, 
   3.7936224543873544`*^9, 3.7936225717112527`*^9, {3.793622604940472*^9, 
   3.793622676282031*^9}, {3.7936227392295246`*^9, 3.7936227920672345`*^9}, {
   3.793622871287794*^9, 3.7936229485060997`*^9}, 3.7936232463509207`*^9, 
   3.793643609745672*^9, 3.794581546648841*^9, 3.794581912575771*^9, 
   3.794581949731896*^9, {3.7945820006718097`*^9, 3.7945820150206304`*^9}, 
   3.7945820536718407`*^9, 3.794582089638898*^9, 3.7945821460171227`*^9},
 CellLabel->"Out[211]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"68992675-d732-4013-b877-9e72f3c47dfa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "tmpfn", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpfn", " ", "=", " ", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"NotebookFileName", "[", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"\"\<.nb\>\"", "~~", "EndOfLine"}], "\[Rule]", 
      "\"\< - Export\>\""}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"tmpfn", "<>", "\"\<.pdf\>\""}], ",", " ", "tmpgraph"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"tmpfn", "<>", "\"\<.png\>\""}], ",", " ", "tmpgraph", ",", " ", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.793085203079711*^9, 3.7930852662443237`*^9}, 
   3.793099897246169*^9, {3.793099956340549*^9, 3.7931000018081493`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"1cf83737-9df9-41de-a512-87cbae814b7d"],

Cell[BoxData["\<\"F:\\\\0Tmp\\\\Moji clanki\\\\16 - \
(QuinH)2Cu(ClxBr1-x)4.2H2O, muSR + magnetization ()\\\\Mail 2020-02-26 15-46 \
(Tom Lancaster) (draft v2)\\\\SI\\\\v2c\\\\figs\\\\Original\\\\Critical \
substitution level from energy 3f (final actual data) - Export\"\>"], "Output",
 CellChangeTimes->{
  3.7930852155124216`*^9, {3.793085261031025*^9, 3.793085266921362*^9}, 
   3.7931000076284823`*^9, 3.7931027487032633`*^9, {3.793102789829615*^9, 
   3.7931027983261013`*^9}, 3.7931044549958572`*^9, 3.79359878860515*^9, 
   3.793619230210436*^9, 3.7936217424859543`*^9, 3.793622023483637*^9, 
   3.79362210076495*^9, 3.793622489323291*^9, 3.793622827252202*^9, 
   3.793622971356501*^9, 3.7936232814543786`*^9, 3.7936436209573135`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"8f4321bd-a2cd-4167-a26b-117964582c50"],

Cell[BoxData["\<\"F:\\\\0Tmp\\\\Moji clanki\\\\16 - \
(QuinH)2Cu(ClxBr1-x)4.2H2O, muSR + magnetization ()\\\\Mail 2020-02-26 15-46 \
(Tom Lancaster) (draft v2)\\\\SI\\\\v2c\\\\figs\\\\Original\\\\Critical \
substitution level from energy 3f (final actual data) - Export.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.7930852155124216`*^9, {3.793085261031025*^9, 3.793085266921362*^9}, 
   3.7931000076284823`*^9, 3.7931027487032633`*^9, {3.793102789829615*^9, 
   3.7931027983261013`*^9}, 3.7931044549958572`*^9, 3.79359878860515*^9, 
   3.793619230210436*^9, 3.7936217424859543`*^9, 3.793622023483637*^9, 
   3.79362210076495*^9, 3.793622489323291*^9, 3.793622827252202*^9, 
   3.793622971356501*^9, 3.7936232814543786`*^9, 3.7936436225714054`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"02674835-5bc6-4842-a3b3-e6ed71fde805"],

Cell[BoxData["\<\"F:\\\\0Tmp\\\\Moji clanki\\\\16 - \
(QuinH)2Cu(ClxBr1-x)4.2H2O, muSR + magnetization ()\\\\Mail 2020-02-26 15-46 \
(Tom Lancaster) (draft v2)\\\\SI\\\\v2c\\\\figs\\\\Original\\\\Critical \
substitution level from energy 3f (final actual data) - Export.png\"\>"], \
"Output",
 CellChangeTimes->{
  3.7930852155124216`*^9, {3.793085261031025*^9, 3.793085266921362*^9}, 
   3.7931000076284823`*^9, 3.7931027487032633`*^9, {3.793102789829615*^9, 
   3.7931027983261013`*^9}, 3.7931044549958572`*^9, 3.79359878860515*^9, 
   3.793619230210436*^9, 3.7936217424859543`*^9, 3.793622023483637*^9, 
   3.79362210076495*^9, 3.793622489323291*^9, 3.793622827252202*^9, 
   3.793622971356501*^9, 3.7936232814543786`*^9, 3.793643626290618*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"629055bd-537f-447f-9e98-3b8e9e75144e"]
}, Open  ]]
},
WindowSize->{1920, 998},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 39866, 960, 1536, "Input",ExpressionUUID->"06f7c522-ac9a-4699-80f4-0bf4ef23def9"],
Cell[40449, 984, 4728, 64, 32, "Output",ExpressionUUID->"f999d40a-7843-4cdf-8972-6a5a11f3b5c9"],
Cell[45180, 1050, 4732, 64, 32, "Output",ExpressionUUID->"9088a26d-b37e-41f0-a074-b510e78975fb"],
Cell[49915, 1116, 4730, 64, 32, "Output",ExpressionUUID->"d1d2bbfc-60cb-45c0-bd0f-c808b25365b0"],
Cell[54648, 1182, 4729, 64, 32, "Output",ExpressionUUID->"2e19cc78-0f54-4150-a9e7-766708f93188"],
Cell[59380, 1248, 4728, 64, 32, "Output",ExpressionUUID->"77539d4b-78be-4a0c-adf8-d04d0fcec788"],
Cell[64111, 1314, 4729, 64, 32, "Output",ExpressionUUID->"6ee2c0a3-da27-4e9a-bea5-16aa56b56f02"],
Cell[68843, 1380, 5026, 73, 32, "Output",ExpressionUUID->"74904b6c-d26f-4e8c-82df-726b2d8de13d"],
Cell[73872, 1455, 4831, 68, 32, "Output",ExpressionUUID->"aa1bad7d-4a2b-49b0-bad1-789215342221"],
Cell[78706, 1525, 4830, 68, 32, "Output",ExpressionUUID->"8b7289db-10a8-4ca7-af53-2482ed4c8221"],
Cell[83539, 1595, 4828, 68, 32, "Output",ExpressionUUID->"23b3b055-8696-4ac8-99f2-9f45dc10e47d"],
Cell[88370, 1665, 4827, 68, 32, "Output",ExpressionUUID->"fe7ef38a-95a3-4b93-a2c5-451976dffc1a"],
Cell[93200, 1735, 4714, 64, 32, "Output",ExpressionUUID->"857d00fa-f282-4aa1-a0e0-c80033dda5f0"],
Cell[97917, 1801, 4714, 64, 32, "Output",ExpressionUUID->"ae223439-723c-4147-8e60-e0d082f04efa"],
Cell[102634, 1867, 4714, 64, 32, "Output",ExpressionUUID->"2d77344b-c0de-4df1-9508-eb7b4822494c"],
Cell[107351, 1933, 4716, 64, 32, "Output",ExpressionUUID->"29f6d34a-f371-4766-b0b4-970f29244557"],
Cell[112070, 1999, 4714, 64, 32, "Output",ExpressionUUID->"bf52683a-9745-4bf1-929f-819d00c7b718"],
Cell[116787, 2065, 4729, 64, 32, "Output",ExpressionUUID->"68c078e1-9a2b-4239-8c3f-78d3acf817a2"],
Cell[121519, 2131, 4730, 64, 32, "Output",ExpressionUUID->"c0836361-0d3d-4528-b9b8-01deebb133c9"],
Cell[126252, 2197, 4714, 64, 32, "Output",ExpressionUUID->"fec93b1d-7a84-4038-a98b-0ac035cad73e"],
Cell[130969, 2263, 4713, 64, 32, "Output",ExpressionUUID->"21c404f1-981f-4c24-b132-fdb22edca525"],
Cell[135685, 2329, 58993, 1076, 636, 27688, 576, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"68992675-d732-4013-b877-9e72f3c47dfa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194715, 3410, 1003, 24, 143, "Input",ExpressionUUID->"1cf83737-9df9-41de-a512-87cbae814b7d"],
Cell[195721, 3436, 822, 11, 32, "Output",ExpressionUUID->"8f4321bd-a2cd-4167-a26b-117964582c50"],
Cell[196546, 3449, 828, 12, 32, "Output",ExpressionUUID->"02674835-5bc6-4842-a3b3-e6ed71fde805"],
Cell[197377, 3463, 826, 12, 32, "Output",ExpressionUUID->"629055bd-537f-447f-9e98-3b8e9e75144e"]
}, Open  ]]
}
]
*)

