function [] = genmesh(legWidthStr, outerRadiusStr, innerRadiusStr)
% thicknessFraction = str2num(thicknessFraction);
legWidth = str2num(legWidthStr);
outerRadius = str2num(outerRadiusStr);
innerRadius = str2num(innerRadiusStr);

addpath(genpath("mesh2d"));


%% Parameters
totalSize = 1;
meshSize = totalSize / 20;

triHeight = sqrt(3)/2 * meshSize;
minWidth = 2 * triHeight;
% minThick = minWidth / 100;

% legWidth = minWidth*(1-legWidthFraction) + (totalSize/4)*legWidthFraction;
% % thickness = minThick*(1-thicknessFraction) + (legWidth/2)*thicknessFraction;
% outerRadius = totalSize/2 * outerRadiusFraction;
% innerRadius = (outerRadius-minWidth) * innerRadiusFraction;

% If the ring arc lengths are smaller than the mesh size set them to zero
if (outerRadius < legWidth/sqrt(2)+meshSize/2) outerRadius = 0; end
if (innerRadius < meshSize/2) innerRadius = 0; end


%% Get boundary points
% Outer quater arc
outerArcTheta = atan(0.5*legWidth / outerRadius);
outerArcLength = outerRadius * (pi/2 - 2*outerArcTheta);
outerArcN = round(outerArcLength / meshSize) + 1;
if (outerArcN == 1)
  outerArcPoints = [0.5*legWidth, 0.5*legWidth];
else
  outerArcPoints = zeros(outerArcN, 2);
  for i = 1:outerArcN
    t = (i - 1) / (outerArcN - 1);
    theta = outerArcTheta*(1-t) + (pi/2-outerArcTheta)*t;
    outerArcPoints(i,:) = [outerRadius*cos(theta), outerRadius*sin(theta)];
  end
end

% Outer points
topRightFirstPoints = [0.5*totalSize+minWidth, legWidth/2];% 0.5*totalSize, legWidth/2];
topRightLastPoints  = [legWidth/2, 0.5*totalSize+minWidth];
topRightPoints = cat(1, topRightFirstPoints, outerArcPoints, topRightLastPoints);
topLeftPoints = cat(2, -topRightPoints(:,2), topRightPoints(:,1));
outerPoints = cat(1, topRightPoints, topLeftPoints, -topRightPoints, -topLeftPoints);
outerN = size(outerPoints,1);
outerPairs = (1:outerN)';
outerPairs = cat(2, outerPairs, circshift(outerPairs,-1));

% Inner ring
innerN = 4 * round(0.5*pi*innerRadius / meshSize);
innerPoints = zeros(innerN, 2);
for i = 1:innerN
  theta = 2*pi * i/innerN;
  innerPoints(i,:) = [innerRadius*cos(theta), innerRadius*sin(theta)];
end
innerPairs = outerN + (1:innerN)';
innerPairs = cat(2, innerPairs, circshift(innerPairs,-1));

points = cat(1, outerPoints, innerPoints);
pairs = cat(1, outerPairs, innerPairs);


%% Get triangulation
[P, ~, T, tnum] = refine2(points, pairs, [], [], meshSize);
P(:,3) = 0;

% Correct node orders
P1 = P(T(:,1),:);
P2 = P(T(:,2),:);
P3 = P(T(:,3),:);
Area = P1(:,1).*P2(:,2) - P2(:,1).*P1(:,2) + P2(:,1).*P3(:,2) ...
    - P3(:,1).*P2(:,2) + P3(:,1).*P1(:,2) - P1(:,1).*P3(:,2);
Area = Area/2;
I = 1:size(T,1);
Ineg = I(Area<0);
if ~isempty(Ineg)
   tmp = T(Ineg,1);
   T(Ineg,1) = T(Ineg,2);
   T(Ineg,2) = tmp;
end


%% Set regions
Nregion = [4, 4];
region = zeros(size(P,1),1);
% Fixed nodes
region(P(:,1)>=totalSize/2) = -1;
region(P(:,2)>=totalSize/2) = -2;
region(P(:,1)<=-totalSize/2) = -3;
region(P(:,2)<=-totalSize/2) = -4;
% Forced regions
region(region==0 & P(:,1)>0 & abs(P(:,2))<=legWidth/2) = 1;
region(region==0 & P(:,2)>0 & abs(P(:,1))<=legWidth/2) = 2;
region(region==0 & P(:,1)<0 & abs(P(:,2))<=legWidth/2) = 3;
region(region==0 & P(:,2)<0 & abs(P(:,1))<=legWidth/2) = 4;
region(region==0 & P(:,1)>0 & P(:,2)>0) = 5;
region(region==0 & P(:,1)<0 & P(:,2)>0) = 6;
region(region==0 & P(:,1)<0 & P(:,2)<0) = 7;
region(region==0 & P(:,1)>0 & P(:,2)<0) = 8;
% rad = sqrt(P(:,1).^2 + P(:,2).^2)
% region(rad>outerRadius & region==0 & P(:,1)>=abs(P(:,2))) = 1;
% region(rad>outerRadius & region==0 & P(:,2)>=abs(P(:,1))) = 2;
% region(rad>outerRadius & region==0 & P(:,1)<=-abs(P(:,2))) = 3;
% region(rad>outerRadius & region==0 & P(:,2)<=-abs(P(:,1))) = 4;
% region(region==0 & P(:,1)>=abs(P(:,2))) = 1;
% region(region==0 & P(:,2)>=abs(P(:,1))) = 2;
% region(region==0 & P(:,1)<=-abs(P(:,2))) = 3;
% region(region==0 & P(:,2)<=-abs(P(:,1))) = 4;

% figure()
% hold on
% patch('faces',T(:,1:3),'vertices',P,'facecolor','none','edgecolor', [.7,.7,.7]);
% scatter(P(:,1), P(:,2), 20, region, 'filled');
% % colormap(parula(sum(Nregion)+1));
% colorbar();
% daspect([1 1 1]);


%% Create data files
direc = strcat('data/width-', legWidthStr, '-outRad-', outerRadiusStr, '-inRad-', innerRadiusStr);

% Write node position file
fid = fopen(strcat(direc,'/coords.txt'), 'w');
fprintf(fid,'%.19f %.19f %.19f \n',[P']);
fclose(fid);

% Write region lists
fid = fopen(strcat(direc,'/regions.txt'), 'w');
fprintf(fid,'%i \n',[region']);
fclose(fid);

% Write triangulation
fid = fopen(strcat(direc,'/tlist.txt'), 'w');
fprintf(fid,'%i %i %i \n',[T'-1]);
fclose(fid);

end
