close all; clc;
tm = load('time_p1_vane_full_mpp1.txt');

steps=1:10;

h=figure('units','normalized','outerposition',[0.1 0.1 0.4 0.6]);

plot(tm(steps,1), tm(steps,5)/1000,'k-o','LineWidth',2, 'MarkerSize',15); hold on
ht=text(tm(steps,1)-0.2,tm(steps,5)/1000+0.2,num2str(tm(steps,4)));
set(ht,'FontSize',20);
ht=text(4,6,'number next to markers');
set(ht,'FontSize',22);
ht=text(4,5.7,'is number of iterations');
set(ht,'FontSize',22);

xlabel('Load step');
ylabel('Simulation time [ks]');
set(gca,'FontSize',20);

%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'time_p1_vane','-dpdf','-r0')

% %% save data
% save('figa_f.dat','figa_data_f','-ascii');

%%%%%%%%%%%%%%%%%%%% time per iteration

h=figure('units','normalized','outerposition',[0.1 0.1 0.4 0.6]);
plot(tm(steps,1), tm(steps,5)./tm(steps,4)/1000,'k-o','LineWidth',2, 'MarkerSize',15);hold on

mt=mean(tm(steps,5)./tm(steps,4)/1000);

plot([1 10],[mt mt],'k--','LineWidth',2); 
ht=text(4,mt-0.005,'mean');
set(ht,'FontSize',25);
upb = mt*1.02;
lob = mt*0.98;
plot([1 10],[upb upb],'k--','LineWidth',2);
ht=text(3,upb+0.005,'(1+2%)mean');
set(ht,'FontSize',25);
plot([1 10],[lob lob],'k--','LineWidth',2); 
ht=text(3,lob-0.005,'(1-2%)mean');
set(ht,'FontSize',25);

ylim([1.34,1.43]);

xlabel('Load step');
ylabel('Simulation time for one iteration [ks]');
set(gca,'FontSize',20);

%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'time_p1_vane_per_it','-dpdf','-r0')

% %% save data
% save('figa_f.dat','figa_data_f','-ascii');