close all; clc;

h=figure('units','normalized','outerposition',[0.1 0.1 0.5 0.9]);

figa_data_f=[];
figa_data_fbp=[];

lmF_mppe1={'k--o','LineWidth',1.5,'MarkerSize',15};
% lmF_mppe4={'k-.s','LineWidth',1.5,'MarkerSize',20};
% lmF_mppe11={'k:d','LineWidth',1.5,'MarkerSize',10};

lmFbp_mppe1={'k--x','LineWidth',1.5,'MarkerSize',15};
% lmFbp_mppe4={'k-.s','LineWidth',1.5,'MarkerSize',20};
% lmFbp_mppe11={'k:^','LineWidth',1.5,'MarkerSize',10};

%id=1:21;
height =0.05;
%%
f=load('trqhis_sec_mppe1_f.txt'); 
plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmF_mppe1{:});  hold on

% f=load('trqhis_sec_mppe4_f.txt'); 
% plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmF_mppe4{:}); 
% 
% f=load('trqhis_sec_mppe11_f.txt'); 
% plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmF_mppe11{:}); 

f=load('trqhis_sec_mppe1_fbp.txt'); 
plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmFbp_mppe1{:});  

% f=load('trqhis_sec_mppe4_fbp.txt'); 
% plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmFbp_mppe4{:}); 
% 
% f=load('trqhis_sec_mppe11_fbp.txt'); 
% plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmFbp_mppe11{:}); 

%% Empirical solution
D=0.1; H=1; cu=10;
TrqMax=pi*D^2*H*cu*0.5;
plot([0 8e-4],[TrqMax TrqMax],'k-','LineWidth',2); 



%hl=legend('sMPM (MPPE=1)','sMPM (MPPE=4)','sMPM (MPPE=11)','$\bar{F}$-patch (MPPE=1)','$\bar{F}$-patch (MPPE=4)','$\bar{F}$-patch (MPPE=11)','Estimated empirically');

hl=legend('sMPM','$\bar{F}$-patch','Estimated empirically');

xlabel('Vane rotation [rad]');
ylabel('Torque per unit length [kN]');

set(hl,'interpreter','latex','location','southeast');

set(gca,'FontSize',30);

 xlim([0 8e-4]);
% ylim([0 2]);
% 
%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'trq_sec','-dpdf','-r0')
% 
% % %% save data
% % save('figa_f.dat','figa_data_f','-ascii');

