close all; clc;

h=figure('units','normalized','outerposition',[0.1 0.1 0.5 0.7]);

figa_data_f=[];
figa_data_fbp=[];

lmF_h2={'k--o','LineWidth',1.5,'MarkerSize',12};
lmF_h1={'k:o','LineWidth',1.5,'MarkerSize',12};
lmF_h0d5={'k-o','LineWidth',1.5,'MarkerSize',12};

lmFbp_h2={'k--x','LineWidth',1.5,'MarkerSize',12};
lmFbp_h1={'k:x','LineWidth',1.5,'MarkerSize',12};
lmFbp_h0d5={'k-x','LineWidth',1.5,'MarkerSize',12};

id=1:21;
%%
f=load('ss_utotal_react_f_h2.txt');
f = [0 0 0 0;f];
plot(f(id,3), f(id,4), lmF_h2{:});  hold on

f=load('ss_utotal_react_f_h1.txt');f = [0 0 0 0;f];
plot(f(id,3), f(id,4), lmF_h1{:});

f=load('ss_utotal_react_f_h0d5.txt');f = [0 0 0 0;f];
plot(f(id,3), f(id,4), lmF_h0d5{:});

f=load('ss_utotal_react_fbp_h2.txt');f = [0 0 0 0;f];
plot(f(id,3), f(id,4), lmFbp_h2{:});

f=load('ss_utotal_react_fbp_h1.txt');f = [0 0 0 0;f];
plot(f(id,3), f(id,4), lmFbp_h1{:});

f=load('ss_utotal_react_fbp_h0d5.txt');f = [0 0 0 0;f];
plot(f(id,3), f(id,4), lmFbp_h0d5{:});

hl=legend('sMPM ($h$=2)','sMPM ($h$=1)','sMPM ($h$=0.5)','$\bar{F}$-patch ($h$=2)','$\bar{F}$-patch ($h$=1)','$\bar{F}$-patch ($h$=0.5)');

xlabel('Displacement [mm]');
ylabel('Reaction force [kN]');

set(hl,'interpreter','latex','location','southeast');

set(gca,'FontSize',20);


%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'frct','-dpdf','-r0')

% %% save data
% save('figa_f.dat','figa_data_f','-ascii');

