
close all; clc; clear; 

h=figure('units','normalized','position',[0.1 0.1 0.7 0.4]);


subplot(1,2,1);
%% FBP, mpe11
Array=csvread('t22_f_mpe110.0.csv',1,0); 
dt = 0.4;
t22 = Array(:, [142 143 145:147]);

xx=[dt*(0:size(t22,1)-1) fliplr(dt*(0:size(t22,1)-1))];
qq=[t22(:,2); flipud(t22(:,3))];
mm=[t22(:,1); flipud(t22(:,4))];

plot(xx,mm);
fill(xx,mm,'r','LineStyle','none'); hold on
fill(xx,qq,'y','LineStyle','none');

for i=5
    rn=plot(dt*(0:size(t22,1)-1), t22(:,i),'ko','MarkerSize',12, 'LineWidth',1.5); 
end

plot([3.6 3.6],[360 300],'k','LineWidth',1);
ht=text(3.3,280,'range');
set(ht,'fontsize',25);


plot([2.6 2.6 1.3],[407 470 470],'k','LineWidth',1);
ht=text(0.2,470,'quartile');
set(ht,'fontsize',25);

plot([0.9  1.5],[335 300],'k','LineWidth',1);
ht=text(1.6,300,'average');
set(ht,'fontsize',25);

%ht=text(1,50,'(a) sMPM');
ht=text(1,50,'(a)');
set(ht,'fontsize',25,'interpreter','latex');

xlim([0 4.4]);

%% Analytical solution
u=[0.1:0.1:1.1 1.2 1.6 2.0 5];
tau=400*ones(size(u));
for i=1:11
    F=[1 0 0; 0 u(i)/2+1 0; 0 0 1];
    T=0.5*logm(F*F')*1e3;
    if T(2,2)<400
       tau(i)=T(2,2);
    end
end
ra=plot([0 u],[0 tau],'k-','LineWidth',2);

hl=legend([rn ra],{'sMPM','analytical'});
set(hl,'location','southeast','interpreter','latex');

set(gca,'FontSize',20);
xlabel('Displacement');
ylabel('Kirchhoff stress \tau_{yy}');


%%%%%%%%%%%%%%%%%%%
subplot(1,2,2);
%% FBP, mpe11
Array=csvread('t22_fbp_mpe110.0.csv',1,0); 
dt = 0.4;
t22 = Array(:, [142 143 145:147]);

xx=[dt*(0:size(t22,1)-1) fliplr(dt*(0:size(t22,1)-1))];
qq=[t22(:,2); flipud(t22(:,3))];
mm=[t22(:,1); flipud(t22(:,4))];

plot(xx,mm);
fill(xx,mm,'r','LineStyle','none'); hold on
fill(xx,qq,'y','LineStyle','none');

for i=5
    rn=plot(dt*(0:size(t22,1)-1), t22(:,i),'kx','MarkerSize',15, 'LineWidth',1.5); 
end

ht=text(1,50,'(b)');
set(ht,'fontsize',25,'interpreter','latex');

xlim([0 4.4]);

%% Analytical solution
u=[0.1:0.1:1.1 1.2 1.6 2.0 5];
tau=400*ones(size(u));
for i=1:11
    F=[1 0 0; 0 u(i)/2+1 0; 0 0 1];
    T=0.5*logm(F*F')*1e3;
    if T(2,2)<400
       tau(i)=T(2,2);
    end
end
ra=plot([0 u],[0 tau],'k-','LineWidth',2);

hl=legend([rn ra],{'$\bar{F}$-patch','analytical'});
set(hl,'location','southeast','interpreter','latex');

set(gca,'FontSize',20);
xlabel('Displacement');
ylabel('Kirchhoff stress \tau_{yy}');

% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'t22','-dpdf','-r0')