close all; clear; clc;

lmF={'k--o','LineWidth',1.5,'MarkerSize',12};
lmFbp={'k--x','LineWidth',1.5,'MarkerSize',12};

hf=figure('units','normalized','position',[0.2 0.2 0.38 0.6]);

%% f
DispTau=load('ss_u_fr_f.txt');
u=DispTau(:,3);
tau=DispTau(:,4);
plot([0; u*1e3],[0; -tau*1e-6],lmF{:}); hold on

xy_f=[0 0
    u*1e3 -tau*1e-6];

%% fbp
DispTau=load('ss_u_fr_fbp.txt');
u=DispTau(:,3);
tau=DispTau(:,4);
plot([0; u*1e3],[0; -tau*1e-6],lmFbp{:}); hold on

xy_fbp=[0 0
    u*1e3 -tau*1e-6];
%% axis and legend 

%xlim([1,2.5]);

hl=legend('sMPM','$\bar{F}$-patch');
set(hl,'interpreter','latex','location','northwest');

xlabel('Displacement [mm]');
ylabel('Reaction force [MN]');
set(gca,'FontSize',30);

%% export to pdf
set(hf,'Units','Inches');
pos = get(hf,'Position');
set(hf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(hf,'footing_fr','-dpdf','-r0')

%% save data
xy = [xy_f xy_fbp];
save('fig_footing_small_def_ep.dat','xy','-ascii');
