clear; clc; close all;

h=figure('units','centimeters','outerposition',[5 5 18 18]);
example={'notch_h2', 'notch_h1','notch_h0d5'};

lp = {'k--s','LineWidth',2, 'MarkerSize',13
'k--o','LineWidth',2, 'MarkerSize',13
'k--d','LineWidth',2, 'MarkerSize',13};

xy=[];
isr=[1 2 4 8 16 32]; 
loglog(isr,isr,'k-','LineWidth',2);hold on
for i=1:3
    pt=load(['time_p_' example{i} '.txt']);
    loglog(pt(:,1), pt(1,2)./pt(1:end,2), lp{i,:});
    xy=[xy pt(1:end-1,1) pt(1,2)./pt(1:end-1,2)];
end



axis([0 16 0 16]);

xticks(isr);
yticks(isr);



hl=legend('Ideal','$h$=2','$h$=1','$h$=0.5');
set(hl,'interpreter','latex','location','northwest');

xlabel('Number of processors');
ylabel('Speedup ratio');
set(gca,'FontSize',20);

%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
print(h,'sr_1','-dpdf','-r0');

%% save data
save('fig_sr_notch.dat','xy','-ascii');


% %%
h=figure('units','centimeters','outerposition',[5 5 18 18]);
example={'footing_mm', 'vane_sec','vane_full'};

lp = {'k--s','LineWidth',2, 'MarkerSize',13
'k--o','LineWidth',2, 'MarkerSize',13
'k--d','LineWidth',2, 'MarkerSize',13};

xy=[];
isr=[1 2 4 8 16];
loglog(isr,isr,'k-','LineWidth',2); hold on
for i=1:3
    pt=load(['time_p_' example{i} '.txt']);
    loglog(pt(:,1), pt(1,2)./pt(1:end,2), lp{i,:}); 
    xy=[xy pt(1:end-1,1) pt(1,2)./pt(1:end-1,2)];
end



axis([0 16 0 16]);

xticks(isr);
yticks(isr);



hl=legend('Ideal', 'Footing (large)','Vane (slice)','Vane (full)');
set(hl,'interpreter','latex','location','northwest');

xlabel('Number of processors');
ylabel('Speedup ratio');
set(gca,'FontSize',20);

%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
print(h,'sr_2','-dpdf','-r0');

%% save data
save('fig_sr_others.dat','xy','-ascii');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%
h=figure('units','centimeters','outerposition',[5 5 18 18]);
example={'', '_mppe4','_mppe11'};

lp = {'k--d','LineWidth',2, 'MarkerSize',13
'k--s','LineWidth',2, 'MarkerSize',13
'k--o','LineWidth',2, 'MarkerSize',13};

xy=[];

ids=1:5;

ph=[];
isr=[1 2 4 8 16];
loglog(isr,isr,'k-','LineWidth',2); hold on

for i=3:-1:1
    pt=load(['time_p_vane_sec' example{i} '.txt']);
    ph(i)=loglog(pt(ids,1), pt(1,2)./pt(ids,2), lp{i,:}); hold on
    xy=[xy pt(ids,1) pt(1,2)./pt(ids,2)];
end



axis([0 16 0 16]);

xticks(isr);
yticks(isr);


hl=legend({'Ideal', 'mppe=11','mppe=4','mppe=1'});
set(hl,'interpreter','latex','location','northwest');

xlabel('Number of processors');
ylabel('Speedup ratio');
set(gca,'FontSize',20);

%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)]);
print(h,'sr_3','-dpdf','-r0');

%% save data
save('fig_sr_mppe.dat','xy','-ascii');



    