close all; clc;

h=figure('units','normalized','outerposition',[0.1 0.1 0.5 0.9]);

figa_data_f=[];
figa_data_fbp=[];

lmF={'k--o','LineWidth',1.5,'MarkerSize',15};
lmFbp={'k--x','LineWidth',1.5,'MarkerSize',15};


%id=1:21;
height =4*0.05;
%%
f=load('trqhis_f.txt'); 
plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmF{:});  hold on


f=load('trqhis_fbp_n.txt');
plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmFbp{:});


lmF_mppe1={'--o','LineWidth',3,'MarkerSize',14,'color',[0.5 0.5 0.5]};
lmFbp_mppe1={'--x','LineWidth',3,'MarkerSize',14,'color',[0.5 0.5 0.5]};

height =0.05;
f=load('trqhis_sec_mppe1_f.txt'); 
plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmF_mppe1{:});

f=load('trqhis_sec_mppe1_fbp.txt'); 
plot(f(:,1).*f(:,2), f(:,3)/height*1e-3, lmFbp_mppe1{:});


%% Empirical solution
D=0.1; H=1; cu=10;
TrqMax=pi*D^2*H*cu*0.5;
plot([0 8e-4],[TrqMax TrqMax],'k-','LineWidth',2); 

hl=legend('sMPM (full)','$\bar{F}$-patch (full)','sMPM (slice)','$\bar{F}$-patch (slice)','Estimated empirically');


xlim([0,8e-4]);
xlabel('Vane rotation [rad]');
ylabel('Torque per unit length [kN]');

set(hl,'interpreter','latex','location','southeast');

set(gca,'FontSize',30);

% xlim([0 10]);
% ylim([0 2]);
% 
%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'trq_full','-dpdf','-r0')
% 
% % %% save data
% % save('figa_f.dat','figa_data_f','-ascii');

