close all; clc;

h=figure('units','normalized','outerposition',[0.2 0.2 0.38 0.6]);

figa_data_f=[];
figa_data_fbp=[];

lmF={'k--o','LineWidth',1.5,'MarkerSize',12};
lmFbp={'k--x','LineWidth',1.5,'MarkerSize',12};


%id=1:21;
%%
f=load('ss_utotal_fz_fnorm_rank0_elas_f.txt'); f = [0 0 0 0 0;f];
plot(-f(:,3), -f(:,4)/10^9, lmF{:});  hold on

f=load('ss_utotal_fz_fnorm_rank0_elas_fbp.txt');f = [0 0 0 0 0;f];
plot(-f(:,3), -f(:,4)/10^9, lmFbp{:});


hl=legend('sMPM','$\bar{F}$-patch');

xlabel('Displacement [m]');
ylabel('Reaction force [GN]');

set(hl,'interpreter','latex','location','southeast');

set(gca,'FontSize',30);

xlim([0 1.2]);
ylim([0 8]);


%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'frct_elas','-dpdf','-r0')

% %% save data
% save('figa_f.dat','figa_data_f','-ascii');

