
close all; clc;

h=figure('units','normalized','outerposition',[0.1 0.1 0.5 0.7]);

figa_data_f=[];
figa_data_fbp=[];

lmF={'k--o','LineWidth',1.5,'MarkerSize',12};
lmFbp={'k--x','LineWidth',1.5,'MarkerSize',12};

%fill([0 10 10 0],[0 0 1e-6 1e-6],[.9 .9 .9]); hold on


res = load('residual.txt');
res_step6_f = res(find(res(:,1)==6),3);


step = 1; 
step_start = 1; 
step_its = 0;
for i=1:size(res,1)    
    if(res(i,1) == step)
        step_its = step_its + 1;
    else
        res(step_start:step_start+step_its-1,2) = linspace(step-1,step, step_its);
        pf=semilogy(res([step_start:step_start+1 step_start+3:step_start+step_its-1],2), res([step_start:step_start+1 step_start+3:step_start+step_its-1],3), lmFbp{:}); hold on
        figa_data_f = [figa_data_f; res(step_start:step_start+step_its-1,2)  res(step_start:step_start+step_its-1,3)];
        
        step_start = i;
        step = step + 1;
        step_its = 0; 
        
    end
end

        
%hl=legend([pf pfbp],{'sMPM', '$\bar{F}$-patch'});
%set(hl, 'interpreter', 'latex','location','southeast');

set(gca,'FontSize',25);
xlabel('Load step');
ylabel('$\left|\left| f^{oobf} \right|\right|$','interpreter','latex');
xlim([180 195])
%axis([0 6 1e-10 1e+4]);        


%% write to a pdf
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'converge_NR','-dpdf','-r0')

%% save data
save('figa_f.dat','figa_data_f','-ascii');
save('figa_fbp.dat','figa_data_fbp','-ascii');

