import numpy
import pandas
from sympy.parsing import mathematica
from sympy import *
import scipy.constants as constants
from types import LambdaType
import os
from scipy.linalg import block_diag

cwd = os.path.dirname(os.path.abspath(__file__))
#pi = numpy.pi
#c = constants.c
#h = constants.h
#eps0 = constants.epsilon_0
def Generate_Hamiltonian_Stark():
    file = numpy.loadtxt(cwd+"\\HamiltonianStark.dat",dtype=str,delimiter=',')
    Ham = numpy.empty(file.shape,dtype=LambdaType)
    phi = Symbol('Phi')
    a0 = Symbol('a0')
    a2 = Symbol('a2')
    I = Symbol('Int')
    E = Symbol('EDC')
    eps0 = Symbol('eps0')
    SOL = Symbol('c')
    Rot = Symbol('B')
    Dipole = Symbol('d0')
    Dist = Symbol('Dv')
    Vars = (eps0,SOL,E,I,phi,a0,a2,Rot,Dist,Dipole)
    test = numpy.zeros(len(Vars))+1
    for i in range(len(file[:,0])):
        for j in range(len(file[0,:])):
            #print(file[i,j])
            Ham[i,j] = lambdify(Vars,mathematica.mathematica(file[i,j]),"numpy")
    return Ham

def Generate_Hamiltonian_Stark2():
    file = numpy.loadtxt(cwd+"\\HamiltonianStark2beams.dat",dtype=str,delimiter=',')
    Ham = numpy.empty(file.shape,dtype=LambdaType)
    phi1 = Symbol('Phi1')
    phi2 = Symbol('Phi2')
    a0 = Symbol('a0')
    a2 = Symbol('a2')
    I1 = Symbol('Int1')
    I2 = Symbol('Int2')
    E = Symbol('EDC')
    eps0 = Symbol('eps0')
    SOL = Symbol('c')
    Rot = Symbol('B')
    Dipole = Symbol('d0')
    Dist = Symbol('Dv')
    imag = Symbol('i')
    Vars = (imag,eps0,SOL,E,I1,I2,phi1,phi2,a0,a2,Rot,Dist,Dipole)
    test = numpy.zeros(len(Vars))+1
    for i in range(len(file[:,0])):
        for j in range(len(file[0,:])):
            #print(file[i,j])
            Ham[i,j] = lambdify(Vars,mathematica.mathematica(file[i,j]),"numpy")
    return Ham
	
def Generate_Hamiltonian_Stark_Arb():
    file = numpy.loadtxt(cwd+"\\HamiltonianStark_2BeamArb.dat",dtype=str,delimiter=',')
    Ham = numpy.empty(file.shape,dtype=LambdaType)
	
    phi1 = Symbol('Phi1')
    phi2 = Symbol('Phi2')
	
    a0 = Symbol('a0')
    a2 = Symbol('a2')
	
    I1 = Symbol('Int1')
    I2 = Symbol('Int2')
	
    E = Symbol('EDC')
	
    eps0 = Symbol('eps0')
	
    SOL = Symbol('c')
    Rot = Symbol('B')
	
    Dipole = Symbol('d0')
    Dist = Symbol('Dv')
    imag = Symbol('i')
	
    angle = Symbol('Ang')
    Vars = (imag,eps0,SOL,E,I1,I2,angle,phi1,phi2,a0,a2,Rot,Dist,Dipole)
    test = numpy.zeros(len(Vars))+1
    for i in range(len(file[:,0])):
        for j in range(len(file[0,:])):
            #print(file[i,j])
            Ham[i,j] = lambdify(Vars,mathematica.mathematica(file[i,j]),"numpy")
    return Ham
	
def Generate_Hamiltonian_Stark6():
    file = numpy.loadtxt(cwd+"\\HamiltonianStark2beams.dat",dtype=str,delimiter=',')
    Ham = numpy.empty(file.shape,dtype=LambdaType)
    phi1 = Symbol('Phi1')
    phi2 = Symbol('Phi2')
    phi3 = Symbol('Phi3')
	
    a0 = Symbol('a0')
    a2 = Symbol('a2')
	
    I1 = Symbol('Int1')
    I2 = Symbol('Int2')
    I3 = Symbol('Int3')
	
    E = Symbol('EDC')
    eps0 = Symbol('eps0')
	
    SOL = Symbol('c')
    Rot = Symbol('B')
    Dipole = Symbol('d0')
    Dist = Symbol('Dv')
    imag = Symbol('i')
	
    Vars = (imag,eps0,SOL,E,I1,I2,I3,phi1,phi2,phi3,a0,a2,Rot,Dist,Dipole)
    test = numpy.zeros(len(Vars))+1
    for i in range(len(file[:,0])):
        for j in range(len(file[0,:])):
            #print(file[i,j])
            Ham[i,j] = lambdify(Vars,mathematica.mathematica(file[i,j]),"numpy")
    return Ham
	
def Generate_Hamiltonian_HF(Nmax):
    I = Symbol('I')
    Q1 = Symbol('QRb')
    Q2 =Symbol('QCs')
    c1=Symbol('cRb')
    c2=Symbol('CCs')
    c3=Symbol('c3')
    c4=Symbol('c4')
    muN = Symbol("muN")
    mag = Symbol('B')
    H =[]
    Vars = (I,mag,c1,c2,c3,c4,Q1,Q2,muN)
    for N in range(0,Nmax+1):
        file = numpy.loadtxt(cwd+"\\HamiltonianHFN{:.0f}".format(N)+".dat",
                            dtype=str,delimiter=',')
        Ham = numpy.empty(file.shape,dtype=LambdaType)

        for i in range(len(file[:,0])):
            for j in range(len(file[0,:])):
                #print(file[i,j])
                Ham[i,j] = lambdify(Vars,mathematica.mathematica(file[i,j]),
                                    "numpy")
        H.append(Ham)
    Ham = block_diag(*H)
    return Ham

if __name__ =="__main__":
	H = Generate_Hamiltonian_HF(5)
