set terminal postscript enhanced color eps
set output 'Ldisth.eps'
set size 0.6,0.6
unset key
set format x "%2.1f" 
set format y "10^{%T}"
set xtics (-0.6,0,0.6)
set palette rgbformulae 7,5,15
set style data lines
set xrange[-0.6:0.6]
set yrange[0.002:2.0]
set logscale y
set xlabel 'strain'
set ylabel 'P(strain - solidlike band), stress decay'
plot for [fn in system("ls Ldisth[1-2,5].dat")]fn using 1:($3/1000) w lines lw 6, for [fn in system("ls Ldisth[1]0.dat")]fn using 1:($3/1000) w lines lw 6, 'Ldisth20b.dat' using 1:($3/1000) w lines lw 6,'Ldisth50.dat' using 1:($3/1000) w lines lw 6 lc rgbcolor 'red'
set output 'Ldisth2.eps'
set ylabel 'P(strain - solidlike band), stress increase'
plot for [fn in system("ls Ldisth100.dat")]fn using 1:($3/1000) w lines lw 6,for [fn in system("ls Ldisth200.dat")]fn using 1:($3/1000) w lines lw 6, for [fn in system("ls Ldisth500.dat")]fn using 1:($3/1000) w lines lw 6,  for [fn in system("ls Ldisth1000.dat")]fn using 1:($3/1000) w lines lw 6
