unset key
unset logscale x
unset logscale y
set xrange[0.0:0.35]
set yrange[-0.05:1.6]
set format x "%4.1f"
set format y "%4.1f"
set style data lines
set terminal postscript color eps 
set termoption dashed
set xlabel 'average strain rate'
set ylabel 'nonmonotonicity parameter'
set output 'maxmin.eps'
set size 0.6, 0.4
if (GPVAL_VERSION >= 5.0) set for [i=1:6] linetype i dashtype 1
if (GPVAL_VERSION >= 5.0) set for [i=7:12] linetype i dashtype 2 
set tics font "Helvetica,18"
set xtics 0.0, 0.1, 0.4
set ytics 0.0,0.4
set ytics offset 0,graph 0.01
set xtics offset 0,graph -0.02 
set style data lines
plot 'a4.dataset3' using 2:3 lw 3 lc 7 dt 1, 'a2.dataset3' using 2:3 lw 3 lc 2 dt 1, 'a8.dataset3' using 2:3 lw 3 lc 4 dt 1, 'a16.dataset3' using 2:3 lw 3 lc 8 dt 1, 'a2.dataset1' using 2:3 lw 3 lc 2, 'a4.dataset1' using 2:3 lw 3 lc 7, 'a8.dataset1' using 2:3 lw 3 lc 4 dt 1, 'a16.dataset1' using 2:3 lw 3 lc 8 dt 1, 'a2.dataset2' using 2:3 lw 3 lc 2 dt 2, 'a4.dataset2' using 2:3 lw 3 lc 7 dt 2, 'a8.dataset2' using 2:3 lw 3 lc 4 dt 2, 'a16.dataset2' using 2:3 lw 3 lc 8 dt 2, 'a4.dataset3' using 2:3 lw 3 lc 7 dt 1, 'strainrate0.16.16' using 1:3 with points pt 7 ps 1.5 lw 5 lc 8, 'strainrate0.16.8' using 1:3 with points pt 7 ps 1.5 lw 5 lc 4, 'strainrate0.16.4' using 1:3 with points pt 7 ps 1.5 lw 5 lc 7, 'strainrate0.16.2' using 1:3 with points pt 7 ps 1.5 lw 5 lc 2, 'a0.dataset' using 3:2 lw 3 lc 1 dt 1,  'a1.dataset' using 3:2 lw 3 lc 14 dt 1 
