#!/bin/bash
#
gfortran -c initialise.f90
gfortran -c simulate.f90
gfortran -Og -Wall -fcheck=all -fbacktrace -fbounds-check -o simulate initialise.o simulate.o

#Parameters are in parameters.dat
#e.g. nbands=100

#For the flow curve in fig1a - strainremoval=FALSE
#For flow cessation, strainremoval=TRUE 
strainremoval=TRUE

#for i in {1..10} #multiple repetitions with the same variables
for i in 0 #repetitions
do
#for s in 0.04 0.08 0.12 0.16 0.20 0.24 #Applied strain rate before flow cessation
for s in 0.16 #strain rate - sr
do
#for x in 0.3 #noise parameter or effective temperature without elastic energy contribution	
for x in 0.3 #base temperature - x
do 
#for a in 0.0 1.0 2.0 4.0 8.0 16.0 #parameter determining the magnitude of elastic energy contribution
for a in 8.0 #coupling parameter - a
do 
#for xdecayt in '100.0D0' '1.0D0' #Time for continuing effect of released elastic energy/temperature  
for xdecayt in '100.0D0' #delay time for x decay - taux 
do
#for fixsr in 'TRUE' 'FALSE' #true for a homogeneous system, no temperature variations within system
for fixsr in 'TRUE' 'FALSE' #true for a homogeneous system
do
	echo -n "" > tempparameters.dat
	dirname="sgr.$i"
	while read line;
        do
        if [[ "$line" =~ ' x -' ]]; then
          echo $x >>tempparameters.dat
	   dirname="${dirname}.x.$x"
        elif [[ "$line" =~ ' xdecayt -' ]]; then
          echo $xdecayt >>tempparameters.dat
	   dirname="${dirname}.xdecayt.$xdecayt"
        elif [[ "$line" =~ ' a -' ]]; then
          echo $a >>tempparameters.dat
	   dirname="${dirname}.a.$a"
        elif [[ "$line" =~ ' sr -' ]]; then
          echo $s >>tempparameters.dat
 	   dirname="${dirname}.sr.$s"
        elif [[ "$line" =~ ' fixsr -' ]]; then
          echo $fixsr >>tempparameters.dat
	  if [ "$fixsr" == TRUE ]; then
 	   dirname="${dirname}.homo"
          fi
        elif [[ "$line" =~ ' STRAINREMOVAL -' ]]; then
          echo $strainremoval >>tempparameters.dat
	  if [ "$strainremoval" == TRUE ]; then
 	   dirname="${dirname}.flowcess"
	  else
 	   dirname="${dirname}.steadystate"
          fi
        else
        echo $line >>tempparameters.dat
        fi
        done  <"$1"
        echo $s >sr.dat
	mkdir -p ./$dirname
	cp tempparameters.dat ./$dirname/parameters.dat
	rm ./$dirname/out
	rm ./$dirname/stress*
	cp simulate.f90 initialise.f90 simulate ./$dirname
	cd $dirname
         echo 'job running'    
         ./simulate >out & 
        cd ..
done
done
done
done
done
sleep 3.2
done
