set terminal postscript enhanced color eps size 10,3.2 
set output 'stress.colours.eps'
set size 0.6, 0.6
set logscale x
set logscale y
set format x "10^{%T}"
set xrange[0.8:2000]
set style data lines
set palette rgbformulae 7,5,15
set format y "10^{%T}"
unset key
set linetype 6 lc rgbcolor "red"
set linetype 8 lc 4  
set linetype 9 lc 1  
set linetype 10 lc 2  
set linetype 11 lc 3  
set xlabel 'time'
set ylabel 'stress'
plot for [fn in system("ls stress[0,1-2,5].dat")]fn u ($1-1000):2 w points pt 2 ps 2 lw 5, for [fn in system("ls stress[1-2,5]0.dat")]fn using ($1-1000):2 with points pt 2 ps 2 lw 5 ,  'stress0.08000.dat' using ($1-1000):2 with lines lw 10 lt 1, for [fn in system("ls stress[1-5]00*.dat")]fn u ($1-1000):2 w points pt 4 ps 2 lw 5
