set terminal postscript enhanced color eps size 4.5, 2.8
unset key
set output 'avmaxmin.t.eps'
set tics font "Helvetica,24"
set size 0.6, 0.9
#unset mxtics
unset mytics
#set xtics offset -0.05,graph -0.015
#set format x "10^{%T}"
set format x "%2.0f"
set format y "%4.1f"
set ylabel 'nonmonotonicity parameter'
set xlabel 'a'
set yrange[0:2.8]
set ytics offset 0,graph 0.01
set xtics offset 0,graph -0.02
#set ytics (1,2,4,8,10,16)
set ytics (0.0, 1.0, 2.0,3.0)
unset colorbox
set style data linespoints
#set palette rgbformulae 7,5,15
set palette rgbformulae -7,-5,-15 
plot 'avmaxmin.t.out' using 1:3:2 lc palette lw 5, 'a16.taux100' using 1:3 with points pt 7 ps 2 lw 5 lc 8, 'a8.taux100' using 1:3 with points pt 7 ps 2 lw 5 lc 4, 'a4.taux100' using 1:3 with points pt 7 ps 2 lw 5 lc 7, 'a2.taux100' using 1:3 with points pt 7 ps 2 lw 5 lc 2

