set terminal postscript enhanced color eps size 4.5, 2.8
unset key
set tics font "Helvetica,24"
set size 0.6, 0.9
set logscale x        
unset mytics
unset mxtics
set xtics offset -0.05,graph -0.03
set format x "10^{%T}"
set format y "%4.1f"
set yrange[0:2.8]
set xlabel 'taux'
set ylabel 'nonmonotonicity parameter'
set ytics offset 0,graph 0.01
set ytics (0.0, 1.0, 2.0,3.0)
unset colorbox
set style data linespoints
set palette rgbformulae -7,-5,-15 
set output 'avmaxmin.a.eps'
set xrange[1:10000]
plot 'avmaxmin.a.out' using 2:3:1 lc palette lw 5, 'taux100.a16' using 1:3 with points pt 7 ps 2 lw 5 lc 8, 'taux100.a8' using 1:3 with points pt 7 ps 2 lw 5 lc 4, 'taux100.a4' using 1:3 with points pt 7 ps 2 lw 5 lc 7, 'taux100.a2' using 1:3 with points pt 7 ps 2 lw 5 lc 2

