PROGRAM SIMULATE 
! A simplified flow-cessation sgr code
  USE INITIALISE 
  IMPLICIT NONE
  INTEGER, ALLOCATABLE :: nevents(:)  
  INTEGER, PARAMETER :: LargeInt_K=selected_int_kind (18)
  INTEGER (kind=LargeInt_K) :: ntimed, time 
  INTEGER :: i,j,j1,j2,k,ni, nprintfreqsave 
  INTEGER :: isl, p, ntimeeq, naddtime, ncessflow, nstressrecs
  INTEGER :: smint, smaxt, lower, upper, naddtime2 
  REAL (KIND=8), ALLOCATABLE ::  tevents(:), xbandssave(:) 
  REAL (KIND=8), ALLOCATABLE ::  sfact(:), sfactsave(:)
  REAL (KIND=8), ALLOCATABLE :: xtom(:) 
  REAL (KIND=8) :: Stress, deltay, rconst, rc, atom, btom, ctom 
  REAL (KIND=8) :: Sigma1, Sigma, srsave, xdecaysave, addtime
  REAL (KIND=8) :: smin, smax, deltatsave, totalstress 
  LOGICAL :: STRAINREMOVE, XEQ

! Target Output
! Parameters for tracking the minimum and maximum stress during flow cessation  
  smin=100.0D0
  smax=0.0D0
  smint=0
  smaxt=1000000000
! Parameters for calculating the steady state stress for flow curves (no flow cessation)  
  totalstress=0.0D0
  nstressrecs=0

! Initialise seed for random number generator  
  CALL SEEDING

! Initialise variables and read parameters from parameters.dat file 
  CALL GETPARAMETERS 
  CALL ALLOCATEARRAYS(sr)

! Initialise trap energies from an exponential distribution
        ni=1
        DO WHILE (ni<(Ntot+1)) 
                CALL NOZERORANDOM(ran)
                E(ni)=-LOG(ran) 
                ni=ni+1 
        ENDDO

! Parameters needed for relaxation/diffusion equation for x          
                ALLOCATE(xbandssave(nbands))
                ALLOCATE(xtom(nbands))
                ALLOCATE(sfact(nbands))
                ALLOCATE(sfactsave(nbands))
                ALLOCATE(nevents(nbands))
                ALLOCATE(tevents(nbands))
                deltay=1.0D0/nbands
                xbandssave(:)=0.0D0
                sfact(:)=0.0D0
                XEQ=.TRUE. ! Instant decay during flow

! Calulate the total number of timesteps required 
! ntimed is the numbers of steps, (time of strain rate application)/timestep (+ flow cessation + time at high strain)
        ntimed=ntime/deltat   
        STRAINREMOVE=.FALSE.
        ntimeeq=ntimed
        srsave=sr
        nhighs=nhighs/deltat
        IF(HIGHSTRAIN) THEN
                ntimed=ntimed+nhighs ! Add time for high strain start if applicable
                sr=10.0D0
        ENDIF 
        ntimecess=ntimecess/deltat
        ncessflow=ntimed
        IF(strainremoval) THEN
                ntimed=ntimed+ntimecess ! Add time after strain removal if applicable
                STRAINREMOVE=.TRUE.
        ENDIF        
        srSL(:)=sr
       
! Save initial parameters: printing frequency, timestep and x decay time        
        nprintfreqsave=nprintfreq 
        IF(xdecayt.lt.deltat) THEN ! The decay time for x must be larger than zero
           xdecayt=deltat          ! Set the minimum value as the simulation timestep
           PRINT*, 'The decay time for x has been reset to the minimum value, the timestep ', deltat 
        ENDIF
        xdecaysave=xdecayt  
        deltatsave=deltat

! Parameters for keeping track of time elapsed
        addtime=0.0D0
        naddtime=nhighs
        naddtime2=ncessflow+10000000

! Main loop over timesteps        
        DO time=0,ntimed
        
! Apply High strain initialisation         
         IF(HIGHSTRAIN) THEN
                IF(time.le.nhighs) THEN
                        sr=10.0D0
                        IF(fixsr) srSL(:)=sr 
                ELSE IF(time.eq.(nhighs+1)) THEN
                        sr=srsave
                        srSL(:)=sr
                ENDIF
         ENDIF
          
! Apply Flow cessation         
         IF(STRAINREMOVE.and.time.gt.(ncessflow)) THEN
                sr=0.0D0
                IF(fixsr) srSL(:)=sr 
         ENDIF

! Adjust printing frequency         
          IF(time.eq.ncessflow) nprintfreq=10
          IF(time.eq.(ncessflow+10000)) nprintfreq=nprintfreqsave
          IF((time.gt.ncessflow).and.((time-ncessflow)/float(nprintfreq).gt.100.0D0)) nprintfreq=nprintfreq*10
          IF(time.eq.(naddtime2)) THEN
           addtime=naddtime2*deltat
           naddtime=naddtime2
           deltat=0.01
          ENDIF

         
! Cycle over each element, apply strain rate and calculate plastic relaxation rates         
         Stress=0.0D0
         StressSL(:)=0.0D0
         IintSL(:)=0.0D0
         DO j1=1,nbands
         DO j2=1,N
            j=(j1-1)*N+j2
            L(j)=L(j)+srSL(j1)*deltat
            Stress=Stress+L(j)
            StressSL(j1)=StressSL(j1)+L(j)  
            r(j)=MIN(EXP((0.5D0*L(j)**2-E(j))/xbands(j1)),1.0D0)
            IintSL(j1)=IintSL(j1)+L(j)*r(j)  
         ENDDO
         ENDDO

         Stress=Stress/FLOAT(Ntot)

! Print stress and check for minimum and maximum        
         IF((time.ge.nhighs).and.(MOD(time,nprintfreq).eq.0)) THEN
                IF (STRAINREMOVAL) THEN
                  WRITE(71,*) (time-naddtime)*deltat+addtime, Stress 
                  IF(time.ge.(ncessflow+((xdecayt*2)/deltat))) THEN
                    IF(stress.gt.smax) THEN
                        smax=stress
                        smaxt=(time-ntimeeq-nhighs)
                    ELSE
                        IF((time-ntimeeq-nhighs).gt.(smaxt*2).and.((smax-smin)/smin).gt.2.0D0) EXIT
                    ENDIF 
                  ELSE IF(time.ge.(ncessflow)) THEN
                    IF(stress.lt.smin) THEN
                        smin=stress 
                        smint=(time-ntimeeq-nhighs)
                    ENDIF 
                  ENDIF    
                ELSE
                  IF(time.ge.(ntimed-ntimeeq*(3.0D0/4.0D0))) THEN
                  nstressrecs=nstressrecs+1
                  totalstress=totalstress+Stress
                  ENDIF
                  Sigma=STRESS+viscosity*sr  
                  WRITE(71,*) ((time-naddtime)*deltat+addtime)*sr, Stress, Sigma 
                ENDIF
         ENDIF

! Print streamline information
         IF(PRINTSL) THEN
         IF(((time.ge.nhighs).and.(MOD(time,nprintfreq).eq.0)).OR.(time.eq.ncessflow)) THEN
          DO isl=1,nbands
           NUNIT=100+isl
           Sigma1=StressSL(isl)/FLOAT(N)+viscosity*SrSL(isl)    
           WRITE(NUNIT,*) (time-naddtime)*deltat+addtime, stressSL(isl)/N,srSL(isl), xbands(isl), IintSL(isl)/N,Sigma1 
          ENDDO 
         ENDIF 
         ENDIF 

! Cycle over all elements, checking for plastic relaxation        
         nevents(:)=0
         tevents(:)=0.0D0
         DO j1=1,nbands
         DO j2=1,N
            j=(j1-1)*N+j2
            CALL RANDOM_NUMBER(ran)
            IF(r(j)*deltat.gt.ran) THEN
                CALL NOZERORANDOM(ran)
                E(j)=-LOG(ran)
                L(j)=0.0D0
            ENDIF        
            nevents(j1)=nevents(j1)+1
            tevents(j1)=tevents(j1)+r(j)*(L(j)**2)
         ENDDO
         ENDDO
         
! What do we do at the end of the timestep :)
           DO j1=1,nbands
              IF(.not.fixsr) THEN
                 srSL(j1)=((STRESS+viscosity*sr)-StressSL(j1)/FLOAT(N))/viscosity
              ENDIF
              IF(nevents(j1).gt.0) tevents(j1)=tevents(j1)/float(nevents(j1)) 
               sfactsave(j1)=sfact(j1) 
               sfact(j1)=a*tevents(j1) 
           ENDDO
! x decay time is artifically small at start, set to target halfway through strain application           
           IF(XEQ) THEN
                 IF(time.lt.(ncessflow-ntimeeq/2.0D0)) THEN
                      xdecayt=deltat
                 ELSE
                      xdecayt=xdecaysave 
                 ENDIF
           ENDIF
! Solve the relaxation/diffusion equation for x if more than one streamline          
           IF(nbands.gt.1) THEN      
               rc=(deltat*lambda**2)/(2.0D0*xdecayt*deltay**2)
               rconst=deltat/(2.0D0*xdecayt)
            DO j1=1,nbands
               lower=j1-1
               upper=j1+1
               IF(j1.eq.1) lower=nbands
               IF(j1.eq.nbands) upper=1
               xtom(j1)=(1.0D0-rconst-2.0D0*rc)*xbandssave(j1)+rc*(xbandssave(upper)+xbandssave(lower))
               xtom(j1)=xtom(j1)+rconst*(2.0D0*x0+sfact(j1)+sfactsave(j1)) 
            ENDDO
               atom=-rc
               ctom=-rc
               btom=1.0D0+rconst+2.0D0*rc
               CALL CYCLIC_THOMAS(xtom,atom,btom,ctom,nbands)
               xbands(:)=xtom(:) 
               xbandssave(:)=xbands(:)
           ENDIF   
        ENDDO
        CLOSE(71)
       IF(strainremoval) THEN
        WRITE(6,*) 'Nonmonotonicity parameter (log10(max stress/minstress)), calculated in flow cessation'
        IF(smint.eq.0) THEN
         WRITE(6,*) 'x0,a,x decay time,strain rate, [No minimum in stress, decay is monotonic]' 
         WRITE(6,'(3F7.2,F9.4,1E15.7E2)') x0,a,xdecayt,srsave, smint*deltatsave 
        ELSE        
         WRITE(6,*) 'x0,a,x decay time,strain rate,nonmonotonicity parameter,minimum,maximum,time at minimum,time at maximum' 
         WRITE(6,'(3F7.2,F9.4,3E15.7E2,2F12.1)') x0,a,xdecayt,srsave,log10(smax/smin),smin,smax,smint*deltatsave,smaxt*deltatsave 
        ENDIF
       ELSE
        WRITE(6,*) 'Stress averaged over last quarter of trajectory, required for steady state value' 
        WRITE(6,*) 'x0,a,x decay time,strain rate, steady state stress' 
        WRITE(6,'(3F7.2,F9.4,E15.7E2)') x0,a,xdecayt,srsave,totalstress/nstressrecs 
       ENDIF
        DEALLOCATE(StressSL) 
        DEALLOCATE(IintSL) 
        DEALLOCATE(srSL) 
          DO isl=1,nbands
             NUNIT=100+ib
             CLOSE(NUNIT)
          ENDDO 
END PROGRAM simulate

SUBROUTINE SEEDING
  INTEGER :: i_seed 
  INTEGER, DIMENSION(:), ALLOCATABLE :: a_seed
  INTEGER, DIMENSION(1:8) :: dt_seed
  CALL RANDOM_SEED(size=i_seed)
  ALLOCATE(a_seed(1:i_seed))
  CALL RANDOM_SEED(get=a_seed)
  CALL DATE_AND_TIME(values=dt_seed)
  a_seed(i_seed)=dt_seed(8); a_seed(1)=dt_seed(8)*dt_seed(7)*dt_seed(6)
  CALL RANDOM_SEED(put=a_seed)
  DEALLOCATE(a_seed)
  RETURN
END SUBROUTINE SEEDING

SUBROUTINE DEFINEDSEEDING
  INTEGER :: i_seed, k 
  INTEGER, DIMENSION(:), ALLOCATABLE :: a_seed
  INTEGER, DIMENSION(1:8) :: dt_seed
  CALL RANDOM_SEED(size=i_seed)
  ALLOCATE(a_seed(1:i_seed))
  CALL RANDOM_SEED(get=a_seed)
  do k=1,i_seed  
        a_seed(k)=k
  enddo
  CALL RANDOM_SEED(put=a_seed)
  DEALLOCATE(a_seed)
  RETURN
END SUBROUTINE DEFINEDSEEDING

SUBROUTINE CYCLIC_THOMAS(x,a,b,c,nbands)
 IMPLICIT NONE
 REAL (KIND=8) :: alpha, beta, gam, m, fact, a, b, c
 REAL (KIND=8), DIMENSION(1:nbands),  INTENT(INOUT) :: x
 REAL (KIND=8), DIMENSION(:), ALLOCATABLE :: u, z
 INTEGER nbands, i, j

 ALLOCATE(z(nbands))
 ALLOCATE(u(nbands))
 alpha=a
 beta=c

 gam=-b

 z(1)=alpha/(b-gam)
 u(1)=gam/(b-gam)
 x(1)=x(1)/(b-gam)

 DO i=2, nbands-1
  m=1.0/(b-a*z(i-1))
  z(i)=c*m
  u(i)=(0.0D0-a*u(i-1))*m
  x(i)=(x(i)-a*x(i-1))*m
 ENDDO

 m=1.0D0/(b-alpha*beta/gam-beta*z(nbands-1))
 u(nbands)=(alpha-a*u(nbands-1))*m
 x(nbands)=(x(nbands)-a*x(nbands-1))*m

 DO i=nbands-1, 1, -1
  u(i)=u(i)-z(i)*u(i+1)
  x(i)=x(i)-z(i)*x(i+1)
 ENDDO

 fact=(x(1)+x(nbands)*beta/gam)/(1.0D0+u(1)+u(nbands)*beta/gam)
 
DO  i=1,nbands
 x(i)=x(i)-fact*u(i)
ENDDO

END SUBROUTINE 

!X=nbands 
!cmod=z
!gamma=gam
