MODULE INITIALISE
  IMPLICIT NONE
  INTEGER :: srnum, N,Ntot,isr, ib, fnew, nsave
  INTEGER :: Allocatestatus, NTEMP, nbands, NUNIT
  INTEGER, PARAMETER :: LargeInt_J=selected_int_kind (18)
  INTEGER (kind=LargeInt_J) :: ntime, ntimecess, nhighs, nprintfreq 
  REAL (KIND=8), DIMENSION(:), ALLOCATABLE :: E, L, Lup,  r 
  REAL (KIND=8), DIMENSION(:), ALLOCATABLE :: stressSL, srSL, xbands, IintSL
  REAL (KIND=8) :: deltat, x, ran, sr, sstrain, x0, a, viscosity 
  REAL (KIND=8) :: xswitch 
  REAL (KIND=8) :: lambda, xdecayt
  CHARACTER(len=50) :: bfile_id, ffile_id, file_id, file_name
  LOGICAL :: AtEnd, bands, strainremoval
  LOGICAL :: fixsr, allpx, PRINTSL 
  LOGICAL :: HIGHT, HIGHSTRAIN
  LOGICAL, ALLOCATABLE :: xhigh(:)
 

  CONTAINS
        SUBROUTINE GETPARAMETERS
          IMPLICIT NONE
! Set defaults, reset to desired values using parameters.dat files

! Basic setup: Timestep, particles,streamlines,x
        OPEN(unit=10, file='parameters.dat', STATUS='OLD', ACTION='READ')
          READ(10,*) 
          READ(10,*) deltat     !0.001D0        Timestep
          READ(10,*) x          !0.3D0          x0/Base Temperature parameter
          READ(10,*) sr         !0.01D0         Strain rate 
          READ(10,*) ntime      !1000           Total time for the flow simulation 
          READ(10,*) N          !1000           Number of atoms per streamline
          READ(10,*) bands      !true           Streamlines T/F
          READ(10,*) nbands     !100            Number of streamlines
          READ(10,*) 

         x0=x
         IF(bands) THEN
           NTOT=N*nbands
         ELSE
           NTOT=N
           nbands=1
         ENDIF
         ALLOCATE(xbands(nbands))
         xbands(:)=x0 

! Initialisation and/or cessation (protocol)
          READ(10,*) 
          READ(10,*) HIGHSTRAIN !TRUE           Start with high strain 
          READ(10,*) nhighs     !1000           Number of timesteps of high strain
          READ(10,*) strainremoval      !TRUE   Strain cessation
          READ(10,*) ntimecess  !1000000        Number of timesteps of strain cessation
          READ(10,*) 

! Heterogeneity/frustration          
          READ(10,*) 
          READ(10,*) a          !2.0D0          Parameter for varying x
          READ(10,*) fixsr      !FALSE          Bands but homogeneous, no variation in strain rate
          READ(10,*) viscosity  !0.05D0         Viscosity for force balance between streamlines
          READ(10,*) xswitch    !0.6D0          x cutoff for identifying high and low strain rate bands - x-dependent
          READ(10,*) allpx      !TRUE           Use all elements, should always be true
          READ(10,*) 

! Printing and testing
          READ(10,*) 
          READ(10,*) nprintfreq         !1000   Frequency of printing. Careful as lots of data can easily be produced
          READ(10,*) AllocateStatus     !0      Used for memory check
          READ(10,*) xdecayt          !10.0D0   Delay time for x decay
          READ(10,*) lambda          !0.005D0   Parameter for width of interface between bands
          READ(10,*) PRINTSL          !TRUE     Print stress for each streamline
         
        CLOSE(10)

        END SUBROUTINE GETPARAMETERS

        SUBROUTINE ALLOCATEARRAYS(slabels)
                IMPLICIT NONE 
                REAL (KIND=8) :: slabels

!         Open main output file, stress.*.dat
           WRITE(file_id, '(F9.5)') slabels
           file_name = 'stress' // trim(adjustl(file_id)) // '.dat'
           OPEN(file = trim(file_name), unit=71)
!         Open files for automation
           OPEN(file='xvalues', unit=55)

!         Allocate E, l, r, Lup arrays
          ALLOCATE(E(1:Ntot), STAT = AllocateStatus)
           IF (AllocateStatus /= 0) STOP "*** Not enough memory ***"
          ALLOCATE(l(1:Ntot), STAT = AllocateStatus)
           IF (AllocateStatus /= 0) STOP "*** Not enough memory ***"
          ALLOCATE(r(1:Ntot), STAT = AllocateStatus)
           IF (AllocateStatus /= 0) STOP "*** Not enough memory ***"
          ALLOCATE(Lup(1:Ntot), STAT = AllocateStatus)
           IF (AllocateStatus /= 0) STOP "*** Not enough memory ***"
!         Initialise E, L, r, Lup arrays  
                E(:)=0.0D0
                L(:)=0.0D0
                Lup(:)=0.0D0
                r(:)=0.0D0

!        Open output files and initialise arrays for streamlines
               IF(PRINTSL) THEN
                  DO ib=1,nbands 
                    WRITE(bfile_id, '(I5)') ib 
                    file_name = 'stress' // trim(adjustl(file_id)) //'.'//trim(adjustl(bfile_id))// '.dat'
                    NUNIT=100+ib
                    OPEN(file=trim(file_name), unit=NUNIT)
                  ENDDO
               ENDIF

                  ALLOCATE(StressSL(1:nbands)) 
                  ALLOCATE(IintSL(1:nbands)) 
                  ALLOCATE(srSL(1:nbands)) 
                  StressSL(:)=0.0D0 
                  IintSL(:)=0.0D0 
                  srSL(:)=0.0D0 

        END SUBROUTINE ALLOCATEARRAYS 
        
        SUBROUTINE NOZERORANDOM(rran)
          IMPLICIT NONE
          REAL (KIND=8) rran
          DO
            CALL RANDOM_NUMBER(rran)
            IF(rran.eq.0) THEN; CYCLE; ENDIF
            EXIT
          ENDDO
        END SUBROUTINE NOZERORANDOM

SUBROUTINE REALL_1D(a, ni_new)
  INTEGER, DIMENSION(:), ALLOCATABLE, INTENT(INOUT) :: a
  INTEGER, DIMENSION(:), ALLOCATABLE :: temp
  INTEGER, INTENT(IN) :: ni_new
  INTEGER :: ni_old

  ni_old=SIZE(a)
  ALLOCATE(temp(ni_new))
  temp(:)=0
  temp(1:ni_old)=a
  CALL MOVE_ALLOC(temp,a)

END SUBROUTINE REALL_1D

SUBROUTINE NEG_REALL_1D(a, ni_new)
  INTEGER, DIMENSION(:), ALLOCATABLE, INTENT(INOUT) :: a
  INTEGER, DIMENSION(:), ALLOCATABLE :: temp
  INTEGER, INTENT(IN) :: ni_new
  INTEGER :: ni_old

  ni_old=NINT((SIZE(a)-1.0D0)/2.0D0)
  ALLOCATE(temp(-ni_new:ni_new))
  temp(:)=0
  temp(-ni_old:ni_old)=a
  CALL MOVE_ALLOC(temp,a)

END SUBROUTINE NEG_REALL_1D

SUBROUTINE NEG_REALL_1Dr(a, ni_new)
  REAL, DIMENSION(:), ALLOCATABLE, INTENT(INOUT) :: a
  REAL, DIMENSION(:), ALLOCATABLE :: temp
  INTEGER, INTENT(IN) :: ni_new
  INTEGER :: ni_old

  ni_old=NINT((SIZE(a)-1.0D0)/2.0D0)
  ALLOCATE(temp(-ni_new:ni_new))
  temp(:)=0
  temp(-ni_old:ni_old)=a
  CALL MOVE_ALLOC(temp,a)

END SUBROUTINE NEG_REALL_1Dr


END MODULE INITIALISE 
