set terminal png truecolor
set output 'stress.png'
unset mxtics
unset mytics
unset key
set logscale y
set logscale x
set ylabel 'stress'
set xlabel 'time'
set format x "10^{%T}"
set format y "10^{%T}"
#set tics font "Helvetica,24"
set style data lines
set yrange[0.001:1]
set xrange[0.1:10000]
plot for [fn in system("ls sgr.*/stress*.dat")]fn using ($1-2000):2 lw 3 ti fn
