set terminal postscript enhanced color eps size 4.5, 2.8
set output 'stress.a8.taux100.eps'
unset mxtics
unset mytics
unset key
set xlabel 'time'
set ylabel 'stress'
set logscale x
set logscale y
set format x "10^{%T}"
set format y "10^{%T}"
set style data lines
#set xtics offset -0.05,graph -0.020
set ytics offset 0.7,graph 0.01
set xtics (1, 100, 10000, 1000000)  
set xrange[1:500000]
set yrange[0.001:1.0]
set linetype 1 lc 1
set linetype 2 lc 2 
set linetype 3 lc 7
set linetype 4 lc 4
set linetype 5 lc 8
set linetype 7 lc rgbcolor "dark-green" 
plot for [fn in system("ls ./a8.taux100/*.dat")]fn using 1:2 lw 5
set output 'stress.a8.taux1.eps'
plot for [fn in system("ls ./a8.taux1/*.dat")]fn using 1:2 lw 5
set output 'stress.a0.eps'
plot for [fn in system("ls ./a0/*.dat")]fn using 1:2 lw 5
set output 'stress.a8.taux100.homo.eps'
plot for [fn in system("ls ./a8.taux100.homo/*.dat")]fn using 1:2 lw 5

