set terminal postscript enhanced color eps
set output 'Ldistl.eps'
set size 0.6, 0.6
unset key
set format x "%2.1f" 
set format y "10^{%T}"
set xtics (-0.5,0,0.5)
set palette rgbformulae 7,5,15
set xlabel 'strain'
set ylabel 'P(strain - solidlike band), stress decay'
set style data lines
set xrange[-0.6:0.6]
set yrange[0.002:0.2]
set logscale y
plot for [fn in system("ls Ldist[1-2,5].dat")]fn using 1:($3/1000) w lines lw 6, for [fn in system("ls Ldist[1-2]0.dat")]fn using 1:($3/1000) w lines lw 6, 'Ldist50.dat' using 1:($3/1000) w lines lw 6 lc rgbcolor 'red'
set output 'Ldistl2.eps'
set ylabel 'P(strain - solidlike band), stress increase'
plot for [fn in system("ls Ldist100.dat")]fn using 1:($3/1000) w lines lw 6,for [fn in system("ls Ldist200.dat")]fn using 1:($3/1000) w lines lw 6, for [fn in system("ls Ldist500.dat")]fn using 1:($3/1000) w lines lw 6,  for [fn in system("ls Ldist1000.dat")]fn using 1:($3/1000) w lines lw 6
