unset key
unset logscale x
unset logscale y
set xrange[0.0:0.45]
set yrange[0.3:1.0]
set format x "%4.1f"
set format y "%4.1f"
set style data lines
set terminal postscript color eps 
set termoption dashed
set output 'flowcurve.eps'
set xlabel 'average strain rate'
set ylabel 'stress'
set size 0.6, 0.4
if (GPVAL_VERSION >= 5.0) set for [i=1:6] linetype i dashtype 1
if (GPVAL_VERSION >= 5.0) set for [i=7:12] linetype i dashtype 2 
set tics font "Helvetica,18"
set xtics 0.0, 0.1, 0.4
set ytics 0.2
set ytics offset 0,graph 0.01
set xtics offset 0,graph -0.02 
set style data lines
plot for [fn in system("ls a0.ls.hetero")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 1, for [fn in system("ls a1.ls.hetero")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 14,  for [fn in system("ls a2.ls.hetero")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 2, for [fn in system("ls a4.ls.hetero")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 7, for [fn in system("ls a8.ls.hetero")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 4, for [fn in system("ls a16.ls.hetero")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 8 dt 1, for [fn in system("ls a0.ls.homo")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 1, for [fn in system("ls a1.ls.homo")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 14, for [fn in system("ls a2.ls.homo")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 2, for [fn in system("ls a4.ls.homo")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 7, for [fn in system("ls a8.ls.homo")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 4, for [fn in system("ls a16.ls.homo")]fn every 3 using 1:(0.05*$1+$2) lw 3 lc 8 dt 2,for [fn in system("ls a8.ls.fig2")]fn every 3 using 1:(0.05*$1+$2) with points pt 2 ps 1.5 lw 5 lc 4, for [fn in system("ls a0.ls.fig2")]fn using 1:(0.05*$1+$2) with points pt 2 ps 1.5 lw 5 lc 1 
