function convert_to_latex_array(arr,filename) # function for converting arrays, such as CPC matricies to latex formatted arrays

% GNU octave code for function for converting integer arrays, such as CPC matricies to latex formatted arrays
% written by Nicholas Chancellor
% written in connection with arXiv:1611.08012 by N. Chancellor, A. Kissenger, J. Roffe, S. Zohren, and D. Horsman
% feel free to resuse/modify but please attribute the source and cite our paper in any published work
 
% get array dimensions
arraySize1=size(arr,1);
arraySize2=size(arr,2);

strCellLines=cell(arraySize1,1); % lines of the text file to be returned

for i1=1:arraySize1 % iterate through lines
  strCellChars=cell(arraySize2,1); % each element in a line
  for i2=1:arraySize2 % iterate through numbers on line
    strCellChars{i2}=num2str(arr(i1,i2)); % convert to in then string
  end
  strCellLines{i1}=strjoin(strCellChars,' & '); % latex formatted line
end

latex_array=strjoin(strCellLines,' \\\\\n') % latex formatted array

fid = fopen (filename, "w");
fputs (fid, latex_array); % save latex formatted array
fclose (fid);
