% GNU octave code for finding distance 3 CSS codes using random search in the CPC formalism
% written by Nicholas Chancellor
% based on the methods of arXiv:1611.08012 by N. Chancellor,A. Kissenger, S. Zohren, J. Roffe, and D. Horsman
% feel free to resuse/modify but please attribute the source and cite our paper in any published work

n=9; % total number of qubits
k=4; % number of data qubits being protected

nCheck=10000; % number of random codes to checks
nKeep=10; % maximum number of successful codes to keep

MbCell=cell(nKeep,1); % cellular array of bit checks for successful codes
MpCell=cell(nKeep,1); % cellular array of phase checks for successful codes
McCell=cell(nKeep,1); % cellular array of cross checks for successful codes

nSuccess=0; % number codes successfully found

binConvert=2.^(0:(n-k-1)); % vector used later to convert binary numbers to integers

for iRand=1:nCheck % loop for generating random instances
  Mb=round(rand(k,n-k)); % random bit check matrix
  Mp=round(rand(k,n-k)); % random phase check matrix
  Mc=round(rand(n-k,n-k)); % random cross check matrix
  Mc=triu(Mc); % make cross check matrix upper triangular
  Mc=Mc-diag(diag(Mc)); % make cross check matrix strictly upper triangular
  syndromeList=zeros(n-k,2*n+1); % list for storing syndromes for all error patterns with up to a single error
  iSyndrome=2; % leave first vector in list blank to signify case of no error
  
  for iBitData=1:k % syndromes for bit flip errors on data qubits
    bitErrVec=zeros(1,k); % vector listing bit errors
    bitErrVec(iBitData)=1; % add single bit error
    syndromeList(:,iSyndrome)=bitErrVec*Mb; % calculate syndrome
    iSyndrome=iSyndrome+1; % increment for storing in list
  end
  for iPhaseData=1:k % syndromes for phase errors on data qubits
    phaseErrVec=zeros(1,k); % vector listing phase errors
    phaseErrVec(iPhaseData)=1; % add single phase error
    syndromeList(:,iSyndrome)=phaseErrVec*Mp; % calculate syndrome
    iSyndrome=iSyndrome+1; % increment for storing in list
  end
  for iBitPar=1:(n-k) % syndromes for bit flip errors on parity check qubits
    bitErrVec=zeros(1,n-k); % vector listing bit errors
    bitErrVec(iBitPar)=1; % add single bit error
    syndromeList(:,iSyndrome)=bitErrVec; % calculate syndrome
    iSyndrome=iSyndrome+1; % increment for storing in list
  end
  for iPhasePar=1:(n-k) % syndromes for phase errors on parity check qubits
    phaseErrVec=zeros(1,n-k); % vector listing phase errors
    phaseErrVec(iPhasePar)=1; % add single phase error
    syndromeList(:,iSyndrome)=mod(phaseErrVec*(Mc+transpose(Mc)+transpose(Mp)*Mb),2); % calculate syndrome
    iSyndrome=iSyndrome+1; % increment for storing in list
  end
  syndromeNums=binConvert*syndromeList; % treat as binary numbers and convert to decimal for easier comparison
  if length(unique(syndromeNums))==length(syndromeNums) % check if syndromes are unique
    nSuccess=nSuccess+1; % another code successfully found!
    if nSuccess<(nKeep+1) % only keep so many codes to avoid memory issues
      MbCell{nSuccess}=transpose(Mb); % store bit check matrix, transpose to agree with convention in paper
      MpCell{nSuccess}=transpose(Mp); % store phase check matrix, transpose to agree with convention in paper
      McCell{nSuccess}=Mc; % store cross check matrix
    end
  end
end
