% GNU octave code for finding CSS codes of arbitray code distance using random search in the CPC formalism
% written by Nicholas Chancellor
% based on the methods of arXiv:1611.08012 by N. Chancellor,A. Kissenger, J. Roffe, S. Zohren, and D. Horsman
% feel free to resuse/modify but please attribute the source and cite our paper in any published work

n=16; % total number of qubits
k=4; % number of data qubits being protected
nErr=2; % number of errors code needs to be tolerant to (d=2*nErr+1 under most circumstances)

nCheck=1000; % number of random codes to checks
nKeep=10; % maximum number of successful codes to keep

MbCell=cell(nKeep,1); % cellular array of bit checks for successful codes
MpCell=cell(nKeep,1); % cellular array of phase checks for successful codes
McCell=cell(nKeep,1); % cellular array of cross checks for successful codes

nSuccess=0; % number codes successfully found

binConvert=2.^(0:(n-k-1)); % vector used later to convert binary numbers to integers

for iRand=1:nCheck % loop for generating random instances
  Mb=round(rand(k,n-k)); % random bit check matrix
  Mp=round(rand(k,n-k)); % random phase check matrix
  Mc=round(rand(n-k,n-k)); % random cross check matrix
  Mc=triu(Mc); % make cross check matrix upper triangular
  Mc=Mc-diag(diag(Mc)); % make cross check matrix strictly upper triangular
  nSyndrome=0; 
  for nErr1=0:nErr
    nSyndrome=nSyndrome+nchoosek(2*n,nErr1); % number of unique syndromes which need to be checked
  end
  syndromeList=zeros(n-k,nSyndrome); % list for storing syndromes for all error patterns with up nErr errors
  iSyndrome=2; % leave first vector in list blank to signify case of no error
  
  for inErr=1:nErr % loop over number of errors
    errList=zeros(2*n,1);
    errList(1:inErr)=1; % configuration of inErr errors which corresponds to the smallest possible binary number
    for iConfig=1:nchoosek(2*n,inErr)
      % syndromes for bit flip errors on data qubits
      bitErrVec=errList(1:k)'; % vector listing bit errors
      syndromeList(:,iSyndrome)=syndromeList(:,iSyndrome)'+bitErrVec*Mb; % calculate syndrome
      % syndromes for phase errors on data qubits
      phaseErrVec=errList((k+1):(2*k))'; % vector listing phase errors
      syndromeList(:,iSyndrome)=syndromeList(:,iSyndrome)'+phaseErrVec*Mp; % calculate syndrome
      % syndromes for bit flip errors on parity check qubits
      bitErrVecPar=errList((2*k+1):(k+n))'; % vector listing bit errors
      syndromeList(:,iSyndrome)=syndromeList(:,iSyndrome)+bitErrVecPar'; % calculate syndrome
      % syndromes for phase errors on parity check qubits
      phaseErrVecPar=errList((k+n+1):end)'; % vector listing phase errors
      syndromeList(:,iSyndrome)=syndromeList(:,iSyndrome)'+mod(phaseErrVecPar*(Mc+transpose(Mc)+transpose(Mp)*Mb),2); % calculate syndrome
      syndromeList(:,iSyndrome)=mod(syndromeList(:,iSyndrome),2); % errors add mod 2
      iSyndrome=iSyndrome+1; % increment for storing in list
      for iIncr=1:(2*n-1) % increment error list
        if errList(iIncr)==1 && errList(iIncr+1)==0 % if error can be moved up by one slot
          errList(iIncr)=0;
          errList(iIncr+1)=1; % move error up
          nErrLess=nnz(errList(1:iIncr));
          errList(1:iIncr)=zeros(iIncr,1);
          errList(1:nErrLess)=1; % bits below moved bit reset to lowest value
          break % break look after successfully incrementing
        end
      end
    end
    
  end
  
  syndromeNums=binConvert*syndromeList; % treat as binary numbers and convert to decimal for easier comparison
  if length(unique(syndromeNums))==length(syndromeNums) % check if syndromes are unique
    nSuccess=nSuccess+1; % another code successfully found!
    if nSuccess<(nKeep+1) % only keep so many codes to avoid memory issues
      MbCell{nSuccess}=transpose(Mb); % store bit check matrix, transpose to agree with convention in paper
      MpCell{nSuccess}=transpose(Mp); % store phase check matrix, transpose to agree with convention in paper
      McCell{nSuccess}=Mc; % store cross check matrix
    end
  end
end
