function CPC_mats_2_stabalizers(Mb,Mp,Mc,saveName)

% GNU Octave code for converting CPC matricies to stabalizer tables in latex array form
% written by Nicholas Chancellor
% based on the methods of arXiv:1611.08012 by N. Chancellor,A. Kissenger, J. Roffe, S. Zohren, and D. Horsman
% feel free to resuse/modify but please attribute the source and cite our paper in any published work

% Mb, Mp, and Mc are bit phase and cross check matricies written in the format given in arXiv:1611.08012
% saveName is the name of the text file where the stabalizer matrix is saved

Mb=transpose(Mb); % convention in paper is transpose of what is used in code
Mp=transpose(Mp); % convention in paper is transpose of what is used in code

k=size(Mb,1); % number of logical qubits

n=size(Mb,1)+size(Mb,2); % number of total qubits

strCellLines=cell(n-k,1); % cellular array for storing lines of the latex array

indirectProp=Mp'*Mb; % indirectly propagated phase information

for i=1:(n-k) % iterate over stabalizers
  strCellChars=cell(n,1); % cell for storing (X, Z, Y or 1) elements of stabalizer row
  numZmultList=zeros(n,1); % number of times a Z stabalizer element is found on a given qubit
  numXmultList=zeros(n,1); % number of times an X stabalizer element is found on a given qubit
  % apply matrix formula to create stabalizers
  % Z stabalizers
  numZmultList(k+i)=numZmultList(k+i)+1; % bit information of measured qubit
  numZmultList(1:k)=numZmultList(1:k)+Mb(:,i); % bit information from measured qubits
  % X stabalizers
  numXmultList(1:k)=numXmultList(1:k)+Mp(:,i); % phase information from measured qubits
  numXmultList((k+1):end)=numXmultList((k+1):end)+Mc(:,i)+Mc(i,:)'; % phase information propagated by cross checks
  numXmultList((k+1):end)=numXmultList((k+1):end)+indirectProp(:,i); % phase information propagated indriectly
  % write stabalizer table  
  for iWrite=1:n 
    if mod(numZmultList(iWrite),2)==0 && mod(numXmultList(iWrite),2)==0 % if there are neither X nor Z stabalizers
      strCellChars{iWrite}='1';
    elseif mod(numZmultList(iWrite),2)==1 && mod(numXmultList(iWrite),2)==0 % if there is only a Z stabalizer
      strCellChars{iWrite}='Z';
    elseif mod(numZmultList(iWrite),2)==0 && mod(numXmultList(iWrite),2)==1 % if there is only an X stabalizer
      strCellChars{iWrite}='X';
    elseif mod(numZmultList(iWrite),2)==1 && mod(numXmultList(iWrite),2)==1 % if there are both X and Z stabalizers
      strCellChars{iWrite}='Y'; % X and Z combine to form Y
    end
  end
  strCellLines{i}=strjoin(strCellChars,' & '); % latex formatted characters for line
end

latex_array=strjoin(strCellLines,' \\\\\n'); % combine lines to make total latex array

% write latex array to file
fid = fopen (saveName, "w");
fputs (fid, latex_array);
fclose (fid);
