# python3 code for finding CSS codes of arbitray code distance using random search in the CPC formalism
# written by Nicholas Chancellor
# based on the methods of arXiv:1611.08012 by N. Chancellor, A. Kissenger, J. Roffe, S. Zohren, and D. Horsman
# feel free to resuse/modify but please attribute the source and cite our paper in any published work

import numpy as np
import numpy.random as r
import scipy as scp
import scipy.misc as misc

n=9 # total number of qubits
k=4 # number of data qubits being protected
nErr=1# number of errors code needs to be tolerant to (d=nErr+2 under most circumstances)

nCheck=10000 # number of random codes to checks
nKeep=10 # maximum number of successful codes to keep

MbCell=[None]*nKeep # list of bit checks matricies for successful codes
MpCell=[None]*nKeep # list of phase checks for successful codes
McCell=[None]*nKeep # list of cross checks for successful codes

nSuccess=0 # number of codes successfully found

binConvert=2**np.arange(n-k) # vector which will be useful later for converting to binary

for iRand in range(nCheck): # loop for generating random code matricies
	Mb=np.round(r.rand(k,n-k)) # random bit check matrix
	Mp=np.round(r.rand(k,n-k)) # random phase check matrix
	Mc=np.round(r.rand(n-k,n-k)) # random cross check matrix
	Mc=np.triu(Mc) # make cross check matrix upper triangular
	Mc=Mc-np.diag(np.diag(Mc)) # make cross check matrix strictly upper triangular
	nSyndrome=0
	for nErr1 in range(0,nErr+1):
		nSyndrome=nSyndrome+misc.comb(2*n,nErr1) # number of unique syndromes which need to be checked
	syndromeList=np.zeros([int(n-k),int(nSyndrome)]) # list for storing syndromes for all error patterns with up nErr errors
	iSyndrome=1; # leave first vector in list blank to signify case of no error
	
	for inErr in range(1,nErr+1): # loop over number of errors
		errList=np.zeros([2*n,1])
		errList[range(inErr)]=1; # configuration of inErr errors which corresponds to the smallest possible binary number
		for iConfig in range(int(misc.comb(2*n,inErr))):
			# syndromes for bit flip errors on data qubits
			bitErrVec=np.transpose(errList[range(k)]) # vector listing bit errors
			syndromeList[:,iSyndrome]=np.transpose(syndromeList[:,iSyndrome])+np.dot(bitErrVec,Mb) # calculate syndrome
			# syndromes for phase errors on data qubits
			phaseErrVec=np.transpose(errList[range(k,2*k)]) # vector listing phase errors
			syndromeList[:,iSyndrome]=np.transpose(syndromeList[:,iSyndrome])+np.dot(phaseErrVec,Mp) # calculate syndrome
			# syndromes for bit flip errors on parity check qubits
			bitErrVecPar=np.transpose(errList[range(2*k,k+n)]) # vector listing bit errors
			syndromeList[:,iSyndrome]=syndromeList[:,iSyndrome]+bitErrVecPar # calculate syndrome
            # syndromes for phase errors on parity check qubits
			phaseErrVecPar=np.transpose(errList[range(k+n,len(errList))]) # vector listing phase errors
			syndromeList[:,iSyndrome]=np.transpose(syndromeList[:,iSyndrome])+np.mod(np.dot(phaseErrVecPar,(Mc+np.transpose(Mc)+np.dot(np.transpose(Mp),Mb))),2); # calculate syndrome
			syndromeList[:,iSyndrome]=np.mod(syndromeList[:,iSyndrome],2); # errors add mod 2
			iSyndrome=iSyndrome+1 # increment for storing in list
			for iIncr in range(2*n-1): # increment error list
				if errList[iIncr]==1 and errList[iIncr+1]==0: # if error can be moved up by one slot
					errList[iIncr]=0
					errList[iIncr+1]=1 # move error up
					nErrLess=(errList[range(iIncr)]!=0).sum()
					errList[range(iIncr)]=np.zeros([iIncr,1])
					errList[range(nErrLess)]=1 # bits below moved bit reset to lowest value
					break  # break look after successfully incrementing
	
	syndromeNums=np.dot(binConvert,syndromeList) # treat as binary numbers and convert to decimal for easier comparison
	if len(np.unique(syndromeNums))==len(syndromeNums): # check if syndromes are unique
		nSuccess=nSuccess+1 # another code successfully found!
		if (nSuccess-1)<nKeep: # only keep so many codes to avoid memory issues
			MbCell[nSuccess-1]=Mb.T # store bit check matrix, transposed to agree with convention in paper
			MpCell[nSuccess-1]=Mp.T # store phase check matrix, transposed to agree with convention in paper
			McCell[nSuccess-1]=Mc # store cross check matrix

np.save('MbCell',MbCell)
np.save('MpCell',MpCell)
np.save('McCell',McCell)
print(str(nSuccess)+' out of '+str(nCheck)+' succeeded')
