from qiskit import IBMQ, QuantumCircuit, QuantumRegister, ClassicalRegister, execute, Aer
# from qiskit.tools import job_monitor
from qiskit.tools.visualization import plot_histogram
from qiskit.providers.aer.noise import NoiseModel
import qiskit.providers.aer.noise as noise
from qiskit.quantum_info.analysis import hellinger_fidelity
import numpy as np

qr = QuantumRegister(4)
cr = ClassicalRegister(4)
coin = QuantumRegister(1)

circ = QuantumCircuit(qr,coin,cr)

#####################################

def increment_gate(circ,sub,q):
    #circ.h(sub[0])
    circ.mcx([sub[0],q[3],q[2],q[1]],q[0])
    circ.mcx([sub[0],q[3],q[2]],q[1])
    circ.ccx(sub[0],q[3],q[2])
    circ.cx(sub[0],q[3])
    circ.barrier()


def decrement_gate(circ,sub,q):
    circ.x(q[1])
    circ.x(q[2])
    circ.x(q[3])
    circ.x(sub[0])
    
    circ.mcx([sub[0],q[3],q[2],q[1]],q[0])
    circ.x(q[1])
    circ.mcx([sub[0],q[3],q[2]],q[1])
    circ.x(q[2])
    circ.ccx(sub[0],q[3],q[2])
    circ.x(q[3])
    circ.cx(sub[0],q[3])
    circ.x(sub[0])
    circ.barrier()


#######################################
############## CIRCUIT ################
#######################################

def Build_circuit(steps,circ):
    for i in range(steps):
        circ.h(coin[0])
        increment_gate(circ,coin,qr)
        decrement_gate(circ,coin,qr)


#Circuit Build
Build_circuit(16,circ)


#Measure
circ.measure(qr[0],cr[3])
circ.measure(qr[1],cr[2])
circ.measure(qr[2],cr[1])
circ.measure(qr[3],cr[0])


#circ.draw('mpl')


#######################################
############## Execution ##############
#######################################

#Simulator
#######################################
backend = Aer.get_backend('qasm_simulator')
job = execute(circ,backend=backend,shots=1000)
result = job.result()
res = result.get_counts(circ)


#Noise Simulator
#####################################

#Error probabilities
prob_1 = 0.005 #1-qubit gate
prob_2 = 0.02 #2-qubit gate
prob_3 = 0.04 #3-qubit gate
prob_4 = 0.6 #mcx gate

#Depolarising errors
error_1 = noise.depolarizing_error(prob_1, 1)
error_2 = noise.depolarizing_error(prob_2, 2)
error_3 = noise.depolarizing_error(prob_3, 3)
error_4 = noise.depolarizing_error(prob_4, 4)

#Adding errors to noise model
noise_model = noise.NoiseModel()
noise_model.add_all_qubit_quantum_error(error_1, ['u1','u2','u3','id'])
noise_model.add_all_qubit_quantum_error(error_2, ['cx'])
noise_model.add_all_qubit_quantum_error(error_3, ['ccx'])
noise_model.add_all_qubit_quantum_error(error_4, ['mcx'])


#Santiago Noise Model
provider = IBMQ.load_account()
backend_noise = provider.get_backend('ibmq_santiago')
noise_model_Santiago = NoiseModel.from_backend(backend_noise)
coupling_map = backend_noise.configuration().coupling_map
basis_gates_Santiago = noise_model_Santiago.basis_gates


#Execution
job_noise_custom = execute(circ,backend=backend,shots=1000,coupling_map=None,noise_model=noise_model,basis_gates=basis_gates_Santiago)
result_noise_custom = job_noise_custom.result()
res_noise_custom = result_noise_custom.get_counts(circ)


job_noise = execute(circ,backend=backend,shots=1000,coupling_map=coupling_map,noise_model=noise_model_Santiago,basis_gates=basis_gates_Santiago)
result_noise = job_noise.result()
res_noise = result_noise.get_counts(circ)

#Real Backend
#####################################
# backend_real = provider.get_backend('ibmq_santiago')
# job_real = execute(circ,backend=backend_real,shots=1000)
# result_real = job_real.result()
# res_real = result_real.get_counts(circ)


#Hellinger Fidelity

fidelity_noise_custom = hellinger_fidelity(res, res_noise_custom)
print('Hellinger Fidelity:', fidelity_noise_custom)

# print(res_noise,res_noise_custom)
# legend=['Noise Simulation (Santiago)','Custom Noise Model']
# plot_histogram([res_noise,res_noise_custom],legend=legend,title='QW 16 Nodes, Custom Noise, Steps=1')