from qiskit import IBMQ, QuantumCircuit, QuantumRegister, ClassicalRegister, execute, Aer
from qiskit.tools import job_monitor
from qiskit.tools.visualization import plot_histogram
import numpy as np
from qiskit.quantum_info.analysis import hellinger_fidelity
#import matplotlib.pyplot as plt

IBMQ.load_account()
provider = IBMQ.get_provider('ibm-q')


n=3
step=8



qr=QuantumRegister(n)
coin=QuantumRegister(1)
cr=ClassicalRegister(n)

circuit= QuantumCircuit(qr,coin,cr)


def cnx(circ,*qbits):
    if len(qbits) >=3:
        #last=qbits[-1]
        
        circ.crz(np.pi/2,qbits[-2],qbits[-1])
        circ.cu(np.pi/2, 0, 0, 0, qbits[-2], qbits[-1])
        
        cnx(circ,*qbits[:-2],qbits[-1])
        
        circ.cu(-np.pi/2, 0, 0, 0, qbits[-2], qbits[-1])
        
        cnx(circ,*qbits[:-2],qbits[-1])
        
        circ.crz(-np.pi/2,qbits[-2],qbits[-1])
    elif len(qbits)==3:
        circ.ccx(*qbits)
    elif len(qbits)==2:
        circ.cx(*qbits)


def increment_gate(circ,q,sub):
    cnx(circ,sub,q[2],q[1],q[0])
    cnx(circ,sub,q[2],q[1])
    cnx(circ,sub,q[2])
    circ.barrier()



def decrement_gate(circ,q,sub):
    circ.x(sub)
    circ.x(q[2])
    circ.x(q[1])
    cnx(circ,sub,q[2],q[1],q[0])
    circ.x(q[1])
    cnx(circ,sub,q[2],q[1])
    circ.x(q[2])
    cnx(circ,sub,q[2])
    circ.x(sub)
    circ.barrier()




def Build(circ,times):
    for i in range(times):
        circ.h(coin[0])
        increment_gate(circ, qr,coin[0])
        decrement_gate(circ, qr,coin[0])
        circ.measure(qr[0],cr[2])
        circ.measure(qr[1],cr[1])
        circ.measure(qr[2],cr[0])
        

def Simulate(circ):
    backend=Aer.get_backend('qasm_simulator')
    job=execute(circ, backend=backend, shots=1000)
    result=job.result()
    res=result.get_counts(circ)
    return res


def Simulate_Real(circ):
    backend=provider.get_backend('ibmq_quito')
    job=execute(circ, backend=backend, shots=1000)
    job_monitor(job)
    result=job.result()
    res=result.get_counts(circ)
    return res


Build(circuit,step)
result_sim=Simulate(circuit)
result_real=Simulate_Real(circuit)
print('simulator results:',result_sim)
print('real result:',result_real)
legend=['Simulator', 'Real']
plot_histogram([result_sim, result_real], legend=None, figsize=(8,6))
#plot_histogram(result_real)

fidelity = hellinger_fidelity(result_sim, result_real)
print('Hellinger Fidelity:', fidelity)






   