from qiskit import IBMQ, QuantumCircuit, QuantumRegister, ClassicalRegister, execute, Aer
from qiskit.tools import job_monitor
from qiskit.tools.visualization import plot_histogram
from qiskit.quantum_info.analysis import hellinger_fidelity

IBMQ.load_account()
provider = IBMQ.get_provider('ibm-q')

qr=QuantumRegister(3)
coin=QuantumRegister(1)
cr=ClassicalRegister(2)

circuit = QuantumCircuit(qr,coin,cr)

def step_gate(circ,coin,q):
    circ.h(coin[0])
    circ.cx(coin[0],q[1])
    circ.cx(coin[0],q[0])
    circ.x(coin[0])
    circ.cx(coin[0],q[1])
    


#Circuit section
step_gate(circuit,coin,qr)
step_gate(circuit,coin,qr)
circuit.h(coin[0])

step_gate(circuit,coin,qr)
circuit.h(coin[0])
step_gate(circuit,coin,qr)
#circuit.h(coin[0])
#step_gate(circuit,coin,qr)
#circuit.h(coin[0])
#step_gate(circuit,coin,qr)


circuit.measure(qr[0],cr[1])
circuit.measure(qr[1],cr[0])

backend=Aer.get_backend('qasm_simulator')
job = execute(circuit, backend=backend, shots=1000)
result = job.result()
res = result.get_counts(circuit)

backend_real=provider.get_backend('ibmq_quito')
job_real = execute(circuit, backend=backend_real, shots=1000)
job_monitor(job_real)
result_real = job_real.result()
res_real = result_real.get_counts(circuit)

plot_histogram([res,res_real],figsize=(8,6))


fidelity= hellinger_fidelity(res, res_real)

print('simulator results:',res)
print('real result:',res_real)
print('Hellinger Fidelity:', fidelity)